/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.form;

import com.microsoft.azure.toolkit.lib.common.form.AzureFormInput;
import com.microsoft.azure.toolkit.lib.common.form.AzureValidationInfo;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import reactor.core.publisher.Flux;

public interface AzureForm<T>
extends AzureFormInput<T> {
    @Override
    public T getValue();

    @Override
    public void setValue(T var1);

    @Override
    @Nonnull
    default public AzureValidationInfo validateInternal(T value) {
        List<AzureValidationInfo> infos = this.validateAllInputs();
        if (!1.$assertionsDisabled && infos.size() != this.getInputs().size()) {
            throw new AssertionError((Object)"some inputs have no validation info.");
        }
        AzureValidationInfo info = infos.stream().min(Comparator.comparing(AzureValidationInfo::getType)).orElse(AzureValidationInfo.pending(this));
        this.setValidationInfo(info);
        return info;
    }

    default public List<AzureValidationInfo> validateAllInputs() {
        return (List)this.validateAllInputsAsync().collectList().block();
    }

    default public Flux<AzureValidationInfo> validateAllInputsAsync() {
        return Flux.fromIterable(this.getInputs()).flatMap(i -> i.validateValueAsync().flux());
    }

    default public List<AzureValidationInfo> getAllValidationInfos(boolean revalidateIfNone) {
        return this.getInputs().stream().map(input -> input.getValidationInfo(revalidateIfNone)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<AzureFormInput<?>> getInputs();

    @Deprecated
    default public List<AzureValidationInfo> validateData() {
        return this.validateAllInputs();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

