/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.AzService;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzService;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.resource.AzureResources;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Azure {
    private static final Logger log;
    private final AzureConfiguration configuration = new AzureConfiguration();
    private static final Azure defaultInstance;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    private Azure() {
    }

    public static synchronized <T extends AzService> T az(Class<T> clazz) {
        AzService service = Optional.ofNullable(Azure.getService(clazz)).orElseGet(() -> {
            ServiceManager.reload();
            return Azure.getService(clazz);
        });
        String message = String.format("Azure service(%s) not supported", clazz.getSimpleName());
        return (T)Optional.ofNullable(service).orElseThrow(() -> new AzureToolkitRuntimeException(message));
    }

    @Nullable
    private static <T extends AzService> T getService(Class<T> clazz) {
        return (T)((AzService)ServiceManager.getServices().stream().filter(clazz::isInstance).map(clazz::cast).findAny().orElse(null));
    }

    @Nullable
    private static AzService getService(String provider) {
        return ServiceManager.getServices().stream().filter(s -> StringUtils.equalsIgnoreCase((CharSequence)provider, (CharSequence)s.getName())).findAny().orElse(null);
    }

    @Nonnull
    public static <T extends AzService> List<T> getServices(Class<T> clazz) {
        return ServiceManager.getServices().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    @Nullable
    @AzureOperation(name="resource.get.id", params={"id"}, type=AzureOperation.Type.SERVICE)
    public AbstractAzResource<?, ?, ?> getById(String id) {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        try {
            AbstractAzResource abstractAzResource;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ResourceId resourceId = ResourceId.fromString((String)id);
            String provider = Optional.ofNullable(resourceId.providerNamespace()).orElse("Microsoft.Resources");
            AzService service = Azure.getService(provider);
            AbstractAzResource result = null;
            if (service instanceof AbstractAzService) {
                result = (AbstractAzResource)service.getById(id);
            }
            if (result == null) {
                log.warn(String.format("fallback to AzureResources because no valid service provider for '%s' is found.", id));
                abstractAzResource = (AbstractAzResource)Azure.az(AzureResources.class).getById(id);
            } else {
                abstractAzResource = result;
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return abstractAzResource;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    @AzureOperation(name="resource.get.id", params={"id"}, type=AzureOperation.Type.SERVICE)
    public AbstractAzResource<?, ?, ?> getOrInitById(String id) {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        try {
            AbstractAzResource abstractAzResource;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ResourceId resourceId = ResourceId.fromString((String)id);
            String provider = Optional.ofNullable(resourceId.providerNamespace()).orElse("Microsoft.Resources");
            AzService service = Azure.getService(provider);
            AbstractAzResource result = null;
            if (service instanceof AbstractAzService) {
                result = (AbstractAzResource)service.getOrInitById(id);
            }
            if (result == null) {
                log.warn(String.format("fallback to AzureResources because no valid service provider for '%s' is found.", id));
                abstractAzResource = (AbstractAzResource)Azure.az(AzureResources.class).getOrInitById(id);
            } else {
                abstractAzResource = result;
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return abstractAzResource;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public static Azure az() {
        return defaultInstance;
    }

    public AzureConfiguration config() {
        return this.configuration;
    }

    static {
        Azure.ajc$preClinit();
        log = LoggerFactory.getLogger(Azure.class);
        defaultInstance = new Azure();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Azure.java", Azure.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getById", "com.microsoft.azure.toolkit.lib.Azure", "java.lang.String", "id", "", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource"), 61);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOrInitById", "com.microsoft.azure.toolkit.lib.Azure", "java.lang.String", "id", "", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource"), 78);
    }

    private static class ServiceManager {
        private static final ServiceLoader<AzService> loader = ServiceLoader.load(AzService.class, Azure.class.getClassLoader());
        private static final List<AzService> services = new ArrayList<AzService>();

        private ServiceManager() {
        }

        public static synchronized List<AzService> getServices() {
            if (services.isEmpty()) {
                ServiceManager.reload();
            }
            return services;
        }

        public static synchronized void reload() {
            loader.reload();
            services.clear();
            loader.forEach(services::add);
        }
    }
}

