/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.appservice.handlers.artifact;

import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import org.apache.commons.net.ftp.FTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPUploader {
    private static final Logger log = LoggerFactory.getLogger(FTPUploader.class);
    public static final String UPLOAD_START = "Uploading files to FTP server: ";
    public static final String UPLOAD_SUCCESS = "Successfully uploaded files to FTP server: ";
    public static final String UPLOAD_FAILURE = "Failed to upload files to FTP server, retrying immediately (%d/%d)";
    public static final String UPLOAD_RETRY_FAILURE = "Failed to upload files to FTP server after %d retries...";
    public static final String UPLOAD_DIR_START = "Uploading directory: %s --> %s";
    public static final String UPLOAD_DIR_FINISH = "Successfully uploaded directory: %s --> %s";
    public static final String UPLOAD_DIR_FAILURE = "Failed to upload directory: %s --> %s";
    public static final String UPLOAD_DIR = "%s[DIR] %s --> %s";
    public static final String UPLOAD_FILE = "%s[FILE] %s --> %s";
    public static final String UPLOAD_FILE_REPLY = "%s.......Reply Message : %s";

    public void uploadDirectoryWithRetries(String ftpServer, String username, String password, String sourceDirectory, String targetDirectory, int maxRetryCount) throws AzureExecutionException {
        for (int retryCount = 0; retryCount < maxRetryCount; ++retryCount) {
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(UPLOAD_START + ftpServer);
            if (this.uploadDirectory(ftpServer, username, password, sourceDirectory, targetDirectory)) {
                messager.success(UPLOAD_SUCCESS + ftpServer);
                return;
            }
            messager.warning(String.format(UPLOAD_FAILURE, retryCount, maxRetryCount));
        }
        throw new AzureExecutionException(String.format(UPLOAD_RETRY_FAILURE, maxRetryCount));
    }

    protected boolean uploadDirectory(String ftpServer, String username, String password, String sourceDirectoryPath, String targetDirectoryPath) {
        IAzureMessager messager = AzureMessager.getMessager();
        log.debug("FTP username: " + username);
        try {
            FTPClient ftpClient = this.getFTPClient(ftpServer, username, password);
            messager.info(String.format(UPLOAD_DIR_START, sourceDirectoryPath, targetDirectoryPath));
            this.uploadDirectory(ftpClient, sourceDirectoryPath, targetDirectoryPath, "");
            messager.success(String.format(UPLOAD_DIR_FINISH, sourceDirectoryPath, targetDirectoryPath));
            ftpClient.disconnect();
            return true;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            messager.error(String.format(UPLOAD_DIR_FAILURE, sourceDirectoryPath, targetDirectoryPath));
            return false;
        }
    }

    protected void uploadDirectory(FTPClient ftpClient, String sourceDirectoryPath, String targetDirectoryPath, String logPrefix) throws IOException {
        IAzureMessager messager = AzureMessager.getMessager();
        messager.info(String.format(UPLOAD_DIR, logPrefix, sourceDirectoryPath, targetDirectoryPath));
        File sourceDirectory = new File(sourceDirectoryPath);
        File[] files = sourceDirectory.listFiles();
        if (files == null || files.length == 0) {
            messager.info(String.format("%sEmpty directory at %s", logPrefix, sourceDirectoryPath));
            return;
        }
        boolean isTargetDirectoryExist = ftpClient.changeWorkingDirectory(targetDirectoryPath);
        if (!isTargetDirectoryExist) {
            ftpClient.makeDirectory(targetDirectoryPath);
        }
        String nextLevelPrefix = logPrefix + "..";
        for (File file : files) {
            if (file.isFile()) {
                this.uploadFile(ftpClient, file.getAbsolutePath(), targetDirectoryPath, nextLevelPrefix);
                continue;
            }
            this.uploadDirectory(ftpClient, Paths.get(sourceDirectoryPath, file.getName()).toString(), targetDirectoryPath + "/" + file.getName(), nextLevelPrefix);
        }
    }

    protected void uploadFile(FTPClient ftpClient, String sourceFilePath, String targetFilePath, String logPrefix) throws IOException {
        IAzureMessager messager = AzureMessager.getMessager();
        messager.info(String.format(UPLOAD_FILE, logPrefix, sourceFilePath, targetFilePath));
        File sourceFile = new File(sourceFilePath);
        try (FileInputStream is = new FileInputStream(sourceFile);){
            ftpClient.changeWorkingDirectory(targetFilePath);
            ftpClient.storeFile(sourceFile.getName(), (InputStream)is);
            int replyCode = ftpClient.getReplyCode();
            String replyMessage = ftpClient.getReplyString();
            if (this.isCommandFailed(replyCode)) {
                messager.error(String.format(UPLOAD_FILE_REPLY, logPrefix, replyMessage));
                throw new IOException("Failed to upload file: " + sourceFilePath);
            }
            messager.info(String.format(UPLOAD_FILE_REPLY, logPrefix, replyMessage));
        }
    }

    protected FTPClient getFTPClient(String ftpServer, String username, String password) throws IOException {
        FTPClient ftpClient = new FTPClient();
        ftpClient.connect(ftpServer);
        ftpClient.login(username, password);
        ftpClient.setFileType(2);
        ftpClient.enterLocalPassiveMode();
        return ftpClient;
    }

    private boolean isCommandFailed(int replyCode) {
        return replyCode >= 300;
    }
}

