/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.plan;

import com.azure.resourcemanager.appservice.fluent.models.AppServicePlanInner;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlanModule;
import com.microsoft.azure.toolkit.lib.appservice.webapp.AzureWebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AppServicePlan
extends AbstractAzResource<AppServicePlan, AppServiceServiceSubscription, com.azure.resourcemanager.appservice.models.AppServicePlan>
implements Deletable {
    protected AppServicePlan(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull AppServicePlanModule module) {
        super(name, resourceGroupName, (AbstractAzResourceModule)module);
    }

    protected AppServicePlan(@Nonnull AppServicePlan origin) {
        super((AbstractAzResource)origin);
    }

    protected AppServicePlan(@Nonnull com.azure.resourcemanager.appservice.models.AppServicePlan remote, @Nonnull AppServicePlanModule module) {
        super(remote.name(), remote.resourceGroupName(), (AbstractAzResourceModule)module);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, AppServicePlan, ?>> getSubModules() {
        return Collections.emptyList();
    }

    @Nonnull
    public String loadStatus(@Nonnull com.azure.resourcemanager.appservice.models.AppServicePlan plan) {
        return Optional.ofNullable((AppServicePlanInner)plan.innerModel()).map(AppServicePlanInner::provisioningState).map(ProvisioningState::toString).orElse("Unknown");
    }

    public List<WebApp> getWebApps() {
        return ((AzureWebApp)Azure.az(AzureWebApp.class)).webApps(this.getSubscriptionId()).list().stream().filter(webapp -> StringUtils.equals((CharSequence)Objects.requireNonNull(webapp.getAppServicePlan()).getId(), (CharSequence)this.getId())).collect(Collectors.toList());
    }

    public PricingTier getPricingTier() {
        return this.remoteOptional(new boolean[0]).map(com.azure.resourcemanager.appservice.models.AppServicePlan::pricingTier).map(t -> PricingTier.fromString(t.toSkuDescription().tier(), t.toSkuDescription().size())).orElse(null);
    }

    @Nullable
    public Region getRegion() {
        return this.remoteOptional(new boolean[0]).map(Resource::regionName).map(Region::fromName).orElse(null);
    }

    public OperatingSystem getOperatingSystem() {
        return this.remoteOptional(new boolean[0]).map(r -> r.operatingSystem().name()).map(OperatingSystem::fromString).orElse(null);
    }
}

