/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppModule;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionsServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class AzureFunctions
extends AzureAppService {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Nonnull
    public FunctionAppModule functionApps(@Nonnull String subscriptionId) {
        AppServiceServiceSubscription rm = (AppServiceServiceSubscription)this.get(subscriptionId, null);
        assert (rm != null);
        return rm.getFunctionAppModule();
    }

    @Nonnull
    public List<FunctionApp> functionApps() {
        return this.list().stream().flatMap(m -> m.functionApps().list().stream()).collect(Collectors.toList());
    }

    @Nullable
    public FunctionApp functionApp(String resourceId) {
        ResourceId id = ResourceId.fromString((String)resourceId);
        return (FunctionApp)this.functionApps(id.subscriptionId()).get(id.name(), id.resourceGroupName());
    }

    @Nonnull
    @AzureOperation(name="function.list_runtimes.os|version", params={"os.getValue()", "version.getValue()"}, type=AzureOperation.Type.SERVICE)
    public List<Runtime> listFunctionAppRuntimes(@Nonnull OperatingSystem os, @Nonnull JavaVersion version) {
        OperatingSystem operatingSystem = os;
        JavaVersion javaVersion = version;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)((Object)operatingSystem), (Object)javaVersion);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            List<Runtime> list = Runtime.FUNCTION_APP_RUNTIME.stream().filter(runtime -> Objects.equals((Object)os, (Object)runtime.getOperatingSystem()) && Objects.equals(version, runtime.getJavaVersion())).collect(Collectors.toList());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @Nonnull
    protected AppServiceServiceSubscription newResource(@Nonnull AppServiceManager remote) {
        return new FunctionsServiceSubscription(remote, (AzureAppService)this);
    }

    static {
        AzureFunctions.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AzureFunctions.java", AzureFunctions.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listFunctionAppRuntimes", "com.microsoft.azure.toolkit.lib.appservice.function.AzureFunctions", "com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem:com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion", "os:version", "", "java.util.List"), 46);
    }
}

