/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.deploy;

import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebDeployment;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.blob.BlobContainerPublicAccessType;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.toolkit.lib.appservice.deploy.DeployUtils;
import com.microsoft.azure.toolkit.lib.appservice.deploy.IFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.legacy.function.AzureStorageHelper;
import java.io.File;
import java.text.SimpleDateFormat;
import java.time.Period;
import java.util.Date;

public class MSFunctionDeployHandler
implements IFunctionDeployHandler {
    private static final String DEPLOYMENT_PACKAGE_CONTAINER = "java-functions-deployment-packages";
    private static final String UPLOAD_PACKAGE_START = "Step 1 of 3: Uploading ZIP file to Azure Storage...";
    private static final String UPLOAD_PACKAGE_DONE = "Successfully uploaded ZIP file to ";
    private static final String DEPLOY_PACKAGE_START = "Step 2 of 3: Deploying package to Azure Function App...";
    private static final String DEPLOY_PACKAGE_DONE = "Successfully deployed to Azure Function App.";
    private static final String DELETE_PACKAGE_START = "Step 3 of 3: Deleting deployment package from Azure Storage...";
    private static final String DELETE_PACKAGE_DONE = "Successfully deleted deployment package ";
    private static final String DELETE_PACKAGE_FAIL = "Failed to delete deployment package ";

    @Override
    public void deploy(File file, WebAppBase webAppBase) {
        CloudStorageAccount storageAccount = DeployUtils.getCloudStorageAccount(webAppBase);
        String blobName = this.getBlobName(webAppBase);
        String packageUri = this.uploadPackageToAzureStorage(file, storageAccount, blobName);
        this.deployWithPackageUri(webAppBase, packageUri, () -> this.deletePackageFromAzureStorage(storageAccount, blobName));
    }

    private String getBlobName(WebAppBase functionApp) {
        return functionApp.name().concat(new SimpleDateFormat(".yyyyMMddHHmmssSSS").format(new Date())).concat(".zip");
    }

    private String uploadPackageToAzureStorage(File zipPackage, CloudStorageAccount storageAccount, String blobName) {
        AzureMessager.getMessager().info(UPLOAD_PACKAGE_START);
        try {
            CloudBlockBlob blob = AzureStorageHelper.uploadFileAsBlob(zipPackage, storageAccount, DEPLOYMENT_PACKAGE_CONTAINER, blobName, BlobContainerPublicAccessType.OFF);
            String packageUri = AzureStorageHelper.getSASToken((CloudBlob)blob, Period.ofDays(1));
            AzureMessager.getMessager().info(UPLOAD_PACKAGE_DONE + blob.getUri().toString());
            return packageUri;
        }
        catch (AzureExecutionException e) {
            throw new AzureToolkitRuntimeException("Failed to upload package to azure storage", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployWithPackageUri(WebAppBase target, String packageUri, Runnable onDeployFinish) {
        try {
            AzureMessager.getMessager().info(DEPLOY_PACKAGE_START);
            ((WebDeployment)target.deploy().withPackageUri(packageUri).execute()).complete();
            AzureMessager.getMessager().info(DEPLOY_PACKAGE_DONE);
        }
        finally {
            onDeployFinish.run();
        }
    }

    private void deletePackageFromAzureStorage(CloudStorageAccount storageAccount, String blobName) {
        try {
            AzureMessager.getMessager().info(DELETE_PACKAGE_START);
            AzureStorageHelper.deleteBlob(storageAccount, DEPLOYMENT_PACKAGE_CONTAINER, blobName);
            AzureMessager.getMessager().info(DELETE_PACKAGE_DONE + blobName);
        }
        catch (Exception e) {
            AzureMessager.getMessager().error(DELETE_PACKAGE_FAIL + blobName);
        }
    }
}

