/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.util;

import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LocalFileSystemUtils {
    private static final List<String> CANDIDATE_USERNAME_ENVIRONMENT_VARIABLES = Collections.unmodifiableList(Arrays.asList("USER", "LOGNAME", "USERNAME"));

    public static File getTempDir() {
        String currentUserName;
        String tempDirectory = System.getProperty("java.io.tmpdir");
        File result = LocalFileSystemUtils.getTempDir(tempDirectory, currentUserName = LocalFileSystemUtils.determineCurrentUserName());
        if (!result.isDirectory()) {
            result.mkdirs();
        }
        return result;
    }

    static File getTempDir(String initialValue, String userName) {
        String tempDirectory = initialValue;
        if ("/tmp".contentEquals(tempDirectory)) {
            File candidate = new File(tempDirectory, userName);
            tempDirectory = candidate.getAbsolutePath();
        }
        File result = new File(tempDirectory);
        return result;
    }

    public static String determineCurrentUserName() {
        String userName = System.getProperty("user.name");
        if (LocalStringsUtils.isNullOrEmpty(userName)) {
            String candidate;
            Iterator<String> iterator = CANDIDATE_USERNAME_ENVIRONMENT_VARIABLES.iterator();
            while (iterator.hasNext() && LocalStringsUtils.isNullOrEmpty(userName = System.getenv(candidate = iterator.next()))) {
            }
        }
        if (LocalStringsUtils.isNullOrEmpty(userName)) {
            userName = "unknown";
        }
        return userName;
    }
}

