/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.quickpulse;

import com.microsoft.applicationinsights.core.dependencies.http.client.methods.HttpPost;
import com.microsoft.applicationinsights.internal.channel.common.ApacheSender;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseDataSender;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseNetworkHelper;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseStatus;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;

final class DefaultQuickPulseDataSender
implements QuickPulseDataSender {
    private final QuickPulseNetworkHelper networkHelper = new QuickPulseNetworkHelper();
    private final ApacheSender apacheSender;
    private volatile QuickPulseStatus quickPulseStatus;
    private volatile boolean stopped = false;
    private long lastValidTransmission = 0L;
    private final ArrayBlockingQueue<HttpPost> sendQueue;

    public DefaultQuickPulseDataSender(ApacheSender apacheSender, ArrayBlockingQueue<HttpPost> sendQueue) {
        this.apacheSender = apacheSender;
        this.sendQueue = sendQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
lbl1:
        // 2 sources

        try lbl-1000:
        // 8 sources

        {
            block11: while (!this.stopped) {
                post = this.sendQueue.take();
                if (this.quickPulseStatus != QuickPulseStatus.QP_IS_ON) continue;
                sendTime = System.nanoTime();
                response = null;
                try {
                    response = this.apacheSender.sendPostRequest(post);
                    if (!this.networkHelper.isSuccess(response)) continue;
                    quickPulseResultStatus = this.networkHelper.getQuickPulseStatus(response);
                    switch (1.$SwitchMap$com$microsoft$applicationinsights$internal$quickpulse$QuickPulseStatus[quickPulseResultStatus.ordinal()]) {
                        case 1: 
                        case 2: {
                            this.lastValidTransmission = sendTime;
                            this.quickPulseStatus = quickPulseResultStatus;
                            ** break;
                        }
                        case 3: {
                            this.onPostError(sendTime);
                            ** break;
                        }
                        ** default:
lbl20:
                        // 1 sources

                        continue block11;
                    }
                }
                catch (IOException e) {
                    this.onPostError(sendTime);
                }
                finally {
                    if (response == null) ** GOTO lbl1
                    this.apacheSender.dispose(response);
                }
            }
        }
        catch (Throwable t) {
            this.stopped = true;
            this.quickPulseStatus = QuickPulseStatus.ERROR;
        }
    }

    @Override
    public void startSending() {
        if (!this.stopped) {
            this.quickPulseStatus = QuickPulseStatus.QP_IS_ON;
        }
    }

    @Override
    public QuickPulseStatus getQuickPulseStatus() {
        return this.quickPulseStatus;
    }

    @Override
    public void stop() {
        this.stopped = true;
        this.quickPulseStatus = QuickPulseStatus.ERROR;
    }

    private void onPostError(long sendTime) {
        if (this.stopped) {
            return;
        }
        double timeFromLastValidTransmission = (double)(sendTime - this.lastValidTransmission) / 1.0E9;
        if (timeFromLastValidTransmission >= 20.0) {
            this.quickPulseStatus = QuickPulseStatus.ERROR;
        }
    }
}

