/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.internal.annotation.PerformanceModule;
import com.microsoft.applicationinsights.internal.config.PerformanceCountersXmlElement;
import com.microsoft.applicationinsights.internal.config.WindowsPerformanceCounterXmlElement;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.AbstractPerformanceCounterModule;
import com.microsoft.applicationinsights.internal.perfcounter.JniPCConnector;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounterConfigurationAware;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCountersFactory;
import com.microsoft.applicationinsights.internal.perfcounter.ProcessBuiltInPerformanceCountersFactory;
import com.microsoft.applicationinsights.internal.perfcounter.WindowsPerformanceCounterData;
import com.microsoft.applicationinsights.internal.perfcounter.WindowsPerformanceCountersFactory;
import com.microsoft.applicationinsights.internal.system.SystemInformation;
import java.util.ArrayList;

@PerformanceModule(value="BuiltIn")
public final class ProcessPerformanceCountersModule
extends AbstractPerformanceCounterModule
implements PerformanceCounterConfigurationAware {
    public ProcessPerformanceCountersModule() throws Exception {
        this(new ProcessBuiltInPerformanceCountersFactory());
    }

    public ProcessPerformanceCountersModule(PerformanceCountersFactory factory) throws Exception {
        super(factory);
        if (!(factory instanceof WindowsPerformanceCountersFactory)) {
            throw new Exception("Factory must implement windows capabilities.");
        }
    }

    @Override
    public void addConfigurationData(PerformanceCountersXmlElement configuration) {
        if (!SystemInformation.INSTANCE.isWindows()) {
            InternalLogger.INSTANCE.trace("Windows performance counters are not relevant on this OS.", new Object[0]);
            return;
        }
        if (!JniPCConnector.initialize()) {
            InternalLogger.INSTANCE.error("Failed to initialize JNI connection.", new Object[0]);
            return;
        }
        ArrayList<WindowsPerformanceCounterXmlElement> windowsPCs = configuration.getWindowsPCs();
        if (windowsPCs == null || windowsPCs.isEmpty()) {
            return;
        }
        ArrayList<WindowsPerformanceCounterData> configurationRequests = new ArrayList<WindowsPerformanceCounterData>();
        for (WindowsPerformanceCounterXmlElement element : windowsPCs) {
            try {
                WindowsPerformanceCounterData data = new WindowsPerformanceCounterData().setDisplayName(element.getDisplayName()).setCategoryName(element.getCategoryName()).setCounterName(element.getCounterName()).setInstanceName(element.getInstanceName());
                configurationRequests.add(data);
            }
            catch (Throwable e) {
                InternalLogger.INSTANCE.error("Failed to initialize Windows performance counter '%s'.", e.getMessage());
            }
        }
        if (configurationRequests.isEmpty()) {
            InternalLogger.INSTANCE.error("Failed to initialize Windows performance counters: All requested performance counters are not valid.", new Object[0]);
        } else {
            ((WindowsPerformanceCountersFactory)((Object)this.factory)).setWindowsPCs(configurationRequests);
        }
    }
}

