/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.agent;

import com.microsoft.applicationinsights.agent.internal.coresync.AgentNotificationsHandler;
import com.microsoft.applicationinsights.agent.internal.coresync.impl.ImplementationsCoordinator;
import com.microsoft.applicationinsights.internal.agent.CoreAgentNotificationsHandler;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.ThreadLocalCleaner;

public enum AgentConnector {
    INSTANCE;

    private String agentKey;
    private RegistrationType registrationType = RegistrationType.NONE;
    private CoreAgentNotificationsHandler coreDataAgent = null;

    public synchronized RegistrationResult register(ClassLoader classLoader, String name) {
        switch (this.registrationType) {
            case NONE: {
                try {
                    this.coreDataAgent = new CoreAgentNotificationsHandler(name);
                    this.agentKey = ImplementationsCoordinator.INSTANCE.register(classLoader, (AgentNotificationsHandler)this.coreDataAgent);
                }
                catch (Throwable t) {
                    InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Could not find Agent: '%s'", t.getMessage());
                    this.agentKey = null;
                }
                this.registrationType = RegistrationType.WEB;
                return new RegistrationResult(this.agentKey, this.coreDataAgent.getCleaner());
            }
            case WEB: {
                return new RegistrationResult(this.agentKey, this.coreDataAgent.getCleaner());
            }
            case SELF: {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Core was already registered by the Agent", new Object[0]);
                return null;
            }
        }
        InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Unknown registration type '%s' found", new Object[]{this.registrationType});
        return null;
    }

    public synchronized boolean registerSelf() {
        switch (this.registrationType) {
            case NONE: {
                try {
                    this.coreDataAgent = new CoreAgentNotificationsHandler("app");
                }
                catch (Throwable t) {
                    InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Could not find Agent: '%s'", t.getMessage());
                    return false;
                }
                ImplementationsCoordinator.INSTANCE.registerSelf((AgentNotificationsHandler)this.coreDataAgent);
                this.registrationType = RegistrationType.SELF;
                return true;
            }
            case WEB: {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Core was already registered by the Web module", new Object[0]);
                return false;
            }
            case SELF: {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.INFO, "Core was already registered by the Agent, ignored", new Object[0]);
                return true;
            }
        }
        InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Unknown registration type '%s' found", new Object[]{this.registrationType});
        return false;
    }

    public static class RegistrationResult {
        private final String key;
        private final ThreadLocalCleaner cleaner;

        public RegistrationResult(String key, ThreadLocalCleaner cleaner) {
            this.key = key;
            this.cleaner = cleaner;
        }

        public String getKey() {
            return this.key;
        }

        public ThreadLocalCleaner getCleaner() {
            return this.cleaner;
        }
    }

    static enum RegistrationType {
        NONE,
        WEB,
        SELF;

    }
}

