/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternatorv2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.amazonaws.services.dynamodbv2.model.transform.BatchGetItemRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.BatchGetItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.BatchWriteItemRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.BatchWriteItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ConditionalCheckFailedExceptionUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.CreateTableRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.CreateTableResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.DeleteItemRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.DeleteItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.DeleteTableRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.DeleteTableResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.DescribeTableRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.DescribeTableResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.GetItemRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.GetItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ListTablesRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ListTablesResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProvisionedThroughputExceededExceptionUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.PutItemRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.PutItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.QueryRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.QueryResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ResourceInUseExceptionUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ScanRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ScanResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.UpdateItemRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.UpdateItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.UpdateTableRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.UpdateTableResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternatorDBClientV2
extends AmazonWebServiceClient
implements AmazonDynamoDB {
    private static final Log log = LogFactory.getLog(AlternatorDBClientV2.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;

    public AlternatorDBClientV2() {
        this(new ClientConfiguration());
    }

    public AlternatorDBClientV2(ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, JSONObject>)new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, JSONObject>)new InternalServerErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, JSONObject>)new ProvisionedThroughputExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, JSONObject>)new ResourceInUseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, JSONObject>)new ConditionalCheckFailedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, JSONObject>)new ResourceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, JSONObject>)new JsonErrorUnmarshaller());
        this.setEndpoint("http://localhost:9090/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/dynamodb/request.handlers"));
        this.clientConfiguration = new ClientConfiguration(this.clientConfiguration);
        if (this.clientConfiguration.getRetryPolicy() == ClientConfiguration.DEFAULT_RETRY_POLICY) {
            log.debug((Object)"Overriding default max error retry value to: 10");
            this.clientConfiguration.setMaxErrorRetry(10);
        }
        this.setConfiguration(this.clientConfiguration);
    }

    public ListTablesResult listTables(ListTablesRequest listTablesRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new ListTablesRequestMarshaller().marshall(listTablesRequest);
        ListTablesResultJsonUnmarshaller unmarshaller = new ListTablesResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (ListTablesResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public QueryResult query(QueryRequest queryRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new QueryRequestMarshaller().marshall(queryRequest);
        QueryResultJsonUnmarshaller unmarshaller = new QueryResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (QueryResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public BatchWriteItemResult batchWriteItem(BatchWriteItemRequest batchWriteItemRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new BatchWriteItemRequestMarshaller().marshall(batchWriteItemRequest);
        BatchWriteItemResultJsonUnmarshaller unmarshaller = new BatchWriteItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (BatchWriteItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public BatchWriteItemResult batchWriteItem(Map<String, List<WriteRequest>> requestItems) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("batchWriteItem using Map is not implemented in Alternator.");
    }

    public UpdateItemResult updateItem(UpdateItemRequest updateItemRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new UpdateItemRequestMarshaller().marshall(updateItemRequest);
        UpdateItemResultJsonUnmarshaller unmarshaller = new UpdateItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (UpdateItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public UpdateItemResult updateItem(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates, String returnValues) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("updateItem using String, Map, Map, and String is not implemented in Alternator.");
    }

    public UpdateItemResult updateItem(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("updateItem using String, Map, and Map is not implemented in Alternator.");
    }

    public PutItemResult putItem(PutItemRequest putItemRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new PutItemRequestMarshaller().marshall(putItemRequest);
        PutItemResultJsonUnmarshaller unmarshaller = new PutItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (PutItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public PutItemResult putItem(String tableName, Map<String, AttributeValue> item, String returnValues) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("putItem using String, Map, and String is not implemented in Alternator.");
    }

    public PutItemResult putItem(String tableName, Map<String, AttributeValue> item) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("putItem using String and Map is not implemented in Alternator.");
    }

    public DescribeTableResult describeTable(DescribeTableRequest describeTableRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new DescribeTableRequestMarshaller().marshall(describeTableRequest);
        DescribeTableResultJsonUnmarshaller unmarshaller = new DescribeTableResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (DescribeTableResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public DescribeTableResult describeTable(String tableName) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("describeTable using String is not implemented in Alternator.");
    }

    public ScanResult scan(ScanRequest scanRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new ScanRequestMarshaller().marshall(scanRequest);
        ScanResultJsonUnmarshaller unmarshaller = new ScanResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (ScanResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public ScanResult scan(String tableName, List<String> attributesToGet, Map<String, Condition> scanFilter) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("scan using String, List, and Map is not implemented in Alternator.");
    }

    public ScanResult scan(String tableName, Map<String, Condition> scanFilter) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("scan using String and Map is not implemented in Alternator.");
    }

    public ScanResult scan(String tableName, List<String> attributesToGet) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("scan using String and List is not implemented in Alternator.");
    }

    public CreateTableResult createTable(CreateTableRequest createTableRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new CreateTableRequestMarshaller().marshall(createTableRequest);
        CreateTableResultJsonUnmarshaller unmarshaller = new CreateTableResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (CreateTableResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public CreateTableResult createTable(List<AttributeDefinition> attributeDefinitions, String tableName, List<KeySchemaElement> keySchema, ProvisionedThroughput provisionedThroughput) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("createTable using List, String, List, and ProvisionedThroughput is not implemented in Alternator.");
    }

    public UpdateTableResult updateTable(UpdateTableRequest updateTableRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new UpdateTableRequestMarshaller().marshall(updateTableRequest);
        UpdateTableResultJsonUnmarshaller unmarshaller = new UpdateTableResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (UpdateTableResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public UpdateTableResult updateTable(String tableName, ProvisionedThroughput provisionedThroughput) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("updateTable using String and ProvisionedThroughput is not implemented in Alternator.");
    }

    public DeleteTableResult deleteTable(DeleteTableRequest deleteTableRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new DeleteTableRequestMarshaller().marshall(deleteTableRequest);
        DeleteTableResultJsonUnmarshaller unmarshaller = new DeleteTableResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (DeleteTableResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public DeleteTableResult deleteTable(String tableName) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("deleteTable using String is not implemented in Alternator.");
    }

    public DeleteItemResult deleteItem(DeleteItemRequest deleteItemRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new DeleteItemRequestMarshaller().marshall(deleteItemRequest);
        DeleteItemResultJsonUnmarshaller unmarshaller = new DeleteItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (DeleteItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public DeleteItemResult deleteItem(String tableName, Map<String, AttributeValue> key, String returnValues) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("deleteTable using String, Map, and String is not implemented in Alternator.");
    }

    public DeleteItemResult deleteItem(String tableName, Map<String, AttributeValue> key) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("deleteItem using String and Map is not implemented in Alternator.");
    }

    public GetItemResult getItem(GetItemRequest getItemRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new GetItemRequestMarshaller().marshall(getItemRequest);
        GetItemResultJsonUnmarshaller unmarshaller = new GetItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (GetItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public GetItemResult getItem(String tableName, Map<String, AttributeValue> key, Boolean consistentRead) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("getItem using String, Map, and Boolean is not implemented in Alternator.");
    }

    public GetItemResult getItem(String tableName, Map<String, AttributeValue> key) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("getItem using String and Map is not implemented in Alternator.");
    }

    public BatchGetItemResult batchGetItem(BatchGetItemRequest batchGetItemRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new BatchGetItemRequestMarshaller().marshall(batchGetItemRequest);
        BatchGetItemResultJsonUnmarshaller unmarshaller = new BatchGetItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (BatchGetItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public BatchGetItemResult batchGetItem(Map<String, KeysAndAttributes> requestItems) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("batchGetItem using Map is not implemented in Alternator.");
    }

    public BatchGetItemResult batchGetItem(Map<String, KeysAndAttributes> requestItems, String returnConsumedCapacity) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("batchGetItem using Map and String is not implemented in Alternator.");
    }

    public ListTablesResult listTables() throws AmazonServiceException, AmazonClientException {
        return this.listTables(new ListTablesRequest());
    }

    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        super.setEndpoint(endpoint, "dynamodb", null);
    }

    public ListTablesResult listTables(Integer limit) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("listTables using Integer is not implemented in Alternator.");
    }

    public ListTablesResult listTables(String exclusiveStartTableName, Integer limit) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("listTables using String and Integer is not implemented in Alternator.");
    }

    public ListTablesResult listTables(String exclusiveStartTableName) throws AmazonServiceException, AmazonClientException {
        throw new AmazonClientException("listTables using String is not implemented in Alternator.");
    }

    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler) {
        request.setEndpoint(this.endpoint);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        ExecutionContext executionContext = this.createExecutionContext(request);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        Response result = this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
        return (X)result.getAwsResponse();
    }
}

