/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternatorv2;

import com.amazonaws.services.dynamodb.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodb.model.BatchResponse;
import com.amazonaws.services.dynamodb.model.CreateTableRequest;
import com.amazonaws.services.dynamodb.model.DeleteItemRequest;
import com.amazonaws.services.dynamodb.model.DeleteItemResult;
import com.amazonaws.services.dynamodb.model.DescribeTableResult;
import com.amazonaws.services.dynamodb.model.GetItemResult;
import com.amazonaws.services.dynamodb.model.Key;
import com.amazonaws.services.dynamodb.model.KeySchema;
import com.amazonaws.services.dynamodb.model.ListTablesRequest;
import com.amazonaws.services.dynamodb.model.ListTablesResult;
import com.amazonaws.services.dynamodb.model.QueryRequest;
import com.amazonaws.services.dynamodb.model.ScanResult;
import com.amazonaws.services.dynamodb.model.TableDescription;
import com.amazonaws.services.dynamodb.model.UpdateItemRequest;
import com.amazonaws.services.dynamodb.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import com.michelboudreau.alternator.models.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternatorDBApiVersion2Mapper {
    public static Map<String, com.amazonaws.services.dynamodb.model.AttributeValue> MapV2ItemToV1(Map<String, AttributeValue> v2Item) {
        HashMap<String, com.amazonaws.services.dynamodb.model.AttributeValue> v1Item = null;
        if (v2Item != null) {
            v1Item = new HashMap<String, com.amazonaws.services.dynamodb.model.AttributeValue>();
            for (String key : v2Item.keySet()) {
                AttributeValue v2Value = v2Item.get(key);
                com.amazonaws.services.dynamodb.model.AttributeValue v1Value = AlternatorDBApiVersion2Mapper.MapV2AttributeValueToV1(v2Value);
                v1Item.put(key, v1Value);
            }
        }
        return v1Item;
    }

    public static Map<String, AttributeValue> MapV1ItemToV2(Map<String, com.amazonaws.services.dynamodb.model.AttributeValue> v1Item) {
        HashMap<String, AttributeValue> v2Item = null;
        if (v1Item != null) {
            v2Item = new HashMap<String, AttributeValue>();
            for (String key : v1Item.keySet()) {
                com.amazonaws.services.dynamodb.model.AttributeValue value = v1Item.get(key);
                AttributeValue v2Value = AlternatorDBApiVersion2Mapper.MapV1AttributeValueToV2(value);
                v2Item.put(key, v2Value);
            }
        }
        return v2Item;
    }

    public static Map<String, com.amazonaws.services.dynamodb.model.ExpectedAttributeValue> MapV2ExpectedToV1(Map<String, ExpectedAttributeValue> v2Expected) {
        HashMap<String, com.amazonaws.services.dynamodb.model.ExpectedAttributeValue> v1Expected = null;
        if (v2Expected != null) {
            v1Expected = new HashMap<String, com.amazonaws.services.dynamodb.model.ExpectedAttributeValue>();
            for (String key : v2Expected.keySet()) {
                ExpectedAttributeValue v2ExpValue = v2Expected.get(key);
                com.amazonaws.services.dynamodb.model.ExpectedAttributeValue v1ExpValue = AlternatorDBApiVersion2Mapper.MapV2ExpectedAttributeValueToV1(v2ExpValue);
                v1Expected.put(key, v1ExpValue);
            }
        }
        return v1Expected;
    }

    public static com.amazonaws.services.dynamodb.model.AttributeValue MapV2AttributeValueToV1(AttributeValue v2Value) {
        com.amazonaws.services.dynamodb.model.AttributeValue v1Value = null;
        if (v2Value != null) {
            v1Value = new com.amazonaws.services.dynamodb.model.AttributeValue().withB(v2Value.getB()).withBS((Collection)v2Value.getBS()).withN(v2Value.getN()).withNS((Collection)v2Value.getNS()).withS(v2Value.getS()).withSS((Collection)v2Value.getSS());
        }
        return v1Value;
    }

    public static AttributeValue MapV1AttributeValueToV2(com.amazonaws.services.dynamodb.model.AttributeValue v1Value) {
        AttributeValue v2Value = new AttributeValue().withB(v1Value.getB()).withBS((Collection)v1Value.getBS()).withN(v1Value.getN()).withNS((Collection)v1Value.getNS()).withS(v1Value.getS()).withSS((Collection)v1Value.getSS());
        return v2Value;
    }

    public static com.amazonaws.services.dynamodb.model.ExpectedAttributeValue MapV2ExpectedAttributeValueToV1(ExpectedAttributeValue v2Expected) {
        com.amazonaws.services.dynamodb.model.ExpectedAttributeValue v1Expected = new com.amazonaws.services.dynamodb.model.ExpectedAttributeValue().withExists(v2Expected.getExists()).withValue(AlternatorDBApiVersion2Mapper.MapV2AttributeValueToV1(v2Expected.getValue()));
        return v1Expected;
    }

    public static AttributeValueUpdate MapV2AttributeValueUpdateToV1(com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate v2AttrUpdate) {
        AttributeValueUpdate v1AttrUpdate = new AttributeValueUpdate().withValue(AlternatorDBApiVersion2Mapper.MapV2AttributeValueToV1(v2AttrUpdate.getValue())).withAction(v2AttrUpdate.getAction());
        return v1AttrUpdate;
    }

    public static Map<String, AttributeValueUpdate> MapV2AttributeUpdatesToV1(Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate> v2AttrUpdates) {
        HashMap<String, AttributeValueUpdate> v1AttrUpdates = null;
        if (v2AttrUpdates != null) {
            v1AttrUpdates = new HashMap<String, AttributeValueUpdate>();
            for (String key : v2AttrUpdates.keySet()) {
                com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate v2AttrUpdate = v2AttrUpdates.get(key);
                AttributeValueUpdate v1AttrUpdate = AlternatorDBApiVersion2Mapper.MapV2AttributeValueUpdateToV1(v2AttrUpdate);
                v1AttrUpdates.put(key, v1AttrUpdate);
            }
        }
        return v1AttrUpdates;
    }

    public static Key MapV2KeyToV1(Map<String, AttributeValue> v2Key, Table table) {
        Key v1Key = null;
        if (v2Key != null && table != null) {
            v1Key = new Key();
            for (String attrName : v2Key.keySet()) {
                AttributeValue v2AttrValue = v2Key.get(attrName);
                if (attrName.equals(table.getHashKeyName())) {
                    v1Key.setHashKeyElement(AlternatorDBApiVersion2Mapper.MapV2AttributeValueToV1(v2AttrValue));
                    continue;
                }
                if (!attrName.equals(table.getRangeKeyName())) continue;
                v1Key.setRangeKeyElement(AlternatorDBApiVersion2Mapper.MapV2AttributeValueToV1(v2AttrValue));
            }
        }
        return v1Key;
    }

    public static Map<String, AttributeValue> MapV1KeyToV2(Key v1Key, Table table) {
        HashMap<String, AttributeValue> v2Key = null;
        if (v1Key != null) {
            v2Key = new HashMap<String, AttributeValue>();
            if (v1Key.getHashKeyElement() != null) {
                v2Key.put(table.getHashKeyName(), AlternatorDBApiVersion2Mapper.MapV1AttributeValueToV2(v1Key.getHashKeyElement()));
            }
            if (v1Key.getRangeKeyElement() != null) {
                v2Key.put(table.getRangeKeyName(), AlternatorDBApiVersion2Mapper.MapV1AttributeValueToV2(v1Key.getRangeKeyElement()));
            }
        }
        return v2Key;
    }

    public static com.amazonaws.services.dynamodb.model.KeysAndAttributes MapV2KeysAndAttributesToV1(KeysAndAttributes v2KeysAndAttr, Table table) {
        ArrayList<Key> v1Keys = new ArrayList<Key>();
        for (Map v2Key : v2KeysAndAttr.getKeys()) {
            v1Keys.add(AlternatorDBApiVersion2Mapper.MapV2KeyToV1(v2Key, table));
        }
        com.amazonaws.services.dynamodb.model.KeysAndAttributes v1KeysAndAttr = new com.amazonaws.services.dynamodb.model.KeysAndAttributes().withAttributesToGet((Collection)v2KeysAndAttr.getAttributesToGet()).withConsistentRead(v2KeysAndAttr.getConsistentRead()).withKeys(v1Keys);
        return v1KeysAndAttr;
    }

    public static KeysAndAttributes MapV1KeysAndAttributesToV2(com.amazonaws.services.dynamodb.model.KeysAndAttributes v1KeysAndAttr, Table table) {
        ArrayList<Map<String, AttributeValue>> v2Keys = new ArrayList<Map<String, AttributeValue>>();
        for (Key v1Key : v1KeysAndAttr.getKeys()) {
            v2Keys.add(AlternatorDBApiVersion2Mapper.MapV1KeyToV2(v1Key, table));
        }
        KeysAndAttributes v2KeysAndAttr = new KeysAndAttributes().withAttributesToGet((Collection)v1KeysAndAttr.getAttributesToGet()).withConsistentRead(v1KeysAndAttr.getConsistentRead()).withKeys(v2Keys);
        return v2KeysAndAttr;
    }

    public static com.amazonaws.services.dynamodbv2.model.TableDescription MapV2TableDescriptionToV1(TableDescription table) {
        ArrayList<AttributeDefinition> v2Attributes = new ArrayList<AttributeDefinition>();
        ArrayList<KeySchemaElement> v2KeySchema = new ArrayList<KeySchemaElement>();
        KeySchema keySchema = table.getKeySchema();
        if (keySchema != null) {
            if (keySchema.getHashKeyElement() != null) {
                v2Attributes.add(new AttributeDefinition().withAttributeName(keySchema.getHashKeyElement().getAttributeName()).withAttributeType(keySchema.getHashKeyElement().getAttributeType()));
                v2KeySchema.add(new KeySchemaElement().withAttributeName(keySchema.getHashKeyElement().getAttributeName()).withKeyType("HASH"));
            }
            if (keySchema.getRangeKeyElement() != null) {
                v2Attributes.add(new AttributeDefinition().withAttributeName(keySchema.getRangeKeyElement().getAttributeName()).withAttributeType(keySchema.getRangeKeyElement().getAttributeType()));
                v2KeySchema.add(new KeySchemaElement().withAttributeName(keySchema.getRangeKeyElement().getAttributeName()).withKeyType("RANGE"));
            }
        }
        ProvisionedThroughputDescription v2ThruPut = null;
        com.amazonaws.services.dynamodb.model.ProvisionedThroughputDescription v1ThruPut = table.getProvisionedThroughput();
        if (v1ThruPut != null) {
            v2ThruPut = new ProvisionedThroughputDescription().withReadCapacityUnits(v1ThruPut.getReadCapacityUnits()).withWriteCapacityUnits(v1ThruPut.getWriteCapacityUnits()).withLastDecreaseDateTime(v1ThruPut.getLastDecreaseDateTime()).withLastIncreaseDateTime(v1ThruPut.getLastIncreaseDateTime());
        }
        com.amazonaws.services.dynamodbv2.model.TableDescription v2Table = new com.amazonaws.services.dynamodbv2.model.TableDescription().withTableName(table.getTableName()).withTableStatus(table.getTableStatus()).withAttributeDefinitions(v2Attributes).withKeySchema(v2KeySchema).withCreationDateTime(table.getCreationDateTime()).withProvisionedThroughput(v2ThruPut);
        return v2Table;
    }

    public static Map<String, com.amazonaws.services.dynamodb.model.Condition> MapV2ScanFilterToV1(Map<String, Condition> v2Filter) {
        HashMap<String, com.amazonaws.services.dynamodb.model.Condition> v1Filter = null;
        if (v2Filter != null) {
            v1Filter = new HashMap<String, com.amazonaws.services.dynamodb.model.Condition>();
            for (String key : v2Filter.keySet()) {
                Condition v2Condition = v2Filter.get(key);
                com.amazonaws.services.dynamodb.model.Condition v1Condition = AlternatorDBApiVersion2Mapper.MapV2ConditionToV1(v2Condition);
                v1Filter.put(key, v1Condition);
            }
        }
        return v1Filter;
    }

    public static com.amazonaws.services.dynamodb.model.Condition MapV2ConditionToV1(Condition v2Condition) {
        com.amazonaws.services.dynamodb.model.Condition v1Condition = new com.amazonaws.services.dynamodb.model.Condition().withComparisonOperator(v2Condition.getComparisonOperator());
        ArrayList<com.amazonaws.services.dynamodb.model.AttributeValue> v1AttrValues = null;
        List v2AttrValues = v2Condition.getAttributeValueList();
        if (v2AttrValues != null) {
            v1AttrValues = new ArrayList<com.amazonaws.services.dynamodb.model.AttributeValue>();
            for (AttributeValue v2AttrValue : v2AttrValues) {
                v1AttrValues.add(AlternatorDBApiVersion2Mapper.MapV2AttributeValueToV1(v2AttrValue));
            }
        }
        v1Condition.setAttributeValueList(v1AttrValues);
        return v1Condition;
    }

    public static CreateTableRequest MapV2CreateTableRequestToV1(com.amazonaws.services.dynamodbv2.model.CreateTableRequest v2Request) {
        String hashKeyName = null;
        String hashKeyType = null;
        String rangeKeyName = null;
        String rangeKeyType = null;
        for (KeySchemaElement element : v2Request.getKeySchema()) {
            if ("HASH".equals(element.getKeyType())) {
                hashKeyName = element.getAttributeName();
                continue;
            }
            if (!"RANGE".equals(element.getKeyType())) continue;
            rangeKeyName = element.getAttributeName();
        }
        for (AttributeDefinition attribute : v2Request.getAttributeDefinitions()) {
            if (attribute.getAttributeName().equals(hashKeyName)) {
                hashKeyType = attribute.getAttributeType();
                continue;
            }
            if (!attribute.getAttributeName().equals(rangeKeyName)) continue;
            rangeKeyType = attribute.getAttributeType();
        }
        KeySchema keySchema = new KeySchema();
        if (hashKeyName != null) {
            keySchema.setHashKeyElement(new com.amazonaws.services.dynamodb.model.KeySchemaElement().withAttributeName(hashKeyName).withAttributeType(hashKeyType));
        }
        if (rangeKeyName != null) {
            keySchema.setRangeKeyElement(new com.amazonaws.services.dynamodb.model.KeySchemaElement().withAttributeName(rangeKeyName).withAttributeType(rangeKeyType));
        }
        com.amazonaws.services.dynamodb.model.ProvisionedThroughput v1ThruPut = null;
        ProvisionedThroughput v2ThruPut = v2Request.getProvisionedThroughput();
        if (v2ThruPut != null) {
            v1ThruPut = new com.amazonaws.services.dynamodb.model.ProvisionedThroughput().withReadCapacityUnits(v2ThruPut.getReadCapacityUnits()).withWriteCapacityUnits(v2ThruPut.getWriteCapacityUnits());
        }
        CreateTableRequest request = new CreateTableRequest().withTableName(v2Request.getTableName()).withKeySchema(keySchema).withProvisionedThroughput(v1ThruPut);
        return request;
    }

    public static com.amazonaws.services.dynamodb.model.DescribeTableRequest MapV2DescribeTableRequestToV1(DescribeTableRequest v2Request) {
        com.amazonaws.services.dynamodb.model.DescribeTableRequest request = new com.amazonaws.services.dynamodb.model.DescribeTableRequest().withTableName(v2Request.getTableName());
        return request;
    }

    public static ListTablesRequest MapV2ListTablesRequestToV1(com.amazonaws.services.dynamodbv2.model.ListTablesRequest v2Request) {
        ListTablesRequest request = new ListTablesRequest().withExclusiveStartTableName(v2Request.getExclusiveStartTableName()).withLimit(v2Request.getLimit());
        return request;
    }

    public static com.amazonaws.services.dynamodb.model.DeleteTableRequest MapV2DeleteTableRequestToV1(DeleteTableRequest v2Request) {
        com.amazonaws.services.dynamodb.model.DeleteTableRequest request = new com.amazonaws.services.dynamodb.model.DeleteTableRequest().withTableName(v2Request.getTableName());
        return request;
    }

    public static UpdateTableRequest MapV2UpdateTableRequestToV1(com.amazonaws.services.dynamodbv2.model.UpdateTableRequest v2Request) {
        com.amazonaws.services.dynamodb.model.ProvisionedThroughput v1ThruPut = null;
        if (v2Request.getProvisionedThroughput() != null) {
            ProvisionedThroughput v2ThruPut = v2Request.getProvisionedThroughput();
            v1ThruPut = new com.amazonaws.services.dynamodb.model.ProvisionedThroughput().withReadCapacityUnits(v2ThruPut.getReadCapacityUnits()).withWriteCapacityUnits(v2ThruPut.getWriteCapacityUnits());
        }
        UpdateTableRequest request = new UpdateTableRequest().withTableName(v2Request.getTableName()).withProvisionedThroughput(v1ThruPut);
        return request;
    }

    public static com.amazonaws.services.dynamodb.model.PutItemRequest MapV2PutItemRequestToV1(PutItemRequest v2Request) {
        com.amazonaws.services.dynamodb.model.PutItemRequest request = new com.amazonaws.services.dynamodb.model.PutItemRequest().withTableName(v2Request.getTableName()).withItem(AlternatorDBApiVersion2Mapper.MapV2ItemToV1(v2Request.getItem())).withExpected(AlternatorDBApiVersion2Mapper.MapV2ExpectedToV1(v2Request.getExpected())).withReturnValues(v2Request.getReturnValues());
        return request;
    }

    public static com.amazonaws.services.dynamodb.model.GetItemRequest MapV2GetItemRequestToV1(GetItemRequest v2Request, Table table) {
        com.amazonaws.services.dynamodb.model.GetItemRequest request = new com.amazonaws.services.dynamodb.model.GetItemRequest().withTableName(v2Request.getTableName()).withKey(AlternatorDBApiVersion2Mapper.MapV2KeyToV1(v2Request.getKey(), table)).withAttributesToGet((Collection)v2Request.getAttributesToGet()).withConsistentRead(v2Request.getConsistentRead());
        return request;
    }

    public static DeleteItemRequest MapV2DeleteItemRequestToV1(com.amazonaws.services.dynamodbv2.model.DeleteItemRequest v2Request, Table table) {
        DeleteItemRequest request = new DeleteItemRequest().withTableName(v2Request.getTableName()).withKey(AlternatorDBApiVersion2Mapper.MapV2KeyToV1(v2Request.getKey(), table)).withExpected(AlternatorDBApiVersion2Mapper.MapV2ExpectedToV1(v2Request.getExpected())).withReturnValues(v2Request.getReturnValues());
        return request;
    }

    public static UpdateItemRequest MapV2UpdateItemRequestToV1(com.amazonaws.services.dynamodbv2.model.UpdateItemRequest v2Request, Table table) {
        UpdateItemRequest request = new UpdateItemRequest().withTableName(v2Request.getTableName()).withKey(AlternatorDBApiVersion2Mapper.MapV2KeyToV1(v2Request.getKey(), table)).withAttributeUpdates(AlternatorDBApiVersion2Mapper.MapV2AttributeUpdatesToV1(v2Request.getAttributeUpdates())).withExpected(AlternatorDBApiVersion2Mapper.MapV2ExpectedToV1(v2Request.getExpected())).withReturnValues(v2Request.getReturnValues());
        return request;
    }

    public static com.amazonaws.services.dynamodb.model.BatchGetItemRequest MapV2BatchGetItemRequestToV1(BatchGetItemRequest v2Request, Map<String, Table> tables) {
        HashMap<String, com.amazonaws.services.dynamodb.model.KeysAndAttributes> v1RequestItems = new HashMap<String, com.amazonaws.services.dynamodb.model.KeysAndAttributes>();
        for (String tableName : v2Request.getRequestItems().keySet()) {
            Table table = tables.get(tableName);
            com.amazonaws.services.dynamodb.model.KeysAndAttributes v1RequestItem = AlternatorDBApiVersion2Mapper.MapV2KeysAndAttributesToV1((KeysAndAttributes)v2Request.getRequestItems().get(tableName), table);
            v1RequestItems.put(tableName, v1RequestItem);
        }
        com.amazonaws.services.dynamodb.model.BatchGetItemRequest request = new com.amazonaws.services.dynamodb.model.BatchGetItemRequest().withRequestItems(v1RequestItems);
        return request;
    }

    public static com.amazonaws.services.dynamodb.model.ScanRequest MapV2ScanRequestToV1(ScanRequest v2Request, Table table) {
        com.amazonaws.services.dynamodb.model.ScanRequest request = new com.amazonaws.services.dynamodb.model.ScanRequest().withTableName(v2Request.getTableName()).withAttributesToGet((Collection)v2Request.getAttributesToGet()).withLimit(v2Request.getLimit()).withScanFilter(AlternatorDBApiVersion2Mapper.MapV2ScanFilterToV1(v2Request.getScanFilter())).withExclusiveStartKey(AlternatorDBApiVersion2Mapper.MapV2KeyToV1(v2Request.getExclusiveStartKey(), table));
        request.setCount(Boolean.valueOf("COUNT".equals(v2Request.getSelect())));
        return request;
    }

    public static QueryRequest MapV2QueryRequestToV1(com.amazonaws.services.dynamodbv2.model.QueryRequest v2Request, Table table) {
        QueryRequest request = new QueryRequest().withTableName(v2Request.getTableName()).withAttributesToGet((Collection)v2Request.getAttributesToGet()).withLimit(v2Request.getLimit()).withConsistentRead(v2Request.getConsistentRead()).withScanIndexForward(v2Request.getScanIndexForward()).withExclusiveStartKey(AlternatorDBApiVersion2Mapper.MapV2KeyToV1(v2Request.getExclusiveStartKey(), table));
        request.setCount(Boolean.valueOf("COUNT".equals(v2Request.getSelect())));
        if (v2Request.getKeyConditions() != null) {
            for (String v2AttrName : v2Request.getKeyConditions().keySet()) {
                Condition v2Condition = (Condition)v2Request.getKeyConditions().get(v2AttrName);
                if (v2AttrName.equals(table.getHashKeyName())) {
                    List v2AttrValues = v2Condition.getAttributeValueList();
                    if (v2AttrName.length() <= 0) continue;
                    request.setHashKeyValue(AlternatorDBApiVersion2Mapper.MapV2AttributeValueToV1((AttributeValue)v2AttrValues.get(0)));
                    continue;
                }
                if (!v2AttrName.equals(table.getRangeKeyName())) continue;
                request.setRangeKeyCondition(AlternatorDBApiVersion2Mapper.MapV2ConditionToV1(v2Condition));
            }
        }
        return request;
    }

    public static CreateTableResult MapV1CreateTableResultToV2(com.amazonaws.services.dynamodb.model.CreateTableResult result) {
        TableDescription table = result.getTableDescription();
        com.amazonaws.services.dynamodbv2.model.TableDescription v2Table = AlternatorDBApiVersion2Mapper.MapV2TableDescriptionToV1(table);
        CreateTableResult v2result = new CreateTableResult().withTableDescription(v2Table);
        return v2result;
    }

    public static com.amazonaws.services.dynamodbv2.model.DescribeTableResult MapV1DescribeTableResultToV2(DescribeTableResult result) {
        TableDescription table = result.getTable();
        com.amazonaws.services.dynamodbv2.model.TableDescription v2Table = AlternatorDBApiVersion2Mapper.MapV2TableDescriptionToV1(table);
        com.amazonaws.services.dynamodbv2.model.DescribeTableResult v2result = new com.amazonaws.services.dynamodbv2.model.DescribeTableResult().withTable(v2Table);
        return v2result;
    }

    public static com.amazonaws.services.dynamodbv2.model.ListTablesResult MapV1ListTablesResultToV2(ListTablesResult result) {
        com.amazonaws.services.dynamodbv2.model.ListTablesResult v2result = new com.amazonaws.services.dynamodbv2.model.ListTablesResult().withTableNames((Collection)result.getTableNames()).withLastEvaluatedTableName(result.getLastEvaluatedTableName());
        return v2result;
    }

    public static DeleteTableResult MapV1DeleteTableResultToV2(com.amazonaws.services.dynamodb.model.DeleteTableResult result) {
        TableDescription table = result.getTableDescription();
        com.amazonaws.services.dynamodbv2.model.TableDescription v2Table = AlternatorDBApiVersion2Mapper.MapV2TableDescriptionToV1(table);
        DeleteTableResult v2result = new DeleteTableResult().withTableDescription(v2Table);
        return v2result;
    }

    public static UpdateTableResult MapV1UpdateTableResultToV2(com.amazonaws.services.dynamodb.model.UpdateTableResult result) {
        TableDescription table = result.getTableDescription();
        com.amazonaws.services.dynamodbv2.model.TableDescription v2Table = AlternatorDBApiVersion2Mapper.MapV2TableDescriptionToV1(table);
        UpdateTableResult v2result = new UpdateTableResult().withTableDescription(v2Table);
        return v2result;
    }

    public static PutItemResult MapV1PutItemResultToV2(com.amazonaws.services.dynamodb.model.PutItemResult result, String tableName) {
        PutItemResult v2result = new PutItemResult().withAttributes(AlternatorDBApiVersion2Mapper.MapV1ItemToV2(result.getAttributes())).withConsumedCapacity(new ConsumedCapacity().withTableName(tableName).withCapacityUnits(result.getConsumedCapacityUnits()));
        return v2result;
    }

    public static com.amazonaws.services.dynamodbv2.model.GetItemResult MapV1GetItemResultToV2(GetItemResult result, String tableName) {
        com.amazonaws.services.dynamodbv2.model.GetItemResult v2result = new com.amazonaws.services.dynamodbv2.model.GetItemResult().withItem(AlternatorDBApiVersion2Mapper.MapV1ItemToV2(result.getItem())).withConsumedCapacity(new ConsumedCapacity().withTableName(tableName).withCapacityUnits(result.getConsumedCapacityUnits()));
        return v2result;
    }

    public static com.amazonaws.services.dynamodbv2.model.DeleteItemResult MapV1DeleteItemResultToV2(DeleteItemResult result, String tableName) {
        com.amazonaws.services.dynamodbv2.model.DeleteItemResult v2result = new com.amazonaws.services.dynamodbv2.model.DeleteItemResult().withAttributes(AlternatorDBApiVersion2Mapper.MapV1ItemToV2(result.getAttributes())).withConsumedCapacity(new ConsumedCapacity().withTableName(tableName).withCapacityUnits(result.getConsumedCapacityUnits()));
        return v2result;
    }

    public static UpdateItemResult MapV1UpdateItemResultToV2(com.amazonaws.services.dynamodb.model.UpdateItemResult result, String tableName) {
        UpdateItemResult v2result = new UpdateItemResult().withAttributes(AlternatorDBApiVersion2Mapper.MapV1ItemToV2(result.getAttributes())).withConsumedCapacity(new ConsumedCapacity().withTableName(tableName).withCapacityUnits(result.getConsumedCapacityUnits()));
        return v2result;
    }

    public static BatchGetItemResult MapV1BatchGetItemResultToV2(com.amazonaws.services.dynamodb.model.BatchGetItemResult result, Map<String, Table> tables) {
        HashMap v2Responses = new HashMap();
        ArrayList<ConsumedCapacity> v2Capacities = new ArrayList<ConsumedCapacity>();
        for (String tableName : result.getResponses().keySet()) {
            BatchResponse v1Response = (BatchResponse)result.getResponses().get(tableName);
            ArrayList<Map<String, AttributeValue>> v2Items = new ArrayList<Map<String, AttributeValue>>();
            for (Map v1Item : v1Response.getItems()) {
                v2Items.add(AlternatorDBApiVersion2Mapper.MapV1ItemToV2(v1Item));
            }
            v2Capacities.add(new ConsumedCapacity().withTableName(tableName).withCapacityUnits(v1Response.getConsumedCapacityUnits()));
            v2Responses.put(tableName, v2Items);
        }
        HashMap<String, KeysAndAttributes> v2UnprocessedKeys = null;
        Map v1UnprocessedKeys = result.getUnprocessedKeys();
        if (v1UnprocessedKeys != null) {
            v2UnprocessedKeys = new HashMap<String, KeysAndAttributes>();
            for (String tableName : v1UnprocessedKeys.keySet()) {
                Table table = tables.get(tableName);
                com.amazonaws.services.dynamodb.model.KeysAndAttributes v1KeysAndAttr = (com.amazonaws.services.dynamodb.model.KeysAndAttributes)result.getUnprocessedKeys().get(tableName);
                v2UnprocessedKeys.put(tableName, AlternatorDBApiVersion2Mapper.MapV1KeysAndAttributesToV2(v1KeysAndAttr, table));
            }
        }
        BatchGetItemResult v2result = new BatchGetItemResult().withResponses(v2Responses).withUnprocessedKeys(v2UnprocessedKeys).withConsumedCapacity(v2Capacities);
        return v2result;
    }

    public static com.amazonaws.services.dynamodbv2.model.ScanResult MapV1ScanResultToV2(ScanResult result, Table table) {
        ArrayList<Map<String, AttributeValue>> v2Items = null;
        if (result.getItems() != null) {
            v2Items = new ArrayList<Map<String, AttributeValue>>();
            for (Map v1Item : result.getItems()) {
                v2Items.add(AlternatorDBApiVersion2Mapper.MapV1ItemToV2(v1Item));
            }
        }
        com.amazonaws.services.dynamodbv2.model.ScanResult v2result = new com.amazonaws.services.dynamodbv2.model.ScanResult().withItems(v2Items).withCount(result.getCount()).withScannedCount(result.getScannedCount()).withLastEvaluatedKey(AlternatorDBApiVersion2Mapper.MapV1KeyToV2(result.getLastEvaluatedKey(), table)).withConsumedCapacity(new ConsumedCapacity().withTableName(table.getName()).withCapacityUnits(result.getConsumedCapacityUnits()));
        return v2result;
    }

    public static QueryResult MapV1QueryResultToV2(com.amazonaws.services.dynamodb.model.QueryResult result, Table table) {
        ArrayList<Map<String, AttributeValue>> v2Items = null;
        if (result.getItems() != null) {
            v2Items = new ArrayList<Map<String, AttributeValue>>();
            for (Map v1Item : result.getItems()) {
                v2Items.add(AlternatorDBApiVersion2Mapper.MapV1ItemToV2(v1Item));
            }
        }
        QueryResult v2result = new QueryResult().withItems(v2Items).withCount(result.getCount()).withLastEvaluatedKey(AlternatorDBApiVersion2Mapper.MapV1KeyToV2(result.getLastEvaluatedKey(), table)).withConsumedCapacity(new ConsumedCapacity().withTableName(table.getName()).withCapacityUnits(result.getConsumedCapacityUnits()));
        return v2result;
    }
}

