/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator.validators;

import com.amazonaws.services.dynamodb.model.UpdateItemRequest;
import com.michelboudreau.alternator.validation.Validator;
import com.michelboudreau.alternator.validation.ValidatorUtils;
import com.michelboudreau.alternator.validators.KeyValidator;
import com.michelboudreau.alternator.validators.TableNameValidator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateItemRequestValidator
extends Validator {
    @Override
    public Boolean supports(Class clazz) {
        return UpdateItemRequest.class.isAssignableFrom(clazz);
    }

    @Override
    public List<Error> validate(Object target) {
        UpdateItemRequest instance = (UpdateItemRequest)target;
        ArrayList<Error> errors = new ArrayList<Error>();
        errors.addAll(ValidatorUtils.invokeValidator(new TableNameValidator(), instance.getTableName()));
        errors.addAll(ValidatorUtils.invokeValidator(new KeyValidator(), instance.getKey()));
        errors.addAll(ValidatorUtils.rejectIfNullOrEmptyOrWhitespace(instance.getAttributeUpdates().toString()));
        return this.removeNulls(errors);
    }
}

