/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator.validators;

import com.michelboudreau.alternator.validation.Validator;
import com.michelboudreau.alternator.validation.ValidatorUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableNameValidator
extends Validator {
    @Override
    public Boolean supports(Class clazz) {
        return String.class.isAssignableFrom(clazz);
    }

    @Override
    public List<Error> validate(Object target) {
        List<Error> errors = ValidatorUtils.rejectIfNullOrEmptyOrWhitespace(target);
        if (errors.size() == 0) {
            errors.addAll(ValidatorUtils.rejectIfNotMatchRegex(target, "^[a-zA-Z0-9_.-]*$"));
            errors.addAll(ValidatorUtils.rejectIfSizeOutOfBounds(target, 3.0, 255.0));
        }
        return this.removeNulls(errors);
    }
}

