/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator.validators;

import com.amazonaws.services.dynamodb.model.PutItemRequest;
import com.michelboudreau.alternator.validation.Validator;
import com.michelboudreau.alternator.validation.ValidatorUtils;
import com.michelboudreau.alternator.validators.ExpectedValidator;
import com.michelboudreau.alternator.validators.ItemValidator;
import com.michelboudreau.alternator.validators.TableNameValidator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutItemRequestValidator
extends Validator {
    @Override
    public Boolean supports(Class clazz) {
        return PutItemRequest.class.isAssignableFrom(clazz);
    }

    @Override
    public List<Error> validate(Object target) {
        PutItemRequest instance = (PutItemRequest)target;
        List<Error> errors = ValidatorUtils.invokeValidator(new TableNameValidator(), instance.getTableName());
        errors.addAll(ValidatorUtils.invokeValidator(new ItemValidator(), instance.getItem()));
        if (instance.getExpected() != null) {
            errors.addAll(ValidatorUtils.invokeValidator(new ExpectedValidator(), instance.getExpected()));
        }
        if (instance.getReturnValues() != null) {
            errors.addAll(ValidatorUtils.rejectIfNotMatchRegex(instance.getReturnValues(), "^(NONE|ALL_OLD)$"));
        }
        return this.removeNulls(errors);
    }
}

