/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator.validators;

import com.amazonaws.services.dynamodb.model.Key;
import com.michelboudreau.alternator.validation.Validator;
import com.michelboudreau.alternator.validation.ValidatorUtils;
import com.michelboudreau.alternator.validators.PrimaryKeyValidator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyValidator
extends Validator {
    @Override
    public Boolean supports(Class clazz) {
        return Key.class.isAssignableFrom(clazz);
    }

    @Override
    public List<Error> validate(Object target) {
        Key instance = (Key)target;
        List<Error> errors = ValidatorUtils.rejectIfNull(instance);
        if (errors.size() == 0) {
            errors.addAll(ValidatorUtils.rejectIfNull(instance.getHashKeyElement()));
            if (instance.getHashKeyElement() != null) {
                errors.addAll(ValidatorUtils.invokeValidator(new PrimaryKeyValidator(), instance.getHashKeyElement()));
            }
            if (instance.getRangeKeyElement() != null) {
                errors.addAll(ValidatorUtils.invokeValidator(new PrimaryKeyValidator(), instance.getRangeKeyElement()));
            }
        }
        return this.removeNulls(errors);
    }
}

