/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator.validators;

import com.amazonaws.services.dynamodb.model.ExpectedAttributeValue;
import com.michelboudreau.alternator.validation.Validator;
import com.michelboudreau.alternator.validation.ValidatorUtils;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpectedValidator
extends Validator {
    @Override
    public Boolean supports(Class clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    @Override
    public List<Error> validate(Object target) {
        Map instance = (Map)target;
        ArrayList<Error> errors = new ArrayList<Error>();
        Charset utf = Charset.forName("UTF-8");
        for (Map.Entry entry : instance.entrySet()) {
            String key = (String)entry.getKey();
            ExpectedAttributeValue value = (ExpectedAttributeValue)entry.getValue();
            errors.addAll(ValidatorUtils.rejectIfSizeOutOfBounds(key, 1.0, 255.0));
            errors.addAll(ValidatorUtils.rejectIfNull(value));
            if (value.getExists() != null && value.getExists().booleanValue() && value == null) {
                errors.add(new Error("If exists is True, Value mush be set"));
            }
            if (value == null || value.getValue() != null || value.getExists() != null) continue;
            errors.add(new Error("AttributeValue or Exists must be non-null for Expected to work."));
        }
        return this.removeNulls(errors);
    }
}

