/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator.validators;

import com.amazonaws.services.dynamodb.model.DeleteTableRequest;
import com.amazonaws.services.dynamodb.model.DescribeTableRequest;
import com.michelboudreau.alternator.validation.Validator;
import com.michelboudreau.alternator.validation.ValidatorUtils;
import com.michelboudreau.alternator.validators.TableNameValidator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteTableRequestValidator
extends Validator {
    @Override
    public Boolean supports(Class clazz) {
        return DescribeTableRequest.class.isAssignableFrom(clazz);
    }

    @Override
    public List<Error> validate(Object target) {
        DeleteTableRequest instance = (DeleteTableRequest)target;
        List<Error> errors = ValidatorUtils.rejectIfNullOrEmptyOrWhitespace(instance.getTableName());
        if (instance.getTableName() != null) {
            errors.addAll(ValidatorUtils.invokeValidator(new TableNameValidator(), instance.getTableName()));
        }
        return this.removeNulls(errors);
    }
}

