/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator.models;

import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.Condition;
import com.amazonaws.services.dynamodb.model.KeySchemaElement;
import com.amazonaws.services.dynamodb.model.ResourceNotFoundException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.michelboudreau.alternator.enums.AttributeValueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemRangeGroup {
    @JsonIgnore
    private final String DEFAULT_RANGE_KEY_VALUE = "";
    private SortedMap<String, Map<String, AttributeValue>> items = new TreeMap<String, Map<String, AttributeValue>>();

    public int size() {
        return this.items.size();
    }

    public Set<String> getKeySet() {
        return this.items.keySet();
    }

    public Collection<Map<String, AttributeValue>> getItems(KeySchemaElement rangeKeyElement, Condition rangeKeyCondition) {
        if (rangeKeyElement == null || rangeKeyCondition == null) {
            return this.items.values();
        }
        return this.filterItemsByRangeKeyCondition(rangeKeyElement, rangeKeyCondition);
    }

    private AttributeValueType getAttributeValueType(AttributeValue value) {
        if (value != null) {
            if (value.getN() != null) {
                return AttributeValueType.N;
            }
            if (value.getS() != null) {
                return AttributeValueType.S;
            }
            if (value.getNS() != null) {
                return AttributeValueType.NS;
            }
            if (value.getSS() != null) {
                return AttributeValueType.SS;
            }
        }
        return AttributeValueType.UNKNOWN;
    }

    private Collection<Map<String, AttributeValue>> filterItemsByRangeKeyCondition(KeySchemaElement rangeKeyElement, Condition cond) {
        String rangeKeyName = rangeKeyElement.getAttributeName();
        ArrayList<Map<String, AttributeValue>> filteredItems = new ArrayList<Map<String, AttributeValue>>();
        block0: for (String rangeKey : this.items.keySet()) {
            AttributeValue compAttr;
            String comp;
            AttributeValue valueAttr;
            String value;
            Map item = (Map)this.items.get(rangeKey);
            if (cond.getComparisonOperator() == null) {
                throw new ResourceNotFoundException("There must be a comparisonOperator");
            }
            if (cond.getComparisonOperator().equals("EQ")) {
                if (cond.getAttributeValueList().size() != 1 || (value = this.getAttributeValueType(valueAttr = (AttributeValue)item.get(rangeKeyName)).equals((Object)AttributeValueType.S) ? valueAttr.getS() : valueAttr.getN()).compareTo(comp = this.getAttributeValueType(compAttr = (AttributeValue)cond.getAttributeValueList().get(0)).equals((Object)AttributeValueType.S) ? compAttr.getS() : compAttr.getN()) != 0) continue;
                filteredItems.add(item);
                continue;
            }
            if (cond.getComparisonOperator().equals("LE")) {
                if (cond.getAttributeValueList().size() != 1 || (value = this.getAttributeValueType(valueAttr = (AttributeValue)item.get(rangeKeyName)).equals((Object)AttributeValueType.S) ? valueAttr.getS() : valueAttr.getN()).compareTo(comp = this.getAttributeValueType(compAttr = (AttributeValue)cond.getAttributeValueList().get(0)).equals((Object)AttributeValueType.S) ? compAttr.getS() : compAttr.getN()) > 0) continue;
                filteredItems.add(item);
                continue;
            }
            if (cond.getComparisonOperator().equals("LT")) {
                if (cond.getAttributeValueList().size() != 1 || (value = this.getAttributeValueType(valueAttr = (AttributeValue)item.get(rangeKeyName)).equals((Object)AttributeValueType.S) ? valueAttr.getS() : valueAttr.getN()).compareTo(comp = this.getAttributeValueType(compAttr = (AttributeValue)cond.getAttributeValueList().get(0)).equals((Object)AttributeValueType.S) ? compAttr.getS() : compAttr.getN()) >= 0) continue;
                filteredItems.add(item);
                continue;
            }
            if (cond.getComparisonOperator().equals("GE")) {
                if (cond.getAttributeValueList().size() != 1 || (value = this.getAttributeValueType(valueAttr = (AttributeValue)item.get(rangeKeyName)).equals((Object)AttributeValueType.S) ? valueAttr.getS() : valueAttr.getN()).compareTo(comp = this.getAttributeValueType(compAttr = (AttributeValue)cond.getAttributeValueList().get(0)).equals((Object)AttributeValueType.S) ? compAttr.getS() : compAttr.getN()) < 0) continue;
                filteredItems.add(item);
                continue;
            }
            if (cond.getComparisonOperator().equals("GT")) {
                if (cond.getAttributeValueList().size() != 1 || (value = this.getAttributeValueType(valueAttr = (AttributeValue)item.get(rangeKeyName)).equals((Object)AttributeValueType.S) ? valueAttr.getS() : valueAttr.getN()).compareTo(comp = this.getAttributeValueType(compAttr = (AttributeValue)cond.getAttributeValueList().get(0)).equals((Object)AttributeValueType.S) ? compAttr.getS() : compAttr.getN()) <= 0) continue;
                filteredItems.add(item);
                continue;
            }
            if (cond.getComparisonOperator().equals("BETWEEN")) {
                String comp1;
                if (cond.getAttributeValueList().size() != 2) continue;
                valueAttr = (AttributeValue)item.get(rangeKeyName);
                value = this.getAttributeValueType(valueAttr).equals((Object)AttributeValueType.S) ? valueAttr.getS() : valueAttr.getN();
                AttributeValue compAttr0 = (AttributeValue)cond.getAttributeValueList().get(0);
                String comp0 = this.getAttributeValueType(compAttr0).equals((Object)AttributeValueType.S) ? compAttr0.getS() : compAttr0.getN();
                AttributeValue compAttr1 = (AttributeValue)cond.getAttributeValueList().get(1);
                String string = comp1 = this.getAttributeValueType(compAttr1).equals((Object)AttributeValueType.S) ? compAttr1.getS() : compAttr1.getN();
                if (value.compareTo(comp0) < 0 || value.compareTo(comp1) > 0) continue;
                filteredItems.add(item);
                continue;
            }
            if (cond.getComparisonOperator().equals("BEGINS_WITH")) {
                if (cond.getAttributeValueList().size() != 1 || !(value = this.getAttributeValueType(valueAttr = (AttributeValue)item.get(rangeKeyName)).equals((Object)AttributeValueType.S) ? valueAttr.getS() : valueAttr.getN()).startsWith(comp = this.getAttributeValueType(compAttr = (AttributeValue)cond.getAttributeValueList().get(0)).equals((Object)AttributeValueType.S) ? compAttr.getS() : compAttr.getN())) continue;
                filteredItems.add(item);
                continue;
            }
            if (cond.getComparisonOperator().equals("CONTAINS")) {
                if (cond.getAttributeValueList().size() != 1 || !(value = this.getAttributeValueType(valueAttr = (AttributeValue)item.get(rangeKeyName)).equals((Object)AttributeValueType.S) ? valueAttr.getS() : valueAttr.getN()).contains(comp = this.getAttributeValueType(compAttr = (AttributeValue)cond.getAttributeValueList().get(0)).equals((Object)AttributeValueType.S) ? compAttr.getS() : compAttr.getN())) continue;
                filteredItems.add(item);
                continue;
            }
            if (!cond.getComparisonOperator().equals("IN")) continue;
            valueAttr = (AttributeValue)item.get(rangeKeyName);
            value = this.getAttributeValueType(valueAttr).equals((Object)AttributeValueType.S) ? valueAttr.getS() : valueAttr.getN();
            for (AttributeValue compAttr2 : cond.getAttributeValueList()) {
                String comp2 = this.getAttributeValueType(compAttr2).equals((Object)AttributeValueType.S) ? compAttr2.getS() : compAttr2.getN();
                if (value.compareTo(comp2) != 0) continue;
                filteredItems.add(item);
                continue block0;
            }
        }
        return filteredItems;
    }

    public void putItem(String rangeKeyValue, Map<String, AttributeValue> item) {
        this.items.put(this.normalizeRangeKeyValue(rangeKeyValue), item);
    }

    public void removeItem(String rangeKeyValue) {
        this.items.remove(this.normalizeRangeKeyValue(rangeKeyValue));
    }

    public Map<String, AttributeValue> getItem(String rangeKeyValue) {
        return (Map)this.items.get(this.normalizeRangeKeyValue(rangeKeyValue));
    }

    private String normalizeRangeKeyValue(String rangeKeyValue) {
        String actualRangeKeyValue = rangeKeyValue;
        if (rangeKeyValue == null) {
            actualRangeKeyValue = "";
        }
        return actualRangeKeyValue;
    }
}

