/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodb.model.AttributeAction;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodb.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodb.model.BatchResponse;
import com.amazonaws.services.dynamodb.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodb.model.BatchWriteResponse;
import com.amazonaws.services.dynamodb.model.Condition;
import com.amazonaws.services.dynamodb.model.CreateTableRequest;
import com.amazonaws.services.dynamodb.model.CreateTableResult;
import com.amazonaws.services.dynamodb.model.DeleteItemRequest;
import com.amazonaws.services.dynamodb.model.DeleteRequest;
import com.amazonaws.services.dynamodb.model.DeleteTableRequest;
import com.amazonaws.services.dynamodb.model.DeleteTableResult;
import com.amazonaws.services.dynamodb.model.DescribeTableResult;
import com.amazonaws.services.dynamodb.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodb.model.GetItemRequest;
import com.amazonaws.services.dynamodb.model.InternalServerErrorException;
import com.amazonaws.services.dynamodb.model.Key;
import com.amazonaws.services.dynamodb.model.KeySchema;
import com.amazonaws.services.dynamodb.model.KeySchemaElement;
import com.amazonaws.services.dynamodb.model.KeysAndAttributes;
import com.amazonaws.services.dynamodb.model.LimitExceededException;
import com.amazonaws.services.dynamodb.model.ListTablesRequest;
import com.amazonaws.services.dynamodb.model.QueryRequest;
import com.amazonaws.services.dynamodb.model.ResourceInUseException;
import com.amazonaws.services.dynamodb.model.ReturnValue;
import com.amazonaws.services.dynamodb.model.ScanRequest;
import com.amazonaws.services.dynamodb.model.ScanResult;
import com.amazonaws.services.dynamodb.model.TableStatus;
import com.amazonaws.services.dynamodb.model.UpdateItemRequest;
import com.amazonaws.services.dynamodb.model.UpdateTableRequest;
import com.amazonaws.services.dynamodb.model.UpdateTableResult;
import com.amazonaws.services.dynamodb.model.WriteRequest;
import com.amazonaws.services.dynamodb.model.transform.BatchGetItemRequestJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.BatchGetItemResultMarshaller;
import com.amazonaws.services.dynamodb.model.transform.BatchWriteItemResultMarshaller;
import com.amazonaws.services.dynamodb.model.transform.CreateTableResultMarshaller;
import com.amazonaws.services.dynamodb.model.transform.DeleteItemRequestJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.DeleteItemResultMarshaller;
import com.amazonaws.services.dynamodb.model.transform.DescribeTableRequestJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.DescribeTableResultMarshaller;
import com.amazonaws.services.dynamodb.model.transform.GetItemRequestJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.GetItemResultMarshaller;
import com.amazonaws.services.dynamodb.model.transform.ListTablesRequestJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.ListTablesResultMarshaller;
import com.amazonaws.services.dynamodb.model.transform.PutItemResultMarshaller;
import com.amazonaws.services.dynamodb.model.transform.QueryResultMarshaller;
import com.amazonaws.services.dynamodb.model.transform.ScanRequestJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.ScanResultMarshaller;
import com.amazonaws.services.dynamodb.model.transform.UpdateItemRequestJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.UpdateItemResultMarshaller;
import com.amazonaws.services.dynamodb.model.transform.UpdateTableRequestJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.UpdateTableResultMarshaller;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.transform.BatchWriteItemRequestJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.CreateTableRequestJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.DeleteTableRequestJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.DeleteTableResultMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.PutItemRequestJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.QueryRequestJsonUnmarshaller;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.michelboudreau.alternator.enums.AttributeValueType;
import com.michelboudreau.alternator.enums.RequestType;
import com.michelboudreau.alternator.models.ItemRangeGroup;
import com.michelboudreau.alternator.models.Table;
import com.michelboudreau.alternator.parsers.AmazonWebServiceRequestParser;
import com.michelboudreau.alternator.validators.CreateTableRequestValidator;
import com.michelboudreau.alternator.validators.DeleteItemRequestValidator;
import com.michelboudreau.alternator.validators.DeleteTableRequestValidator;
import com.michelboudreau.alternator.validators.DescribeTableRequestValidator;
import com.michelboudreau.alternator.validators.GetItemRequestValidator;
import com.michelboudreau.alternator.validators.ListTablesRequestValidator;
import com.michelboudreau.alternator.validators.PutItemRequestValidator;
import com.michelboudreau.alternator.validators.QueryRequestValidator;
import com.michelboudreau.alternator.validators.ScanRequestValidator;
import com.michelboudreau.alternator.validators.UpdateItemRequestValidator;
import com.michelboudreau.alternator.validators.UpdateTableRequestValidator;
import com.michelboudreau.alternatorv2.AlternatorDBApiVersion2Mapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternatorDBHandler {
    public final String API_VERSION_20111205 = "DynamoDB_20111205";
    public final String API_VERSION_20120810 = "DynamoDB_20120810";
    private final Logger logger = LoggerFactory.getLogger(AlternatorDBHandler.class);
    private Map<String, Table> tables = new HashMap<String, Table>();
    private List<Table> tableList = new ArrayList<Table>();

    public synchronized void save(String persistence) {
        try {
            this.createObjectMapper().writeValue(new File(persistence), this.tableList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void restore(String persistence) {
        try {
            File dbFile = new File(persistence);
            if (!dbFile.exists()) {
                return;
            }
            ObjectMapper objectMapper = this.createObjectMapper();
            this.tableList = (List)objectMapper.readValue(dbFile, (JavaType)objectMapper.getTypeFactory().constructCollectionType(ArrayList.class, Table.class));
            for (Table table : this.tableList) {
                this.tables.put(table.getName(), table);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).setVisibility(PropertyAccessor.CREATOR, JsonAutoDetect.Visibility.ANY).setVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.NONE);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return mapper;
    }

    public String handle(HttpServletRequest request) throws LimitExceededException, InternalServerErrorException, ResourceInUseException, com.amazonaws.services.dynamodb.model.ResourceNotFoundException, com.amazonaws.services.dynamodb.model.ConditionalCheckFailedException {
        try {
            AmazonWebServiceRequestParser parser = new AmazonWebServiceRequestParser(request);
            String apiVersion = parser.getApiVersion();
            if ("DynamoDB_20111205".equals(apiVersion)) {
                return this.handle20111205(request, parser);
            }
            if ("DynamoDB_20120810".equals(apiVersion)) {
                return this.handle20120810(request, parser);
            }
            String logMessage = "The API Version " + apiVersion + " is not supported.";
            this.logger.warn(logMessage);
            throw new AmazonServiceException(logMessage);
        }
        catch (NullPointerException ex) {
            StackTraceElement[] stackTrace = ex.getStackTrace();
            StackTraceElement exceptionSource = stackTrace[0];
            String errorMessage = "Caught " + ex.getClass().getName() + " (" + ex.getMessage() + ") at " + exceptionSource.getClassName() + "." + exceptionSource.getMethodName() + " line " + exceptionSource.getLineNumber();
            this.logger.error(errorMessage);
            throw new AmazonServiceException(errorMessage);
        }
    }

    private String handle20111205(HttpServletRequest request, AmazonWebServiceRequestParser parser) throws LimitExceededException, InternalServerErrorException, ResourceInUseException, com.amazonaws.services.dynamodb.model.ResourceNotFoundException, com.amazonaws.services.dynamodb.model.ConditionalCheckFailedException {
        RequestType requestType = parser.getType();
        switch (requestType) {
            case CREATE_TABLE: {
                return new CreateTableResultMarshaller().marshall(this.createTable(parser.getData(CreateTableRequest.class, com.amazonaws.services.dynamodb.model.transform.CreateTableRequestJsonUnmarshaller.getInstance())));
            }
            case DESCRIBE_TABLE: {
                return new DescribeTableResultMarshaller().marshall(this.describeTable(parser.getData(com.amazonaws.services.dynamodb.model.DescribeTableRequest.class, DescribeTableRequestJsonUnmarshaller.getInstance())));
            }
            case LIST_TABLES: {
                return new ListTablesResultMarshaller().marshall(this.listTables(parser.getData(ListTablesRequest.class, ListTablesRequestJsonUnmarshaller.getInstance())));
            }
            case UPDATE_TABLE: {
                return new UpdateTableResultMarshaller().marshall(this.updateTable(parser.getData(UpdateTableRequest.class, UpdateTableRequestJsonUnmarshaller.getInstance())));
            }
            case DELETE_TABLE: {
                return new com.amazonaws.services.dynamodb.model.transform.DeleteTableResultMarshaller().marshall(this.deleteTable(parser.getData(DeleteTableRequest.class, com.amazonaws.services.dynamodb.model.transform.DeleteTableRequestJsonUnmarshaller.getInstance())));
            }
            case PUT: {
                return new PutItemResultMarshaller().marshall(this.putItem(parser.getData(com.amazonaws.services.dynamodb.model.PutItemRequest.class, com.amazonaws.services.dynamodb.model.transform.PutItemRequestJsonUnmarshaller.getInstance())));
            }
            case GET: {
                return new GetItemResultMarshaller().marshall(this.getItem(parser.getData(GetItemRequest.class, GetItemRequestJsonUnmarshaller.getInstance())));
            }
            case UPDATE: {
                return new UpdateItemResultMarshaller().marshall(this.updateItem(parser.getData(UpdateItemRequest.class, UpdateItemRequestJsonUnmarshaller.getInstance())));
            }
            case DELETE: {
                return new DeleteItemResultMarshaller().marshall(this.deleteItem(parser.getData(DeleteItemRequest.class, DeleteItemRequestJsonUnmarshaller.getInstance())));
            }
            case BATCH_GET_ITEM: {
                return new BatchGetItemResultMarshaller().marshall(this.batchGetItem(parser.getData(BatchGetItemRequest.class, BatchGetItemRequestJsonUnmarshaller.getInstance())));
            }
            case BATCH_WRITE_ITEM: {
                return new BatchWriteItemResultMarshaller().marshall(this.batchWriteItem(parser.getData(com.amazonaws.services.dynamodb.model.BatchWriteItemRequest.class, com.amazonaws.services.dynamodb.model.transform.BatchWriteItemRequestJsonUnmarshaller.getInstance())));
            }
            case QUERY: {
                return new QueryResultMarshaller().marshall(this.query(parser.getData(QueryRequest.class, com.amazonaws.services.dynamodb.model.transform.QueryRequestJsonUnmarshaller.getInstance())));
            }
            case SCAN: {
                return new ScanResultMarshaller().marshall(this.scan(parser.getData(ScanRequest.class, ScanRequestJsonUnmarshaller.getInstance())));
            }
        }
        String logMessage = "The Request Type '" + (Object)((Object)parser.getType()) + "' does not exist.";
        this.logger.warn(logMessage);
        throw new AmazonServiceException(logMessage);
    }

    private String handle20120810(HttpServletRequest request, AmazonWebServiceRequestParser parser) throws LimitExceededException, InternalServerErrorException, ResourceInUseException, com.amazonaws.services.dynamodb.model.ResourceNotFoundException, com.amazonaws.services.dynamodb.model.ConditionalCheckFailedException {
        RequestType requestType = parser.getType();
        switch (requestType) {
            case CREATE_TABLE: {
                return new com.amazonaws.services.dynamodbv2.model.transform.CreateTableResultMarshaller().marshall(this.createTableV2(parser.getData(com.amazonaws.services.dynamodbv2.model.CreateTableRequest.class, CreateTableRequestJsonUnmarshaller.getInstance())));
            }
            case DESCRIBE_TABLE: {
                return new com.amazonaws.services.dynamodbv2.model.transform.DescribeTableResultMarshaller().marshall(this.describeTableV2(parser.getData(DescribeTableRequest.class, com.amazonaws.services.dynamodbv2.model.transform.DescribeTableRequestJsonUnmarshaller.getInstance())));
            }
            case LIST_TABLES: {
                return new com.amazonaws.services.dynamodbv2.model.transform.ListTablesResultMarshaller().marshall(this.listTablesV2(parser.getData(com.amazonaws.services.dynamodbv2.model.ListTablesRequest.class, com.amazonaws.services.dynamodbv2.model.transform.ListTablesRequestJsonUnmarshaller.getInstance())));
            }
            case UPDATE_TABLE: {
                return new com.amazonaws.services.dynamodbv2.model.transform.UpdateTableResultMarshaller().marshall(this.updateTableV2(parser.getData(com.amazonaws.services.dynamodbv2.model.UpdateTableRequest.class, com.amazonaws.services.dynamodbv2.model.transform.UpdateTableRequestJsonUnmarshaller.getInstance())));
            }
            case DELETE_TABLE: {
                return new DeleteTableResultMarshaller().marshall(this.deleteTableV2(parser.getData(com.amazonaws.services.dynamodbv2.model.DeleteTableRequest.class, DeleteTableRequestJsonUnmarshaller.getInstance())));
            }
            case PUT: {
                return new com.amazonaws.services.dynamodbv2.model.transform.PutItemResultMarshaller().marshall(this.putItemV2(parser.getData(PutItemRequest.class, PutItemRequestJsonUnmarshaller.getInstance())));
            }
            case GET: {
                return new com.amazonaws.services.dynamodbv2.model.transform.GetItemResultMarshaller().marshall(this.getItemV2(parser.getData(com.amazonaws.services.dynamodbv2.model.GetItemRequest.class, com.amazonaws.services.dynamodbv2.model.transform.GetItemRequestJsonUnmarshaller.getInstance())));
            }
            case UPDATE: {
                return new com.amazonaws.services.dynamodbv2.model.transform.UpdateItemResultMarshaller().marshall(this.updateItemV2(parser.getData(com.amazonaws.services.dynamodbv2.model.UpdateItemRequest.class, com.amazonaws.services.dynamodbv2.model.transform.UpdateItemRequestJsonUnmarshaller.getInstance())));
            }
            case DELETE: {
                return new com.amazonaws.services.dynamodbv2.model.transform.DeleteItemResultMarshaller().marshall(this.deleteItemV2(parser.getData(com.amazonaws.services.dynamodbv2.model.DeleteItemRequest.class, com.amazonaws.services.dynamodbv2.model.transform.DeleteItemRequestJsonUnmarshaller.getInstance())));
            }
            case BATCH_GET_ITEM: {
                return new com.amazonaws.services.dynamodbv2.model.transform.BatchGetItemResultMarshaller().marshall(this.batchGetItemV2(parser.getData(com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest.class, com.amazonaws.services.dynamodbv2.model.transform.BatchGetItemRequestJsonUnmarshaller.getInstance())));
            }
            case BATCH_WRITE_ITEM: {
                return new com.amazonaws.services.dynamodbv2.model.transform.BatchWriteItemResultMarshaller().marshall(this.batchWriteItemV2(parser.getData(BatchWriteItemRequest.class, BatchWriteItemRequestJsonUnmarshaller.getInstance())));
            }
            case QUERY: {
                return new com.amazonaws.services.dynamodbv2.model.transform.QueryResultMarshaller().marshall(this.queryV2(parser.getData(com.amazonaws.services.dynamodbv2.model.QueryRequest.class, QueryRequestJsonUnmarshaller.getInstance())));
            }
            case SCAN: {
                return new com.amazonaws.services.dynamodbv2.model.transform.ScanResultMarshaller().marshall(this.scanV2(parser.getData(com.amazonaws.services.dynamodbv2.model.ScanRequest.class, com.amazonaws.services.dynamodbv2.model.transform.ScanRequestJsonUnmarshaller.getInstance())));
            }
        }
        String logMessage = "The Request Type '" + (Object)((Object)parser.getType()) + "' does not exist.";
        this.logger.warn(logMessage);
        throw new AmazonServiceException(logMessage);
    }

    public synchronized CreateTableResult createTable(CreateTableRequest request) throws LimitExceededException, InternalServerErrorException, ResourceInUseException {
        if (this.tables.size() >= 256) {
            throw new LimitExceededException("Cannot exceed 256 tables per account.");
        }
        CreateTableRequestValidator validator = new CreateTableRequestValidator();
        List<Error> errors = validator.validate(request);
        if (errors.size() != 0) {
            throw new AmazonServiceException(errors.toString());
        }
        String tableName = request.getTableName();
        if (this.tables.containsKey(tableName)) {
            throw new ResourceInUseException("The table you're currently trying to create (" + tableName + ") is already available.");
        }
        Table table = new Table(tableName, request.getKeySchema(), request.getProvisionedThroughput());
        this.tables.put(tableName, table);
        this.tableList.add(table);
        return new CreateTableResult().withTableDescription(table.getTableDescription());
    }

    public com.amazonaws.services.dynamodbv2.model.CreateTableResult createTableV2(com.amazonaws.services.dynamodbv2.model.CreateTableRequest v2Request) throws LimitExceededException, InternalServerErrorException, ResourceInUseException {
        CreateTableRequest request = AlternatorDBApiVersion2Mapper.MapV2CreateTableRequestToV1(v2Request);
        try {
            CreateTableResult result = this.createTable(request);
            return AlternatorDBApiVersion2Mapper.MapV1CreateTableResultToV2(result);
        }
        catch (ResourceInUseException ex) {
            throw new com.amazonaws.services.dynamodbv2.model.ResourceInUseException(ex.getMessage());
        }
    }

    public synchronized DescribeTableResult describeTable(com.amazonaws.services.dynamodb.model.DescribeTableRequest request) throws InternalServerErrorException, com.amazonaws.services.dynamodb.model.ResourceNotFoundException {
        DescribeTableRequestValidator validator = new DescribeTableRequestValidator();
        List<Error> errors = validator.validate(request);
        if (errors.size() != 0) {
            throw new AmazonServiceException(errors.toString());
        }
        String tableName = request.getTableName();
        DescribeTableResult result = null;
        if (!this.tables.containsKey(tableName)) {
            throw new com.amazonaws.services.dynamodb.model.ResourceNotFoundException("The table '" + tableName + "' does not exist.");
        }
        Table table = this.tables.get(tableName);
        result = new DescribeTableResult().withTable(table.getTableDescription());
        return result;
    }

    public com.amazonaws.services.dynamodbv2.model.DescribeTableResult describeTableV2(DescribeTableRequest v2Request) throws InternalServerErrorException, com.amazonaws.services.dynamodb.model.ResourceNotFoundException {
        com.amazonaws.services.dynamodb.model.DescribeTableRequest request = AlternatorDBApiVersion2Mapper.MapV2DescribeTableRequestToV1(v2Request);
        DescribeTableResult result = this.describeTable(request);
        return AlternatorDBApiVersion2Mapper.MapV1DescribeTableResultToV2(result);
    }

    public synchronized com.amazonaws.services.dynamodb.model.ListTablesResult listTables(ListTablesRequest request) throws InternalServerErrorException, com.amazonaws.services.dynamodb.model.ResourceNotFoundException {
        ListTablesRequestValidator validator = new ListTablesRequestValidator();
        List<Error> errors = validator.validate(request);
        if (errors.size() != 0) {
            throw this.createInternalServerException(errors);
        }
        String startTableName = request.getExclusiveStartTableName();
        Integer limit = request.getLimit();
        if (limit == null) {
            limit = 100;
        }
        int startIndex = 0;
        if (startTableName != null) {
            if (this.tables.containsKey(startTableName)) {
                for (int i = 0; i < this.tableList.size(); ++i) {
                    if (!this.tableList.get(i).getName().equals(startTableName)) continue;
                    startIndex = i;
                    break;
                }
            } else {
                throw new com.amazonaws.services.dynamodb.model.ResourceNotFoundException("The ExclusiveStartTableName '" + startTableName + "' doesn't exist.");
            }
        }
        int size = this.tableList.size();
        Boolean setTableName = false;
        if (size > startIndex + limit) {
            size = startIndex + limit;
            setTableName = true;
        }
        ArrayList<String> tables = new ArrayList<String>();
        for (int i = startIndex; i < size; ++i) {
            tables.add(this.tableList.get(i).getName());
        }
        com.amazonaws.services.dynamodb.model.ListTablesResult result = new com.amazonaws.services.dynamodb.model.ListTablesResult().withTableNames(tables);
        if (setTableName.booleanValue()) {
            result.setLastEvaluatedTableName(this.tableList.get(size).getName());
        }
        return result;
    }

    public ListTablesResult listTablesV2(com.amazonaws.services.dynamodbv2.model.ListTablesRequest v2Request) throws InternalServerErrorException, com.amazonaws.services.dynamodb.model.ResourceNotFoundException {
        ListTablesRequest request = AlternatorDBApiVersion2Mapper.MapV2ListTablesRequestToV1(v2Request);
        com.amazonaws.services.dynamodb.model.ListTablesResult result = this.listTables(request);
        return AlternatorDBApiVersion2Mapper.MapV1ListTablesResultToV2(result);
    }

    public synchronized DeleteTableResult deleteTable(DeleteTableRequest request) throws InternalServerErrorException, com.amazonaws.services.dynamodb.model.ResourceNotFoundException {
        DeleteTableRequestValidator validator = new DeleteTableRequestValidator();
        List<Error> errors = validator.validate(request);
        if (errors.size() != 0) {
            throw new AmazonServiceException(errors.toString());
        }
        if (!this.tables.containsKey(request.getTableName())) {
            throw new com.amazonaws.services.dynamodb.model.ResourceNotFoundException("The table you want to delete '" + request.getTableName() + "' doesn't exist.");
        }
        Table table = this.tables.remove(request.getTableName());
        this.tableList.remove(table);
        return new DeleteTableResult().withTableDescription(table.getTableDescription().withTableStatus(TableStatus.DELETING));
    }

    public com.amazonaws.services.dynamodbv2.model.DeleteTableResult deleteTableV2(com.amazonaws.services.dynamodbv2.model.DeleteTableRequest v2Request) throws InternalServerErrorException, com.amazonaws.services.dynamodb.model.ResourceNotFoundException {
        DeleteTableRequest request = AlternatorDBApiVersion2Mapper.MapV2DeleteTableRequestToV1(v2Request);
        try {
            DeleteTableResult result = this.deleteTable(request);
            return AlternatorDBApiVersion2Mapper.MapV1DeleteTableResultToV2(result);
        }
        catch (com.amazonaws.services.dynamodb.model.ResourceNotFoundException ex) {
            throw new ResourceNotFoundException(ex.getMessage());
        }
    }

    public synchronized UpdateTableResult updateTable(UpdateTableRequest request) throws InternalServerErrorException, com.amazonaws.services.dynamodb.model.ResourceNotFoundException {
        UpdateTableRequestValidator validator = new UpdateTableRequestValidator();
        List<Error> errors = validator.validate(request);
        if (errors.size() != 0) {
            throw new AmazonServiceException(errors.toString());
        }
        if (!this.tables.containsKey(request.getTableName())) {
            throw new com.amazonaws.services.dynamodb.model.ResourceNotFoundException("The table '" + request.getTableName() + "' doesn't exist.");
        }
        Table table = this.tables.get(request.getTableName());
        table.setProvisionedThroughput(request.getProvisionedThroughput());
        return new UpdateTableResult().withTableDescription(table.getTableDescription());
    }

    public com.amazonaws.services.dynamodbv2.model.UpdateTableResult updateTableV2(com.amazonaws.services.dynamodbv2.model.UpdateTableRequest v2Request) throws InternalServerErrorException, com.amazonaws.services.dynamodb.model.ResourceNotFoundException {
        UpdateTableRequest request = AlternatorDBApiVersion2Mapper.MapV2UpdateTableRequestToV1(v2Request);
        UpdateTableResult result = this.updateTable(request);
        return AlternatorDBApiVersion2Mapper.MapV1UpdateTableResultToV2(result);
    }

    public synchronized com.amazonaws.services.dynamodb.model.PutItemResult putItem(com.amazonaws.services.dynamodb.model.PutItemRequest request) throws InternalServerErrorException, com.amazonaws.services.dynamodb.model.ResourceNotFoundException, com.amazonaws.services.dynamodb.model.ConditionalCheckFailedException {
        PutItemRequestValidator validator = new PutItemRequestValidator();
        List<Error> errors = validator.validate(request);
        if (errors.size() != 0) {
            throw new AmazonServiceException(errors.toString());
        }
        Table table = this.tables.get(request.getTableName());
        if (table == null) {
            throw new com.amazonaws.services.dynamodb.model.ResourceNotFoundException("The table '" + request.getTableName() + "' doesn't exist.");
        }
        KeySchemaElement hashKey = table.getKeySchema().getHashKeyElement();
        KeySchemaElement rangeKey = table.getKeySchema().getRangeKeyElement();
        AttributeValue hashItem = (AttributeValue)request.getItem().get(hashKey.getAttributeName());
        AttributeValueType hashItemType = this.getAttributeValueType(hashItem);
        if (hashItem == null || hashItemType != AttributeValueType.fromString(hashKey.getAttributeType())) {
            throw new InternalServerErrorException("Missing hash key (" + hashKey.getAttributeName() + ") from item: " + request.getItem());
        }
        if (rangeKey != null) {
            AttributeValue rangeItem = (AttributeValue)request.getItem().get(rangeKey.getAttributeName());
            AttributeValueType rangeItemType = this.getAttributeValueType(rangeItem);
            if (rangeItem == null || rangeItemType != AttributeValueType.fromString(rangeKey.getAttributeType())) {
                throw new InternalServerErrorException("Missing range key (" + rangeKey.getAttributeName() + ") from item: " + request.getItem());
            }
        }
        Map requestItem = request.getItem();
        String hashKeyValue = this.getKeyValue((AttributeValue)requestItem.get(table.getHashKeyName()));
        String rangeKeyValue = this.getKeyValue((AttributeValue)requestItem.get(table.getRangeKeyName()));
        Map<String, AttributeValue> item = table.getItem(hashKeyValue, rangeKeyValue);
        this.validateExpected(request.getExpected(), item);
        com.amazonaws.services.dynamodb.model.PutItemResult result = new com.amazonaws.services.dynamodb.model.PutItemResult().withConsumedCapacityUnits(Double.valueOf(1.0));
        if (item != null && request.getReturnValues() != null && ReturnValue.fromValue((String)request.getReturnValues()) == ReturnValue.ALL_OLD) {
            result.setAttributes(item);
        }
        table.putItem(request.getItem());
        return result;
    }

    private boolean compareAttributeValues(AttributeValue a, AttributeValue b) {
        if (a.getB() != null && a.getB().equals(b.getB())) {
            return true;
        }
        if (a.getN() != null && a.getN().equals(b.getN())) {
            return true;
        }
        if (a.getS() != null && a.getS().equals(b.getS())) {
            return true;
        }
        return a.getSS() != null && a.getSS().equals(b.getSS());
    }

    public synchronized PutItemResult putItemV2(PutItemRequest v2Request) throws InternalServerErrorException, com.amazonaws.services.dynamodb.model.ResourceNotFoundException, com.amazonaws.services.dynamodb.model.ConditionalCheckFailedException {
        com.amazonaws.services.dynamodb.model.PutItemRequest request = AlternatorDBApiVersion2Mapper.MapV2PutItemRequestToV1(v2Request);
        try {
            com.amazonaws.services.dynamodb.model.PutItemResult result = this.putItem(request);
            return AlternatorDBApiVersion2Mapper.MapV1PutItemResultToV2(result, v2Request.getTableName());
        }
        catch (com.amazonaws.services.dynamodb.model.ConditionalCheckFailedException ex) {
            throw new ConditionalCheckFailedException(ex.getMessage());
        }
    }

    public synchronized com.amazonaws.services.dynamodb.model.GetItemResult getItem(GetItemRequest request) throws InternalServerErrorException, com.amazonaws.services.dynamodb.model.ResourceNotFoundException {
        GetItemRequestValidator validator = new GetItemRequestValidator();
        List<Error> errors = validator.validate(request);
        if (errors.size() != 0) {
            throw new AmazonServiceException(errors.toString());
        }
        String tableName = request.getTableName();
        Key key = request.getKey();
        List attributesToGet = request.getAttributesToGet();
        com.amazonaws.services.dynamodb.model.GetItemResult result = new com.amazonaws.services.dynamodb.model.GetItemResult();
        if (!this.tables.containsKey(tableName)) {
            throw new com.amazonaws.services.dynamodb.model.ResourceNotFoundException("The table you're currently trying to access (" + tableName + ") doesn't exists.");
        }
        String hashKeyValue = this.getKeyValue(key.getHashKeyElement());
        ItemRangeGroup rangeGroup = this.tables.get(tableName).getItemRangeGroup(hashKeyValue);
        if (rangeGroup == null) {
            return new com.amazonaws.services.dynamodb.model.GetItemResult();
        }
        String rangeKeyValue = this.getKeyValue(key.getRangeKeyElement());
        Map<String, AttributeValue> item = this.tables.get(tableName).getItem(hashKeyValue, rangeKeyValue);
        if (item == null) {
            return new com.amazonaws.services.dynamodb.model.GetItemResult();
        }
        if (attributesToGet == null) {
            result.setItem(item);
        } else {
            HashMap<String, AttributeValue> response = new HashMap<String, AttributeValue>();
            for (String att : attributesToGet) {
                AttributeValue res = item.get(att);
                if (res == null) continue;
                response.put(att, res);
            }
            result.setItem(response);
        }
        return result;
    }

    public GetItemResult getItemV2(com.amazonaws.services.dynamodbv2.model.GetItemRequest v2Request) throws InternalServerErrorException, com.amazonaws.services.dynamodb.model.ResourceNotFoundException {
        Table table = this.tables.get(v2Request.getTableName());
        GetItemRequest request = AlternatorDBApiVersion2Mapper.MapV2GetItemRequestToV1(v2Request, table);
        com.amazonaws.services.dynamodb.model.GetItemResult result = this.getItem(request);
        return AlternatorDBApiVersion2Mapper.MapV1GetItemResultToV2(result, v2Request.getTableName());
    }

    public synchronized com.amazonaws.services.dynamodb.model.DeleteItemResult deleteItem(DeleteItemRequest request) {
        String rangeKey;
        DeleteItemRequestValidator validator = new DeleteItemRequestValidator();
        List<Error> errors = validator.validate(request);
        if (errors.size() != 0) {
            throw new AmazonServiceException(errors.toString());
        }
        Table table = this.tables.get(request.getTableName());
        if (table == null) {
            throw new com.amazonaws.services.dynamodb.model.ResourceNotFoundException("The table '" + request.getTableName() + "' doesn't exist.");
        }
        String hashKey = this.getKeyValue(request.getKey().getHashKeyElement());
        Map<String, AttributeValue> item = table.getItem(hashKey, rangeKey = this.getKeyValue(request.getKey().getRangeKeyElement()));
        if (item == null) {
            if (rangeKey == null) {
                throw new com.amazonaws.services.dynamodb.model.ResourceNotFoundException("The item with hash key '" + hashKey + "' doesn't exist in table '" + table.getName() + "'");
            }
            throw new com.amazonaws.services.dynamodb.model.ResourceNotFoundException("The item with hash key '" + hashKey + "' and range key '" + rangeKey + "' doesn't exist in table '" + table.getName() + "'");
        }
        this.validateExpected(request.getExpected(), item);
        com.amazonaws.services.dynamodb.model.DeleteItemResult result = new com.amazonaws.services.dynamodb.model.DeleteItemResult().withConsumedCapacityUnits(Double.valueOf(1.0));
        if (item != null && request.getReturnValues() != null && ReturnValue.fromValue((String)request.getReturnValues()) == ReturnValue.ALL_OLD) {
            result.setAttributes(item);
        }
        table.removeItem(hashKey, rangeKey);
        return result;
    }

    public DeleteItemResult deleteItemV2(com.amazonaws.services.dynamodbv2.model.DeleteItemRequest v2Request) {
        Table table = this.tables.get(v2Request.getTableName());
        DeleteItemRequest request = AlternatorDBApiVersion2Mapper.MapV2DeleteItemRequestToV1(v2Request, table);
        com.amazonaws.services.dynamodb.model.DeleteItemResult result = this.deleteItem(request);
        return AlternatorDBApiVersion2Mapper.MapV1DeleteItemResultToV2(result, v2Request.getTableName());
    }

    public synchronized com.amazonaws.services.dynamodb.model.BatchGetItemResult batchGetItem(BatchGetItemRequest request) {
        com.amazonaws.services.dynamodb.model.BatchGetItemResult batchGetItemResult = new com.amazonaws.services.dynamodb.model.BatchGetItemResult();
        HashMap<String, BatchResponse> response = new HashMap<String, BatchResponse>();
        for (String tableName : request.getRequestItems().keySet()) {
            BatchResponse batchResponse = new BatchResponse();
            ArrayList<Map<String, AttributeValue>> items = new ArrayList<Map<String, AttributeValue>>();
            KeysAndAttributes keysAndAttributes = (KeysAndAttributes)request.getRequestItems().get(tableName);
            List itemKeys = keysAndAttributes.getKeys();
            List attributeToGet = keysAndAttributes.getAttributesToGet();
            try {
                for (Key itemKey : itemKeys) {
                    try {
                        String hashKeyValue = this.getKeyValue(itemKey.getHashKeyElement());
                        String rangeKeyValue = this.getKeyValue(itemKey.getRangeKeyElement());
                        Map<String, AttributeValue> item = this.tables.get(tableName).getItem(hashKeyValue, rangeKeyValue);
                        if ((item = this.getItemWithAttributesToGet(item, (List<String>)attributeToGet)) == null) continue;
                        items.add(item);
                    }
                    catch (NullPointerException e) {
                        System.err.println("Caught NullPointerException: " + e.getMessage());
                    }
                }
            }
            catch (NullPointerException e) {
                System.err.println("Caught NullPointerException: " + e.getMessage());
            }
            batchResponse.setConsumedCapacityUnits(Double.valueOf(1.0));
            if (items.size() == 0) continue;
            batchResponse.setItems(items);
            response.put(tableName, batchResponse);
            batchGetItemResult.setResponses(response);
            batchGetItemResult.getResponses().put(tableName, batchResponse);
        }
        batchGetItemResult.setUnprocessedKeys(new HashMap());
        return batchGetItemResult;
    }

    public BatchGetItemResult batchGetItemV2(com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest v2Request) {
        BatchGetItemRequest request = AlternatorDBApiVersion2Mapper.MapV2BatchGetItemRequestToV1(v2Request, this.tables);
        com.amazonaws.services.dynamodb.model.BatchGetItemResult result = this.batchGetItem(request);
        return AlternatorDBApiVersion2Mapper.MapV1BatchGetItemResultToV2(result, this.tables);
    }

    public synchronized BatchWriteItemResult batchWriteItem(com.amazonaws.services.dynamodb.model.BatchWriteItemRequest request) {
        BatchWriteItemResult batchWriteItemResult = new BatchWriteItemResult();
        HashMap<String, BatchWriteResponse> responses = new HashMap<String, BatchWriteResponse>();
        for (String tableName : request.getRequestItems().keySet()) {
            BatchWriteResponse batchWriteResponse = new BatchWriteResponse();
            List writeRequests = (List)request.getRequestItems().get(tableName);
            for (WriteRequest writeRequest : writeRequests) {
                Key key;
                DeleteRequest deleteRequest;
                com.amazonaws.services.dynamodb.model.PutRequest putRequest = writeRequest.getPutRequest();
                if (putRequest != null) {
                    this.tables.get(tableName).putItem(putRequest.getItem());
                }
                if ((deleteRequest = writeRequest.getDeleteRequest()) == null || (key = deleteRequest.getKey()) == null) continue;
                this.tables.get(tableName).removeItem(key.getHashKeyElement().getS());
            }
            batchWriteResponse.setConsumedCapacityUnits(Double.valueOf(1.0));
            responses.put(tableName, batchWriteResponse);
        }
        batchWriteItemResult.setResponses(responses);
        batchWriteItemResult.setUnprocessedItems(new HashMap());
        return batchWriteItemResult;
    }

    public com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult batchWriteItemV2(BatchWriteItemRequest v2Request) {
        try {
            com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult batchWriteItemResult = new com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult();
            ArrayList<ConsumedCapacity> v2Capacities = new ArrayList<ConsumedCapacity>();
            for (String tableName : v2Request.getRequestItems().keySet()) {
                List writeRequests = (List)v2Request.getRequestItems().get(tableName);
                for (com.amazonaws.services.dynamodbv2.model.WriteRequest writeRequest : writeRequests) {
                    com.amazonaws.services.dynamodbv2.model.DeleteRequest deleteRequest;
                    PutRequest putRequest = writeRequest.getPutRequest();
                    if (putRequest != null) {
                        PutItemRequest putItemRequest = new PutItemRequest().withTableName(tableName).withItem(putRequest.getItem());
                        this.putItemV2(putItemRequest);
                    }
                    if ((deleteRequest = writeRequest.getDeleteRequest()) == null) continue;
                    com.amazonaws.services.dynamodbv2.model.DeleteItemRequest deleteItemRequest = new com.amazonaws.services.dynamodbv2.model.DeleteItemRequest().withTableName(tableName).withKey(deleteRequest.getKey());
                    this.deleteItemV2(deleteItemRequest);
                }
                v2Capacities.add(new ConsumedCapacity().withTableName(tableName).withCapacityUnits(Double.valueOf(1.0)));
            }
            batchWriteItemResult.setUnprocessedItems(new HashMap());
            batchWriteItemResult.setConsumedCapacity(v2Capacities);
            return batchWriteItemResult;
        }
        catch (com.amazonaws.services.dynamodb.model.ResourceNotFoundException rnfe) {
            throw new ResourceNotFoundException(rnfe.getMessage());
        }
    }

    private boolean isComparableInScan(AttributeValue value, AttributeValue comp) {
        if (comp == null) {
            return false;
        }
        AttributeValueType compType = this.getAttributeValueType(comp);
        AttributeValueType valueType = this.getAttributeValueType(value);
        return (compType.equals((Object)AttributeValueType.N) || compType.equals((Object)AttributeValueType.S)) && compType.equals((Object)valueType);
    }

    private int compareForScan(AttributeValue value, AttributeValue comp) {
        AttributeValueType valueType = this.getAttributeValueType(value);
        if (valueType.equals((Object)AttributeValueType.S)) {
            return value.getS().compareTo(comp.getS());
        }
        if (valueType.equals((Object)AttributeValueType.N)) {
            try {
                return new Long(value.getN()).compareTo(new Long(comp.getN()));
            }
            catch (NumberFormatException e) {
                return new Double(value.getN()).compareTo(new Double(comp.getN()));
            }
        }
        throw new IllegalArgumentException("Can only compare String and Number types, got " + (Object)((Object)valueType));
    }

    private String getAttributeValueAsString(AttributeValue value) {
        AttributeValueType valueType = this.getAttributeValueType(value);
        if (valueType.equals((Object)AttributeValueType.N)) {
            return value.getN();
        }
        if (valueType.equals((Object)AttributeValueType.S)) {
            return value.getS();
        }
        throw new IllegalArgumentException("Can only return values for Number and String, got " + (Object)((Object)valueType));
    }

    public synchronized ScanResult scan(ScanRequest request) {
        ScanResult result = new ScanResult();
        List<Error> errors = new ScanRequestValidator().validate(request);
        if (errors.size() > 0) {
            throw this.createInternalServerException(errors);
        }
        result.setConsumedCapacityUnits(Double.valueOf(0.5));
        List<Map<String, Object>> items = new ArrayList<Map<String, AttributeValue>>();
        for (String key : this.tables.get(request.getTableName()).getItemRangeGroups().keySet()) {
            ItemRangeGroup rangeGroup = this.tables.get(request.getTableName()).getItemRangeGroup(key);
            for (String rangeKey : rangeGroup.getKeySet()) {
                Map<String, AttributeValue> item;
                block10: {
                    item = rangeGroup.getItem(rangeKey);
                    if (request.getScanFilter() == null) break block10;
                    boolean shouldAddItem = true;
                    for (String k : request.getScanFilter().keySet()) {
                        boolean conditionMatches;
                        block11: {
                            Condition cond;
                            block19: {
                                int condSize;
                                AttributeValue comp;
                                AttributeValue attribute;
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    block13: {
                                                        block12: {
                                                            conditionMatches = false;
                                                            attribute = item.get(k);
                                                            if (attribute == null) break block11;
                                                            cond = (Condition)request.getScanFilter().get(k);
                                                            comp = cond.getAttributeValueList().isEmpty() ? null : (AttributeValue)cond.getAttributeValueList().get(0);
                                                            condSize = cond.getAttributeValueList().size();
                                                            if (cond.getComparisonOperator() == null) {
                                                                throw new com.amazonaws.services.dynamodb.model.ResourceNotFoundException("There must be a comparisonOperator");
                                                            }
                                                            if (!cond.getComparisonOperator().equals("EQ")) break block12;
                                                            if (condSize != 1 || !this.isComparableInScan(attribute, comp)) break block11;
                                                            conditionMatches = this.compareForScan(attribute, comp) == 0;
                                                            break block11;
                                                        }
                                                        if (!cond.getComparisonOperator().equals("LE")) break block13;
                                                        if (condSize != 1 || !this.isComparableInScan(attribute, comp)) break block11;
                                                        conditionMatches = this.compareForScan(attribute, comp) <= 0;
                                                        break block11;
                                                    }
                                                    if (!cond.getComparisonOperator().equals("LT")) break block14;
                                                    if (condSize != 1 || !this.isComparableInScan(attribute, comp)) break block11;
                                                    conditionMatches = this.compareForScan(attribute, comp) < 0;
                                                    break block11;
                                                }
                                                if (!cond.getComparisonOperator().equals("GE")) break block15;
                                                if (condSize != 1 || !this.isComparableInScan(attribute, comp)) break block11;
                                                conditionMatches = this.compareForScan(attribute, comp) >= 0;
                                                break block11;
                                            }
                                            if (!cond.getComparisonOperator().equals("GT")) break block16;
                                            if (condSize != 1 || !this.isComparableInScan(attribute, comp)) break block11;
                                            conditionMatches = this.compareForScan(attribute, comp) > 0;
                                            break block11;
                                        }
                                        if (!cond.getComparisonOperator().equals("BETWEEN")) break block17;
                                        if (condSize != 2) break block11;
                                        AttributeValue comp2 = (AttributeValue)cond.getAttributeValueList().get(1);
                                        if (this.isComparableInScan(attribute, comp) && this.isComparableInScan(attribute, comp2)) {
                                            conditionMatches = this.compareForScan(attribute, comp) >= 0 && this.compareForScan(attribute, comp2) <= 0;
                                        }
                                        break block11;
                                    }
                                    if (!cond.getComparisonOperator().equals("BEGINS_WITH")) break block18;
                                    if (condSize != 1 || !this.getAttributeValueType(attribute).equals((Object)AttributeValueType.S) || !this.getAttributeValueType(comp).equals((Object)AttributeValueType.S)) break block11;
                                    conditionMatches = attribute.getS().startsWith(comp.getS());
                                    break block11;
                                }
                                if (!cond.getComparisonOperator().equals("CONTAINS")) break block19;
                                if (condSize != 1 || !this.getAttributeValueType(item.get(k)).equals((Object)AttributeValueType.S) && !this.getAttributeValueType(item.get(k)).equals((Object)AttributeValueType.N)) break block11;
                                String value = this.getAttributeValueAsString(attribute);
                                String subs = this.getAttributeValueAsString(comp);
                                conditionMatches = value.contains(subs);
                                break block11;
                            }
                            if (cond.getComparisonOperator().equals("IN")) {
                                for (AttributeValue value : cond.getAttributeValueList()) {
                                    if (!item.get(k).equals((Object)value)) continue;
                                    conditionMatches = true;
                                    break;
                                }
                            }
                        }
                        shouldAddItem = shouldAddItem && conditionMatches;
                    }
                    if (!shouldAddItem) continue;
                    items.add(item);
                    continue;
                }
                items.add(item);
            }
        }
        if (request.getLimit() != null && items.size() > request.getLimit()) {
            items = items.subList(0, request.getLimit() - 1);
        }
        if (request.getAttributesToGet() != null) {
            List<Map<String, AttributeValue>> copy = this.getItemWithAttributesToGet(items, (List<String>)request.getAttributesToGet());
            items = copy;
        }
        result.setItems(items);
        result.setCount(Integer.valueOf(items.size()));
        result.setScannedCount(Integer.valueOf(items.size()));
        return result;
    }

    public com.amazonaws.services.dynamodbv2.model.ScanResult scanV2(com.amazonaws.services.dynamodbv2.model.ScanRequest v2Request) {
        Table table = this.tables.get(v2Request.getTableName());
        ScanRequest request = AlternatorDBApiVersion2Mapper.MapV2ScanRequestToV1(v2Request, table);
        ScanResult result = this.scan(request);
        return AlternatorDBApiVersion2Mapper.MapV1ScanResultToV2(result, table);
    }

    public synchronized com.amazonaws.services.dynamodb.model.QueryResult query(QueryRequest request) {
        QueryRequestValidator validator = new QueryRequestValidator();
        List<Error> errors = validator.validate(request);
        if (errors.size() != 0) {
            throw this.createInternalServerException(errors);
        }
        Table table = this.tables.get(request.getTableName());
        if (table == null) {
            throw new com.amazonaws.services.dynamodb.model.ResourceNotFoundException("The table '" + request.getTableName() + "' doesn't exist.");
        }
        String hashKeyValue = this.getKeyValue(request.getHashKeyValue());
        List attributesToGet = request.getAttributesToGet();
        com.amazonaws.services.dynamodb.model.QueryResult queryResult = new com.amazonaws.services.dynamodb.model.QueryResult();
        ArrayList<Map<String, AttributeValue>> list = new ArrayList<Map<String, AttributeValue>>();
        KeySchema keySchema = table.getKeySchema();
        KeySchemaElement rangeKeyElement = keySchema.getRangeKeyElement();
        ItemRangeGroup rangeGroup = table.getItemRangeGroup(hashKeyValue);
        if (rangeGroup != null) {
            for (Map<String, AttributeValue> item : rangeGroup.getItems(rangeKeyElement, request.getRangeKeyCondition())) {
                if (request.getScanIndexForward() == null || request.getScanIndexForward().booleanValue()) {
                    list.add(this.getItemWithAttributesToGet(item, (List<String>)attributesToGet));
                    continue;
                }
                list.add(0, this.getItemWithAttributesToGet(item, (List<String>)attributesToGet));
            }
        }
        if (request.getLimit() != null && request.getLimit() > 0) {
            while (list.size() > request.getLimit()) {
                list.remove(request.getLimit());
            }
        }
        queryResult.setItems(list);
        queryResult.setCount(Integer.valueOf(list.size()));
        queryResult.setConsumedCapacityUnits(Double.valueOf(0.5));
        queryResult.setLastEvaluatedKey(null);
        return queryResult;
    }

    public QueryResult queryV2(com.amazonaws.services.dynamodbv2.model.QueryRequest v2Request) {
        Table table = this.tables.get(v2Request.getTableName());
        QueryRequest request = AlternatorDBApiVersion2Mapper.MapV2QueryRequestToV1(v2Request, table);
        com.amazonaws.services.dynamodb.model.QueryResult result = this.query(request);
        return AlternatorDBApiVersion2Mapper.MapV1QueryResultToV2(result, table);
    }

    public String getKeyValue(AttributeValue value) {
        if (value != null) {
            if (value.getN() != null) {
                return value.getN();
            }
            if (value.getS() != null) {
                return value.getS();
            }
        }
        return null;
    }

    public AttributeValueType getAttributeValueType(AttributeValue value) {
        if (value != null) {
            if (value.getN() != null) {
                return AttributeValueType.N;
            }
            if (value.getS() != null) {
                return AttributeValueType.S;
            }
            if (value.getNS() != null) {
                return AttributeValueType.NS;
            }
            if (value.getSS() != null) {
                return AttributeValueType.SS;
            }
        }
        return AttributeValueType.UNKNOWN;
    }

    public InternalServerErrorException createInternalServerException(List<Error> errors) {
        String message = "The following Errors occured: ";
        for (Error error : errors) {
            message = message + error.getMessage() + "\n";
        }
        return new InternalServerErrorException(message);
    }

    public synchronized com.amazonaws.services.dynamodb.model.UpdateItemResult updateItem(UpdateItemRequest request) {
        UpdateItemRequestValidator validator = new UpdateItemRequestValidator();
        List<Error> errors = validator.validate(request);
        if (errors.size() != 0) {
            throw new AmazonServiceException(errors.toString());
        }
        String tableName = request.getTableName();
        Key key = request.getKey();
        Map expected = request.getExpected();
        Map attributesToUpdate = request.getAttributeUpdates();
        String returnValues = request.getReturnValues();
        com.amazonaws.services.dynamodb.model.UpdateItemResult result = new com.amazonaws.services.dynamodb.model.UpdateItemResult();
        result.setConsumedCapacityUnits(Double.valueOf(0.5));
        if (!this.tables.containsKey(tableName)) {
            throw new com.amazonaws.services.dynamodb.model.ResourceNotFoundException("The table you're currently trying to access (" + tableName + ") doesn't exists.");
        }
        String hashKeyValue = this.getKeyValue(key.getHashKeyElement());
        String rangeKeyValue = this.getKeyValue(key.getRangeKeyElement());
        Map<String, AttributeValue> item = this.tables.get(tableName).getItem(hashKeyValue, rangeKeyValue);
        this.validateExpected(request.getExpected(), item);
        if (item == null) {
            item = new HashMap<String, AttributeValue>();
            item.put(this.tables.get(tableName).getHashKeyName(), key.getHashKeyElement());
            if (key.getRangeKeyElement() != null) {
                item.put(this.tables.get(tableName).getRangeKeyName(), key.getRangeKeyElement());
            }
            for (String sKey : attributesToUpdate.keySet()) {
                if (((AttributeValueUpdate)attributesToUpdate.get(sKey)).getValue() == null) continue;
                item.put(sKey, ((AttributeValueUpdate)attributesToUpdate.get(sKey)).getValue());
            }
            this.tables.get(tableName).putItem(item);
            result.setAttributes(item);
        } else {
            HashSet<String> sKeyz = new HashSet<String>(item.keySet());
            sKeyz.addAll(attributesToUpdate.keySet());
            for (String sKey : sKeyz) {
                if (!attributesToUpdate.containsKey(sKey)) continue;
                if (((AttributeValueUpdate)attributesToUpdate.get(sKey)).getAction().equalsIgnoreCase(AttributeAction.PUT.name())) {
                    item.remove(sKey);
                    item.put(sKey, ((AttributeValueUpdate)attributesToUpdate.get(sKey)).getValue());
                    attributesToUpdate.remove(sKey);
                    continue;
                }
                if (((AttributeValueUpdate)attributesToUpdate.get(sKey)).getAction().equalsIgnoreCase(AttributeAction.DELETE.name())) {
                    if (((AttributeValueUpdate)attributesToUpdate.get(sKey)).getValue() != null) {
                        this.deleteAttributeValue(item, sKey, (AttributeValueUpdate)attributesToUpdate.get(sKey));
                    } else {
                        item.remove(sKey);
                    }
                    attributesToUpdate.remove(sKey);
                    continue;
                }
                if (!((AttributeValueUpdate)attributesToUpdate.get(sKey)).getAction().equalsIgnoreCase(AttributeAction.ADD.name())) continue;
                if (((AttributeValueUpdate)attributesToUpdate.get(sKey)).getValue() != null) {
                    this.addAttributeValue(item, sKey, (AttributeValueUpdate)attributesToUpdate.get(sKey));
                    continue;
                }
                throw new com.amazonaws.services.dynamodb.model.ResourceNotFoundException("the provided update item with attribute (" + sKey + ") doesn't have an AttributeValue to perform the ADD");
            }
            result.setAttributes(item);
        }
        return result;
    }

    public UpdateItemResult updateItemV2(com.amazonaws.services.dynamodbv2.model.UpdateItemRequest v2Request) {
        Table table = this.tables.get(v2Request.getTableName());
        UpdateItemRequest request = AlternatorDBApiVersion2Mapper.MapV2UpdateItemRequestToV1(v2Request, table);
        try {
            com.amazonaws.services.dynamodb.model.UpdateItemResult result = this.updateItem(request);
            return AlternatorDBApiVersion2Mapper.MapV1UpdateItemResultToV2(result, v2Request.getTableName());
        }
        catch (com.amazonaws.services.dynamodb.model.ConditionalCheckFailedException ccfev1) {
            throw new ConditionalCheckFailedException(ccfev1.getMessage());
        }
    }

    public Map<String, AttributeValue> getItemWithAttributesToGet(Map<String, AttributeValue> item, List<String> attributesToGet) {
        if (item == null) {
            return item;
        }
        if (attributesToGet == null) {
            return item;
        }
        HashSet<String> attributes = new HashSet<String>(item.keySet());
        for (String attribute : attributes) {
            if (attributesToGet.contains(attribute)) continue;
            item.remove(attribute);
        }
        return item;
    }

    public List<Map<String, AttributeValue>> getItemWithAttributesToGet(List<Map<String, AttributeValue>> items, List<String> attributesToGet) {
        ArrayList<Map<String, AttributeValue>> copy = new ArrayList<Map<String, AttributeValue>>();
        for (Map<String, AttributeValue> item : items) {
            copy.add(this.getItemWithAttributesToGet(item, attributesToGet));
        }
        return copy;
    }

    private void addAttributeValue(Map<String, AttributeValue> item, String attributename, AttributeValueUpdate valueUpdate) {
        block8: {
            AttributeValue value;
            block10: {
                block9: {
                    block7: {
                        value = item.get(attributename);
                        if (value != null) break block7;
                        value = valueUpdate.getValue();
                        item.put(attributename, value);
                        break block8;
                    }
                    if (value.getSS() == null) break block9;
                    if (valueUpdate.getValue().getSS() == null) {
                        throw new com.amazonaws.services.dynamodb.model.ConditionalCheckFailedException("It's not possible to ADD something else than a List<String> for the attribute (" + attributename + ")");
                    }
                    for (String toUp : valueUpdate.getValue().getSS()) {
                        value.getSS().add(toUp);
                    }
                    break block8;
                }
                if (value.getNS() == null) break block10;
                if (valueUpdate.getValue().getNS() == null) {
                    throw new com.amazonaws.services.dynamodb.model.ConditionalCheckFailedException("It's not possible to ADD something else than a List<Number> for the attribute (" + attributename + ")");
                }
                for (String toUp : valueUpdate.getValue().getNS()) {
                    value.getNS().add(toUp);
                }
                break block8;
            }
            if (value.getS() != null) {
                throw new com.amazonaws.services.dynamodb.model.ConditionalCheckFailedException("It's not possible to ADD on an attribute with a String type for the attribute (" + attributename + ")");
            }
            if (value.getN() == null) break block8;
            try {
                Long l = Long.valueOf(value.getN());
                l = l + Long.valueOf(valueUpdate.getValue().getN());
                value.setN(l + "");
            }
            catch (NumberFormatException e) {
                Double i = new Double(value.getN());
                i = i + new Double(valueUpdate.getValue().getN());
                value.setN(i + "");
            }
        }
    }

    private void deleteAttributeValue(Map<String, AttributeValue> item, String attributename, AttributeValueUpdate valueToDelete) {
        AttributeValue existingValue = item.get(attributename);
        if (existingValue == null) {
            return;
        }
        if (existingValue.getSS() != null) {
            if (valueToDelete.getValue().getSS() == null) {
                throw new com.amazonaws.services.dynamodb.model.ConditionalCheckFailedException("It's not possible to delete something else than a List<String> for the attribute (" + attributename + ") of the item with hash key (" + existingValue + ")");
            }
            for (String toDel : valueToDelete.getValue().getSS()) {
                if (!existingValue.getSS().contains(toDel)) continue;
                existingValue.getSS().remove(toDel);
            }
        } else if (existingValue.getNS() != null) {
            if (valueToDelete.getValue().getNS() == null) {
                throw new com.amazonaws.services.dynamodb.model.ConditionalCheckFailedException("It's not possible to delete something else than a List<Number> for the attribute (" + attributename + ") of the item with hash key (" + existingValue + ")");
            }
            for (String toDel : valueToDelete.getValue().getNS()) {
                if (!existingValue.getNS().contains(toDel)) continue;
                existingValue.getNS().remove(toDel);
            }
        } else if (existingValue.getS() != null && existingValue.getS().equals(valueToDelete.getValue().getS())) {
            item.remove(attributename);
        } else if (existingValue.getN() != null && existingValue.getN().equals(valueToDelete.getValue().getN())) {
            item.remove(attributename);
        }
    }

    private void validateExpected(Map<String, ExpectedAttributeValue> expected, Map<String, AttributeValue> item) {
        if (expected != null) {
            for (Map.Entry<String, ExpectedAttributeValue> entry : expected.entrySet()) {
                ExpectedAttributeValue value;
                String key = entry.getKey();
                value.setExists(Boolean.valueOf((value = entry.getValue()).getValue() != null));
                if (value.getExists().booleanValue() && item == null || !value.getExists().booleanValue() && item != null) {
                    throw new com.amazonaws.services.dynamodb.model.ConditionalCheckFailedException("The exist conditional could not be met.");
                }
                if (value.getValue() == null || this.compareAttributeValues(value.getValue(), item.get(key))) continue;
                throw new com.amazonaws.services.dynamodb.model.ConditionalCheckFailedException("The value conditional could is not equal");
            }
        }
    }
}

