/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodb.model.InternalServerErrorException;
import com.amazonaws.services.dynamodb.model.transform.AmazonServiceExceptionMarshaller;
import com.michelboudreau.alternator.AlternatorDBHandler;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"/"}, produces={"application/x-amz-json-1.0"})
class AlternatorDBController {
    private ServletContext servletContext;
    private AlternatorDBHandler handler = new AlternatorDBHandler();

    @PostConstruct
    public void init() {
        String persistenceLocation = this.servletContext.getInitParameter("persistence-location");
        if (persistenceLocation != null) {
            this.handler.restore(persistenceLocation);
        }
    }

    @PreDestroy
    public void destroy() {
        String persistenceLocation = this.servletContext.getInitParameter("persistence-location");
        String sandboxStatus = this.servletContext.getInitParameter("sandbox-status");
        if (persistenceLocation != null && sandboxStatus.equals("false")) {
            this.handler.save(persistenceLocation);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/x-amz-json-1.0"})
    public ResponseEntity<String> alternatorDBController(HttpServletRequest request, HttpServletResponse response) {
        try {
            try {
                request.setCharacterEncoding("UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.add("Content-Type", "application/json; charset=utf-8");
            String jsonResult = this.handler.handle(request);
            return new ResponseEntity((Object)jsonResult, (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        catch (AmazonServiceException e) {
            int statusCode = 400;
            if (e instanceof InternalServerErrorException) {
                statusCode = 500;
            }
            ResponseEntity responseEntity = new ResponseEntity((Object)new AmazonServiceExceptionMarshaller().marshall(e), (MultiValueMap)new HttpHeaders(), HttpStatus.valueOf((int)statusCode));
            return responseEntity;
        }
    }

    @Inject
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

