/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.services.dynamodb.AmazonDynamoDB;
import com.amazonaws.services.dynamodb.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodb.model.BatchGetItemResult;
import com.amazonaws.services.dynamodb.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodb.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodb.model.CreateTableRequest;
import com.amazonaws.services.dynamodb.model.CreateTableResult;
import com.amazonaws.services.dynamodb.model.DeleteItemRequest;
import com.amazonaws.services.dynamodb.model.DeleteItemResult;
import com.amazonaws.services.dynamodb.model.DeleteTableRequest;
import com.amazonaws.services.dynamodb.model.DeleteTableResult;
import com.amazonaws.services.dynamodb.model.DescribeTableRequest;
import com.amazonaws.services.dynamodb.model.DescribeTableResult;
import com.amazonaws.services.dynamodb.model.GetItemRequest;
import com.amazonaws.services.dynamodb.model.GetItemResult;
import com.amazonaws.services.dynamodb.model.ListTablesRequest;
import com.amazonaws.services.dynamodb.model.ListTablesResult;
import com.amazonaws.services.dynamodb.model.PutItemRequest;
import com.amazonaws.services.dynamodb.model.PutItemResult;
import com.amazonaws.services.dynamodb.model.QueryRequest;
import com.amazonaws.services.dynamodb.model.QueryResult;
import com.amazonaws.services.dynamodb.model.ScanRequest;
import com.amazonaws.services.dynamodb.model.ScanResult;
import com.amazonaws.services.dynamodb.model.UpdateItemRequest;
import com.amazonaws.services.dynamodb.model.UpdateItemResult;
import com.amazonaws.services.dynamodb.model.UpdateTableRequest;
import com.amazonaws.services.dynamodb.model.UpdateTableResult;
import com.amazonaws.services.dynamodb.model.transform.BatchGetItemRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.BatchGetItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.BatchWriteItemRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.BatchWriteItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.ConditionalCheckFailedExceptionUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.CreateTableRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.CreateTableResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.DeleteItemRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.DeleteItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.DeleteTableRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.DeleteTableResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.DescribeTableRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.DescribeTableResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.GetItemRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.GetItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.ListTablesRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.ListTablesResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.ProvisionedThroughputExceededExceptionUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.PutItemRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.PutItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.QueryRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.QueryResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.ResourceInUseExceptionUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.ScanRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.ScanResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.UpdateItemRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.UpdateItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.UpdateTableRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.UpdateTableResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternatorDBClient
extends AmazonWebServiceClient
implements AmazonDynamoDB {
    private static final Log log = LogFactory.getLog(AlternatorDBClient.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;

    public AlternatorDBClient() {
        this(new ClientConfiguration());
    }

    public AlternatorDBClient(ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, JSONObject>)new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, JSONObject>)new InternalServerErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, JSONObject>)new ProvisionedThroughputExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, JSONObject>)new ResourceInUseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, JSONObject>)new ConditionalCheckFailedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, JSONObject>)new ResourceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, JSONObject>)new JsonErrorUnmarshaller());
        this.setEndpoint("http://localhost:9090/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/dynamodb/request.handlers"));
        this.clientConfiguration = new ClientConfiguration(this.clientConfiguration);
        if (this.clientConfiguration.getRetryPolicy() == ClientConfiguration.DEFAULT_RETRY_POLICY) {
            log.debug((Object)"Overriding default max error retry value to: 10");
            this.clientConfiguration.setMaxErrorRetry(10);
        }
        this.setConfiguration(this.clientConfiguration);
    }

    public ListTablesResult listTables(ListTablesRequest listTablesRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new ListTablesRequestMarshaller().marshall(listTablesRequest);
        ListTablesResultJsonUnmarshaller unmarshaller = new ListTablesResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        ListTablesResult result = (ListTablesResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
        return result;
    }

    public QueryResult query(QueryRequest queryRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new QueryRequestMarshaller().marshall(queryRequest);
        QueryResultJsonUnmarshaller unmarshaller = new QueryResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (QueryResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public BatchWriteItemResult batchWriteItem(BatchWriteItemRequest batchWriteItemRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new BatchWriteItemRequestMarshaller().marshall(batchWriteItemRequest);
        BatchWriteItemResultJsonUnmarshaller unmarshaller = new BatchWriteItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (BatchWriteItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public UpdateItemResult updateItem(UpdateItemRequest updateItemRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new UpdateItemRequestMarshaller().marshall(updateItemRequest);
        UpdateItemResultJsonUnmarshaller unmarshaller = new UpdateItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (UpdateItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public PutItemResult putItem(PutItemRequest putItemRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new PutItemRequestMarshaller().marshall(putItemRequest);
        PutItemResultJsonUnmarshaller unmarshaller = new PutItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (PutItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public DescribeTableResult describeTable(DescribeTableRequest describeTableRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new DescribeTableRequestMarshaller().marshall(describeTableRequest);
        DescribeTableResultJsonUnmarshaller unmarshaller = new DescribeTableResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (DescribeTableResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public ScanResult scan(ScanRequest scanRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new ScanRequestMarshaller().marshall(scanRequest);
        ScanResultJsonUnmarshaller unmarshaller = new ScanResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (ScanResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public CreateTableResult createTable(CreateTableRequest createTableRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new CreateTableRequestMarshaller().marshall(createTableRequest);
        CreateTableResultJsonUnmarshaller unmarshaller = new CreateTableResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (CreateTableResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public UpdateTableResult updateTable(UpdateTableRequest updateTableRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new UpdateTableRequestMarshaller().marshall(updateTableRequest);
        UpdateTableResultJsonUnmarshaller unmarshaller = new UpdateTableResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (UpdateTableResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public DeleteTableResult deleteTable(DeleteTableRequest deleteTableRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new DeleteTableRequestMarshaller().marshall(deleteTableRequest);
        DeleteTableResultJsonUnmarshaller unmarshaller = new DeleteTableResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (DeleteTableResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public DeleteItemResult deleteItem(DeleteItemRequest deleteItemRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new DeleteItemRequestMarshaller().marshall(deleteItemRequest);
        DeleteItemResultJsonUnmarshaller unmarshaller = new DeleteItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (DeleteItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public GetItemResult getItem(GetItemRequest getItemRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new GetItemRequestMarshaller().marshall(getItemRequest);
        GetItemResultJsonUnmarshaller unmarshaller = new GetItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (GetItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public BatchGetItemResult batchGetItem(BatchGetItemRequest batchGetItemRequest) throws AmazonServiceException, AmazonClientException {
        Request request = new BatchGetItemRequestMarshaller().marshall(batchGetItemRequest);
        BatchGetItemResultJsonUnmarshaller unmarshaller = new BatchGetItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (BatchGetItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler);
    }

    public ListTablesResult listTables() throws AmazonServiceException, AmazonClientException {
        return this.listTables(new ListTablesRequest());
    }

    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        super.setEndpoint(endpoint, "dynamodb", null);
    }

    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler) {
        request.setEndpoint(this.endpoint);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        ExecutionContext executionContext = this.createExecutionContext(request);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        Response result = this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
        return (X)result.getAwsResponse();
    }
}

