/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTableResultMarshaller
implements Marshaller<String, CreateTableResult> {
    public String marshall(CreateTableResult createTableResult) {
        if (createTableResult == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            TableDescription table = createTableResult.getTableDescription();
            if (table != null) {
                ProvisionedThroughputDescription provisionedThroughput;
                List keySchema;
                List attributes;
                jsonWriter.key("TableDescription").object();
                if (table.getCreationDateTime() != null) {
                    jsonWriter.key("CreationDateTime").value(table.getCreationDateTime());
                }
                if (table.getTableName() != null) {
                    jsonWriter.key("TableName").value((Object)table.getTableName());
                }
                if (table.getTableStatus() != null) {
                    jsonWriter.key("TableStatus").value((Object)table.getTableStatus());
                }
                if ((attributes = table.getAttributeDefinitions()) != null) {
                    jsonWriter.key("AttributeDefinitions").array();
                    for (AttributeDefinition attr : attributes) {
                        jsonWriter.object();
                        if (attr.getAttributeName() != null) {
                            jsonWriter.key("AttributeName").value((Object)attr.getAttributeName());
                        }
                        if (attr.getAttributeType() != null) {
                            jsonWriter.key("AttributeType").value((Object)attr.getAttributeType());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                if ((keySchema = table.getKeySchema()) != null) {
                    jsonWriter.key("KeySchema").array();
                    for (KeySchemaElement element : keySchema) {
                        jsonWriter.object();
                        if (element.getAttributeName() != null) {
                            jsonWriter.key("AttributeName").value((Object)element.getAttributeName());
                        }
                        if (element.getKeyType() != null) {
                            jsonWriter.key("KeyType").value((Object)element.getKeyType());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                if ((provisionedThroughput = table.getProvisionedThroughput()) != null) {
                    jsonWriter.key("ProvisionedThroughput").object();
                    if (provisionedThroughput.getReadCapacityUnits() != null) {
                        jsonWriter.key("ReadCapacityUnits").value((Object)provisionedThroughput.getReadCapacityUnits());
                    }
                    if (provisionedThroughput.getWriteCapacityUnits() != null) {
                        jsonWriter.key("WriteCapacityUnits").value((Object)provisionedThroughput.getWriteCapacityUnits());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            return stringWriter.toString();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

