/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchWriteItemResultMarshaller
implements Marshaller<String, BatchWriteItemResult> {
    public String marshall(BatchWriteItemResult batchWriteItemResult) {
        if (batchWriteItemResult == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            jsonWriter.key("UnprocessedItems").object();
            Map unprocessedItems = batchWriteItemResult.getUnprocessedItems();
            if (unprocessedItems != null) {
                for (String tableKey : unprocessedItems.keySet()) {
                    jsonWriter.key(tableKey).array();
                    for (WriteRequest request : (List)unprocessedItems.get(tableKey)) {
                        jsonWriter.object();
                        PutRequest putRequest = request.getPutRequest();
                        DeleteRequest deleteRequest = request.getDeleteRequest();
                        if (putRequest != null) {
                            jsonWriter.key("PutRequest").object();
                            Map item = putRequest.getItem();
                            if (item != null) {
                                for (String itemKey : item.keySet()) {
                                    jsonWriter.key(itemKey).object();
                                    AttributeValue value = (AttributeValue)item.get(itemKey);
                                    if (value.getN() != null) {
                                        jsonWriter.key("N").value((Object)value.getN());
                                    } else if (value.getS() != null) {
                                        jsonWriter.key("S").value((Object)value.getS());
                                    } else if (value.getB() != null) {
                                        jsonWriter.key("B").value((Object)value.getS());
                                    } else if (value.getSS() != null) {
                                        jsonWriter.key("SS").value((Object)value.getS());
                                    } else if (value.getNS() != null) {
                                        jsonWriter.key("NS").value((Object)value.getNS());
                                    } else if (value.getBS() != null) {
                                        jsonWriter.key("BS").value((Object)value.getSS());
                                    }
                                    jsonWriter.endObject();
                                }
                            }
                            jsonWriter.endObject();
                        } else if (deleteRequest != null) {
                            jsonWriter.key("DeleteRequest").object();
                            Map keyMap = deleteRequest.getKey();
                            if (keyMap != null) {
                                jsonWriter.key("Key").object();
                                for (String keyName : keyMap.keySet()) {
                                    AttributeValue keyAttrValue = (AttributeValue)keyMap.get(keyName);
                                    jsonWriter.key(keyName).object();
                                    if (keyAttrValue.getN() != null) {
                                        jsonWriter.key("N").value((Object)keyAttrValue.getN());
                                    } else if (keyAttrValue.getS() != null) {
                                        jsonWriter.key("S").value((Object)keyAttrValue.getS());
                                    } else if (keyAttrValue.getB() != null) {
                                        jsonWriter.key("B").value((Object)keyAttrValue.getS());
                                    } else if (keyAttrValue.getSS() != null) {
                                        jsonWriter.key("SS").value((Object)keyAttrValue.getS());
                                    } else if (keyAttrValue.getNS() != null) {
                                        jsonWriter.key("NS").value((Object)keyAttrValue.getNS());
                                    } else if (keyAttrValue.getBS() != null) {
                                        jsonWriter.key("BS").value((Object)keyAttrValue.getSS());
                                    }
                                    jsonWriter.endObject();
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
            }
            jsonWriter.endObject();
            jsonWriter.key("ConsumedCapacity").object();
            List consumedCapacities = batchWriteItemResult.getConsumedCapacity();
            if (consumedCapacities != null) {
                for (ConsumedCapacity consumedCapacity : consumedCapacities) {
                    jsonWriter.key(consumedCapacity.getTableName()).object();
                    Double consumedCapacityUnits = consumedCapacity.getCapacityUnits();
                    if (consumedCapacityUnits != null) {
                        jsonWriter.key("CapacityUnits").value((Object)consumedCapacityUnits);
                    }
                    jsonWriter.endObject();
                }
            }
            jsonWriter.endObject();
            jsonWriter.endObject();
            return stringWriter.toString();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

