/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.ScanResult;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanResultMarshaller
implements Marshaller<String, ScanResult> {
    public String marshall(ScanResult scanResult) {
        if (scanResult == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            jsonWriter.key("Count").value((Object)scanResult.getCount());
            jsonWriter.key("Items").array();
            for (Map item : scanResult.getItems()) {
                jsonWriter.object();
                for (String k : item.keySet()) {
                    if (item.get(k) == null) continue;
                    jsonWriter.key(k).object();
                    if (((AttributeValue)item.get(k)).getS() != null) {
                        jsonWriter.key("S").value((Object)((AttributeValue)item.get(k)).getS());
                    } else if (((AttributeValue)item.get(k)).getN() != null) {
                        jsonWriter.key("N").value((Object)((AttributeValue)item.get(k)).getN());
                    } else if (((AttributeValue)item.get(k)).getSS() != null) {
                        jsonWriter.key("SS").value((Object)((AttributeValue)item.get(k)).getSS());
                    } else if (((AttributeValue)item.get(k)).getNS() != null) {
                        jsonWriter.key("NS").value((Object)((AttributeValue)item.get(k)).getNS());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
            if (scanResult.getLastEvaluatedKey() != null) {
                jsonWriter.key("LastEvaluatedKey").object();
                jsonWriter.key("HashKeyElement").object();
                if (scanResult.getLastEvaluatedKey().getHashKeyElement() != null) {
                    if (scanResult.getLastEvaluatedKey().getHashKeyElement().getS() != null) {
                        jsonWriter.key("S").value((Object)scanResult.getLastEvaluatedKey().getHashKeyElement().getS());
                    } else if (scanResult.getLastEvaluatedKey().getHashKeyElement().getN() != null) {
                        jsonWriter.key("N").value((Object)scanResult.getLastEvaluatedKey().getHashKeyElement().getN());
                    } else if (scanResult.getLastEvaluatedKey().getHashKeyElement().getSS() != null) {
                        jsonWriter.key("SS").value((Object)scanResult.getLastEvaluatedKey().getHashKeyElement().getSS());
                    } else if (scanResult.getLastEvaluatedKey().getHashKeyElement().getNS() != null) {
                        jsonWriter.key("NS").value((Object)scanResult.getLastEvaluatedKey().getHashKeyElement().getNS());
                    }
                }
                jsonWriter.endObject();
                jsonWriter.key("RangeKeyElement").object();
                if (scanResult.getLastEvaluatedKey().getRangeKeyElement() != null) {
                    if (scanResult.getLastEvaluatedKey().getRangeKeyElement().getS() != null) {
                        jsonWriter.key("S").value((Object)scanResult.getLastEvaluatedKey().getRangeKeyElement().getS());
                    } else if (scanResult.getLastEvaluatedKey().getRangeKeyElement().getN() != null) {
                        jsonWriter.key("N").value((Object)scanResult.getLastEvaluatedKey().getRangeKeyElement().getN());
                    } else if (scanResult.getLastEvaluatedKey().getRangeKeyElement().getSS() != null) {
                        jsonWriter.key("SS").value((Object)scanResult.getLastEvaluatedKey().getRangeKeyElement().getSS());
                    } else if (scanResult.getLastEvaluatedKey().getRangeKeyElement().getNS() != null) {
                        jsonWriter.key("NS").value((Object)scanResult.getLastEvaluatedKey().getRangeKeyElement().getNS());
                    }
                }
                jsonWriter.endObject();
                jsonWriter.endObject();
            }
            jsonWriter.key("ConsumedCapacityUnits").value((Object)scanResult.getConsumedCapacityUnits());
            jsonWriter.key("ScannedCount").value((Object)scanResult.getScannedCount());
            jsonWriter.endObject();
            return stringWriter.toString();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

