/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.PutItemResult;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutItemResultMarshaller
implements Marshaller<String, PutItemResult> {
    public String marshall(PutItemResult putItemResult) {
        if (putItemResult == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            Map attr = putItemResult.getAttributes();
            if (attr != null) {
                jsonWriter.key("Attributes").object();
                for (Map.Entry item : attr.entrySet()) {
                    String key = (String)item.getKey();
                    AttributeValue value = (AttributeValue)item.getValue();
                    jsonWriter.key(key).object();
                    if (value.getN() != null) {
                        jsonWriter.key("N").value((Object)value.getN());
                    } else if (value.getS() != null) {
                        jsonWriter.key("S").value((Object)value.getS());
                    } else if (value.getNS() != null) {
                        jsonWriter.key("NS").value((Object)StringUtils.collectionToCommaDelimitedString((Collection)value.getNS()));
                    } else if (value.getSS() != null) {
                        jsonWriter.key("SS").value((Object)StringUtils.collectionToCommaDelimitedString((Collection)value.getSS()));
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (putItemResult.getConsumedCapacityUnits() != null) {
                jsonWriter.key("ConsumedCapacityUnits").value((Object)putItemResult.getConsumedCapacityUnits());
            }
            jsonWriter.endObject();
            return stringWriter.toString();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

