/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodb.model.DescribeTableResult;
import com.amazonaws.services.dynamodb.model.KeySchema;
import com.amazonaws.services.dynamodb.model.KeySchemaElement;
import com.amazonaws.services.dynamodb.model.ProvisionedThroughputDescription;
import com.amazonaws.services.dynamodb.model.TableDescription;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeTableResultMarshaller
implements Marshaller<String, DescribeTableResult> {
    public String marshall(DescribeTableResult describeTableResult) {
        if (describeTableResult == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            TableDescription table = describeTableResult.getTable();
            if (table != null) {
                ProvisionedThroughputDescription provisionedThroughput;
                jsonWriter.key("Table").object();
                jsonWriter.key("ItemCount").value((Object)table.getItemCount());
                jsonWriter.key("TableName").value((Object)table.getTableName());
                jsonWriter.key("TableSizeBytes").value((Object)table.getTableSizeBytes());
                jsonWriter.key("TableStatus").value((Object)table.getTableStatus());
                jsonWriter.key("CreationDateTime").value(table.getCreationDateTime());
                KeySchema keySchema = table.getKeySchema();
                if (keySchema != null) {
                    KeySchemaElement rangeKeyElement;
                    jsonWriter.key("KeySchema").object();
                    KeySchemaElement hashKeyElement = keySchema.getHashKeyElement();
                    if (hashKeyElement != null) {
                        jsonWriter.key("HashKeyElement").object();
                        if (hashKeyElement.getAttributeName() != null) {
                            jsonWriter.key("AttributeName").value((Object)hashKeyElement.getAttributeName());
                        }
                        if (hashKeyElement.getAttributeType() != null) {
                            jsonWriter.key("AttributeType").value((Object)hashKeyElement.getAttributeType());
                        }
                        jsonWriter.endObject();
                    }
                    if ((rangeKeyElement = keySchema.getRangeKeyElement()) != null) {
                        jsonWriter.key("RangeKeyElement").object();
                        if (rangeKeyElement.getAttributeName() != null) {
                            jsonWriter.key("AttributeName").value((Object)rangeKeyElement.getAttributeName());
                        }
                        if (rangeKeyElement.getAttributeType() != null) {
                            jsonWriter.key("AttributeType").value((Object)rangeKeyElement.getAttributeType());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                if ((provisionedThroughput = table.getProvisionedThroughput()) != null) {
                    jsonWriter.key("ProvisionedThroughput").object();
                    if (provisionedThroughput.getReadCapacityUnits() != null) {
                        jsonWriter.key("ReadCapacityUnits").value((Object)provisionedThroughput.getReadCapacityUnits());
                    }
                    if (provisionedThroughput.getWriteCapacityUnits() != null) {
                        jsonWriter.key("WriteCapacityUnits").value((Object)provisionedThroughput.getWriteCapacityUnits());
                    }
                    if (provisionedThroughput.getLastDecreaseDateTime() != null) {
                        jsonWriter.key("LastDecreaseDateTime").value(provisionedThroughput.getLastDecreaseDateTime());
                    }
                    if (provisionedThroughput.getLastIncreaseDateTime() != null) {
                        jsonWriter.key("LastIncreaseDateTime").value(provisionedThroughput.getLastIncreaseDateTime());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            return stringWriter.toString();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

