/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodb.model.BatchWriteResponse;
import com.amazonaws.services.dynamodb.model.DeleteRequest;
import com.amazonaws.services.dynamodb.model.Key;
import com.amazonaws.services.dynamodb.model.PutRequest;
import com.amazonaws.services.dynamodb.model.WriteRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchWriteItemResultMarshaller
implements Marshaller<String, BatchWriteItemResult> {
    public String marshall(BatchWriteItemResult batchWriteItemResult) {
        if (batchWriteItemResult == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            jsonWriter.key("Responses").object();
            Map responses = batchWriteItemResult.getResponses();
            if (responses != null) {
                for (String tableKey : responses.keySet()) {
                    jsonWriter.key(tableKey).object();
                    Double consumedCapacityUnits = ((BatchWriteResponse)responses.get(tableKey)).getConsumedCapacityUnits();
                    if (consumedCapacityUnits != null) {
                        jsonWriter.key("ConsumedCapacityUnits").value((Object)consumedCapacityUnits);
                    }
                    jsonWriter.endObject();
                }
            }
            jsonWriter.endObject();
            jsonWriter.key("UnprocessedItems").object();
            Map unprocessedItems = batchWriteItemResult.getUnprocessedItems();
            if (unprocessedItems != null) {
                for (String tableKey : unprocessedItems.keySet()) {
                    jsonWriter.key(tableKey).array();
                    for (WriteRequest request : (List)unprocessedItems.get(tableKey)) {
                        jsonWriter.object();
                        PutRequest putRequest = request.getPutRequest();
                        DeleteRequest deleteRequest = request.getDeleteRequest();
                        if (putRequest != null) {
                            jsonWriter.key("PutRequest").object();
                            Map item = putRequest.getItem();
                            if (item != null) {
                                for (String itemKey : item.keySet()) {
                                    jsonWriter.key(itemKey).object();
                                    AttributeValue value = (AttributeValue)item.get(itemKey);
                                    if (value.getN() != null) {
                                        jsonWriter.key("N").value((Object)value.getN());
                                    } else if (value.getS() != null) {
                                        jsonWriter.key("S").value((Object)value.getS());
                                    } else if (value.getB() != null) {
                                        jsonWriter.key("B").value((Object)value.getS());
                                    } else if (value.getSS() != null) {
                                        jsonWriter.key("SS").value((Object)value.getS());
                                    } else if (value.getNS() != null) {
                                        jsonWriter.key("NS").value((Object)value.getNS());
                                    } else if (value.getBS() != null) {
                                        jsonWriter.key("BS").value((Object)value.getSS());
                                    }
                                    jsonWriter.endObject();
                                }
                            }
                            jsonWriter.endObject();
                        } else if (deleteRequest != null) {
                            jsonWriter.key("DeleteRequest").object();
                            Key key = deleteRequest.getKey();
                            if (key != null) {
                                jsonWriter.key("Key").object();
                                AttributeValue hashKeyElemenet = key.getHashKeyElement();
                                AttributeValue rangeKeyElement = key.getRangeKeyElement();
                                if (hashKeyElemenet != null) {
                                    if (hashKeyElemenet.getN() != null) {
                                        jsonWriter.key("N").value((Object)hashKeyElemenet.getN());
                                    } else if (hashKeyElemenet.getS() != null) {
                                        jsonWriter.key("S").value((Object)hashKeyElemenet.getS());
                                    } else if (hashKeyElemenet.getB() != null) {
                                        jsonWriter.key("B").value((Object)hashKeyElemenet.getS());
                                    } else if (hashKeyElemenet.getSS() != null) {
                                        jsonWriter.key("SS").value((Object)hashKeyElemenet.getS());
                                    } else if (hashKeyElemenet.getNS() != null) {
                                        jsonWriter.key("NS").value((Object)hashKeyElemenet.getNS());
                                    } else if (hashKeyElemenet.getBS() != null) {
                                        jsonWriter.key("BS").value((Object)hashKeyElemenet.getSS());
                                    }
                                }
                                if (rangeKeyElement != null) {
                                    if (rangeKeyElement.getN() != null) {
                                        jsonWriter.key("N").value((Object)rangeKeyElement.getN());
                                    } else if (rangeKeyElement.getS() != null) {
                                        jsonWriter.key("S").value((Object)rangeKeyElement.getS());
                                    } else if (rangeKeyElement.getB() != null) {
                                        jsonWriter.key("B").value((Object)rangeKeyElement.getS());
                                    } else if (rangeKeyElement.getSS() != null) {
                                        jsonWriter.key("SS").value((Object)rangeKeyElement.getS());
                                    } else if (rangeKeyElement.getNS() != null) {
                                        jsonWriter.key("NS").value((Object)rangeKeyElement.getNS());
                                    } else if (rangeKeyElement.getBS() != null) {
                                        jsonWriter.key("BS").value((Object)rangeKeyElement.getSS());
                                    }
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
            }
            jsonWriter.endObject();
            jsonWriter.endObject();
            return stringWriter.toString();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

