/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator.validators;

import com.amazonaws.services.dynamodb.model.ProvisionedThroughput;
import com.michelboudreau.alternator.models.Limits;
import com.michelboudreau.alternator.validation.Validator;
import com.michelboudreau.alternator.validation.ValidatorUtils;
import java.util.List;

public class ProvisionedThroughputValidator
extends Validator {
    @Override
    public Boolean supports(Class clazz) {
        return ProvisionedThroughput.class.isAssignableFrom(clazz);
    }

    @Override
    public List<Error> validate(Object target) {
        ProvisionedThroughput instance = (ProvisionedThroughput)target;
        List<Error> errors = ValidatorUtils.rejectIfNull(instance);
        if (errors.size() == 0) {
            errors.addAll(ValidatorUtils.rejectIfSizeOutOfBounds(instance.getWriteCapacityUnits(), 1.0, Limits.NUMBER_MAX));
            errors.addAll(ValidatorUtils.rejectIfSizeOutOfBounds(instance.getReadCapacityUnits(), 1.0, Limits.NUMBER_MAX));
        }
        return this.removeNulls(errors);
    }
}

