/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator.validators;

import com.amazonaws.services.dynamodb.model.ListTablesRequest;
import com.michelboudreau.alternator.validation.Validator;
import com.michelboudreau.alternator.validation.ValidatorUtils;
import com.michelboudreau.alternator.validators.TableNameValidator;
import java.util.ArrayList;
import java.util.List;

public class ListTablesRequestValidator
extends Validator {
    @Override
    public Boolean supports(Class clazz) {
        return ListTablesRequest.class.isAssignableFrom(clazz);
    }

    @Override
    public List<Error> validate(Object target) {
        ListTablesRequest instance = (ListTablesRequest)target;
        ArrayList<Error> errors = new ArrayList<Error>();
        if (instance.getExclusiveStartTableName() != null) {
            errors.addAll(ValidatorUtils.invokeValidator(new TableNameValidator(), instance.getExclusiveStartTableName()));
        }
        if (instance.getLimit() != null) {
            errors.addAll(ValidatorUtils.rejectIfSizeOutOfBounds(instance.getLimit(), 1.0, 100.0));
        }
        return this.removeNulls(errors);
    }
}

