/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator.validators;

import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.michelboudreau.alternator.validation.Validator;
import com.michelboudreau.alternator.validation.ValidatorUtils;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class ItemValidator
extends Validator {
    @Override
    public Boolean supports(Class clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    @Override
    public List<Error> validate(Object target) {
        Map instance = (Map)target;
        List<Error> errors = ValidatorUtils.rejectIfNull(instance);
        if (errors.size() == 0) {
            Charset utf = Charset.forName("UTF-8");
            for (Map.Entry entry : instance.entrySet()) {
                String key = (String)entry.getKey();
                AttributeValue value = (AttributeValue)entry.getValue();
                errors.addAll(ValidatorUtils.rejectIfSizeOutOfBounds(key, 1.0, 255.0));
                byte[] bytes = (key + value.toString()).getBytes(utf);
                errors.addAll(ValidatorUtils.rejectIfSizeOutOfBounds(bytes, 0.0, 65536.0));
                errors.addAll(ValidatorUtils.rejectIfNull(value));
            }
        }
        return this.removeNulls(errors);
    }
}

