/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator.validators;

import com.amazonaws.services.dynamodb.model.CreateTableRequest;
import com.michelboudreau.alternator.validation.Validator;
import com.michelboudreau.alternator.validation.ValidatorUtils;
import com.michelboudreau.alternator.validators.KeySchemaValidator;
import com.michelboudreau.alternator.validators.ProvisionedThroughputValidator;
import com.michelboudreau.alternator.validators.TableNameValidator;
import java.util.List;

public class CreateTableRequestValidator
extends Validator {
    @Override
    public Boolean supports(Class clazz) {
        return CreateTableRequest.class.isAssignableFrom(clazz);
    }

    @Override
    public List<Error> validate(Object target) {
        CreateTableRequest instance = (CreateTableRequest)target;
        List<Error> errors = ValidatorUtils.invokeValidator(new TableNameValidator(), instance.getTableName());
        errors.addAll(ValidatorUtils.invokeValidator(new KeySchemaValidator(), instance.getKeySchema()));
        errors.addAll(ValidatorUtils.invokeValidator(new ProvisionedThroughputValidator(), instance.getProvisionedThroughput()));
        return this.removeNulls(errors);
    }
}

