/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator.validators;

import com.amazonaws.services.dynamodb.model.BatchGetItemRequest;
import com.michelboudreau.alternator.validation.Validator;
import com.michelboudreau.alternator.validation.ValidatorUtils;
import com.michelboudreau.alternator.validators.KeysAndAttributesValidator;
import com.michelboudreau.alternator.validators.TableNameValidator;
import java.util.ArrayList;
import java.util.List;

public class BatchGetItemRequestValidator
extends Validator {
    @Override
    public Boolean supports(Class clazz) {
        return BatchGetItemRequest.class.isAssignableFrom(clazz);
    }

    @Override
    public List<Error> validate(Object target) {
        BatchGetItemRequest instance = (BatchGetItemRequest)target;
        ArrayList<Error> errors = new ArrayList<Error>();
        for (String tablename : instance.getRequestItems().keySet()) {
            errors.addAll(ValidatorUtils.invokeValidator(new TableNameValidator(), tablename));
            errors.addAll(ValidatorUtils.invokeValidator(new KeysAndAttributesValidator(), instance.getRequestItems().get(tablename)));
        }
        return this.removeNulls(errors);
    }
}

