/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator.validation;

import com.michelboudreau.alternator.validation.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class ValidatorUtils {
    private static Log logger = LogFactory.getLog(ValidatorUtils.class);

    public static List<Error> invokeValidator(Validator validator, Object obj) {
        Assert.notNull((Object)validator, (String)"Validator must not be null");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Invoking validator [" + validator + "]"));
        }
        if (obj != null && !validator.supports(obj.getClass()).booleanValue()) {
            throw new IllegalArgumentException("Validator [" + validator.getClass() + "] does not support [" + obj.getClass() + "]");
        }
        return validator.validate(obj);
    }

    public static <T> List<Error> rejectIfNull(T property) {
        ArrayList<Error> errors = new ArrayList<Error>();
        if (property == null) {
            errors.add(new Error("property value is null."));
        }
        return errors;
    }

    public static <T> List<Error> rejectIfEmpty(T property) {
        ArrayList<Error> errors = new ArrayList<Error>();
        Boolean empty = false;
        if (property instanceof String) {
            String string = (String)property;
            empty = string.length() == 0;
        } else if (property.getClass().isArray()) {
            Object[] array = (Object[])property;
            empty = array.length == 0;
        } else if (property instanceof Collection) {
            Collection coll = (Collection)property;
            empty = coll.size() == 0;
        } else {
            errors.add(new Error("The property type is not recognized"));
        }
        if (empty.booleanValue()) {
            errors.add(new Error("property value is empty"));
        }
        return errors;
    }

    public static <T> List<Error> rejectIfWhitespace(T property) {
        ArrayList<Error> errors = new ArrayList<Error>();
        Boolean empty = false;
        if (property instanceof String) {
            String string = (String)property;
            empty = (string = string.trim()).length() == 0;
        } else {
            errors.add(new Error("The property type is not recognized"));
        }
        if (empty.booleanValue()) {
            errors.add(new Error("property value is empty"));
        }
        return errors;
    }

    public static <T> List<Error> rejectIfNullOrEmptyOrWhitespace(T property) {
        List<Error> errors = ValidatorUtils.rejectIfNull(property);
        if (errors.size() == 0 && (errors = ValidatorUtils.rejectIfEmpty(property)).size() == 0) {
            errors = ValidatorUtils.rejectIfWhitespace(property);
        }
        return errors;
    }

    public static <T> List<Error> rejectIfNotMatchRegex(T property, String regex) {
        ArrayList<Error> errors = new ArrayList<Error>();
        if (property == null) {
            errors.add(new Error("The property is null"));
            return errors;
        }
        if (property instanceof String) {
            String string = (String)property;
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(string);
            if (!m.matches()) {
                errors.add(new Error("property is out of bounds of regex: " + regex));
            }
        } else {
            errors.add(new Error("The property type is not recognized"));
        }
        return errors;
    }

    public static <T> List<Error> rejectIfSizeOutOfBounds(T property, double min, double max) {
        ArrayList<Error> errors = new ArrayList<Error>();
        if (property == null) {
            errors.add(new Error("The property is null"));
            return errors;
        }
        Boolean outOfBounds = false;
        if (property instanceof String) {
            String string = (String)property;
            outOfBounds = (double)string.length() < min || (double)string.length() > max;
        } else if (property instanceof Number) {
            Double num = ((Number)property).doubleValue();
            outOfBounds = num < min || num > max;
        } else if (property instanceof byte[]) {
            byte[] bytes = (byte[])property;
            outOfBounds = (double)bytes.length < min || (double)bytes.length > max;
        } else if (property.getClass().isArray()) {
            Object[] array = (Object[])property;
            outOfBounds = (double)array.length < min || (double)array.length > max;
        } else if (property instanceof Collection) {
            Collection coll = (Collection)property;
            outOfBounds = (double)coll.size() < min || (double)coll.size() > max;
        } else {
            errors.add(new Error("The property type is not recognized"));
        }
        if (outOfBounds.booleanValue()) {
            errors.add(new Error("property is out of provided bounds."));
        }
        return errors;
    }
}

