/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator.parsers;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.michelboudreau.alternator.enums.RequestType;
import java.io.BufferedReader;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonWebServiceRequestParser {
    private final Logger logger = LoggerFactory.getLogger(AmazonWebServiceRequestParser.class);
    private final JsonFactory jsonFactory = new JsonFactory();
    private HttpServletRequest request;
    private String apiVersion;
    private RequestType type;
    private AmazonWebServiceRequest data;

    public AmazonWebServiceRequestParser(HttpServletRequest request) {
        this.request = request;
    }

    public String getApiVersion() {
        if (this.apiVersion == null) {
            String[] array;
            String str = null;
            String header = this.request.getHeader("x-amz-target");
            if (header != null && (array = header.split("[.]")).length > 0) {
                str = array[0];
            }
            this.apiVersion = str;
        }
        return this.apiVersion;
    }

    public RequestType getType() {
        if (this.type == null) {
            String[] array;
            String str = null;
            String header = this.request.getHeader("x-amz-target");
            if (header != null && (array = header.split("[.]")).length > 1) {
                str = array[1];
            }
            this.type = RequestType.fromString(str);
        }
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends AmazonWebServiceRequest> T getData(Class<T> clazz, Unmarshaller<T, JsonUnmarshallerContext> unmarshaller) {
        ObjectMapper mapper = new ObjectMapper();
        String json = this.getPostString();
        if (json == null) {
            this.logger.warn("Not POST data could be retrieved");
            return null;
        }
        try {
            AmazonWebServiceRequest result;
            JsonParser jsonParser = this.jsonFactory.createJsonParser(json);
            JsonUnmarshallerContext unmarshallerContext = new JsonUnmarshallerContext(jsonParser);
            AmazonWebServiceRequest amazonWebServiceRequest = result = (AmazonWebServiceRequest)unmarshaller.unmarshall((Object)unmarshallerContext);
            return (T)amazonWebServiceRequest;
        }
        catch (Exception e) {
            this.logger.error("Could not read JSON into class: " + e);
            return null;
        }
    }

    protected String getPostString() {
        String json = null;
        if (this.request.getMethod() == "POST") {
            try {
                BufferedReader reader = this.request.getReader();
                StringBuilder sb = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    sb.append(line + "\n");
                    line = reader.readLine();
                }
                reader.close();
                json = sb.toString();
            }
            catch (IOException e) {
                this.logger.warn("Could not retrieve POST data from request");
            }
        }
        return json;
    }
}

