/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator.models;

import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.KeySchema;
import com.amazonaws.services.dynamodb.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodb.model.ProvisionedThroughputDescription;
import com.amazonaws.services.dynamodb.model.TableDescription;
import com.amazonaws.services.dynamodb.model.TableStatus;
import com.michelboudreau.alternator.models.ItemRangeGroup;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Table {
    private String name;
    private KeySchema keySchema;
    private ProvisionedThroughputDescription throughputDescription;
    private Date lastDecreaseDateTime;
    private Date lastIncreaseDateTime;
    private Map<String, ItemRangeGroup> itemRangeGroups = new HashMap<String, ItemRangeGroup>();
    private Date creationDate;
    private String hashKeyName;
    private String rangeKeyName;
    private final TableStatus status = TableStatus.ACTIVE;

    private Table() {
    }

    public Table(String name, KeySchema keySchema, ProvisionedThroughput throughput) {
        this.name = name;
        this.keySchema = keySchema;
        this.setProvisionedThroughput(throughput);
        this.creationDate = new Date();
        this.lastDecreaseDateTime = new Date();
        this.lastIncreaseDateTime = new Date();
        this.hashKeyName = keySchema.getHashKeyElement().getAttributeName();
        if (keySchema.getRangeKeyElement() != null) {
            this.rangeKeyName = keySchema.getRangeKeyElement().getAttributeName();
        }
    }

    public void putItem(Map<String, AttributeValue> item) {
        String hashKeyValue = this.getHashKeyValue(item);
        if (hashKeyValue != null) {
            ItemRangeGroup rangeGroup = this.itemRangeGroups.get(hashKeyValue);
            if (rangeGroup == null) {
                rangeGroup = new ItemRangeGroup();
                this.itemRangeGroups.put(hashKeyValue, rangeGroup);
            }
            String rangeKeyValue = this.getRangeKeyValue(item);
            rangeGroup.putItem(rangeKeyValue, item);
        }
    }

    public void removeItem(String hashKey) {
        this.itemRangeGroups.remove(hashKey);
    }

    public void removeItem(String hashKey, String rangeKey) {
        ItemRangeGroup rangeGroup = this.itemRangeGroups.get(hashKey);
        if (rangeGroup != null) {
            rangeGroup.removeItem(rangeKey);
        }
    }

    public ItemRangeGroup getItemRangeGroup(String hashKey) {
        return this.itemRangeGroups.get(hashKey);
    }

    public Map<String, AttributeValue> getItem(String hashKey, String rangeKey) {
        ItemRangeGroup rangeGroup = this.itemRangeGroups.get(hashKey);
        if (rangeGroup != null) {
            return rangeGroup.getItem(rangeKey);
        }
        return null;
    }

    public Map<String, ItemRangeGroup> getItemRangeGroups() {
        return this.itemRangeGroups;
    }

    public KeySchema getKeySchema() {
        return this.keySchema;
    }

    public String getHashKeyName() {
        return this.hashKeyName;
    }

    public String getRangeKeyName() {
        return this.rangeKeyName;
    }

    public ProvisionedThroughputDescription getProvisionedThroughputDescription() {
        return this.throughputDescription;
    }

    public void setProvisionedThroughput(ProvisionedThroughput throughput) {
        ProvisionedThroughputDescription desc = new ProvisionedThroughputDescription();
        desc.setReadCapacityUnits(throughput.getReadCapacityUnits());
        desc.setWriteCapacityUnits(throughput.getWriteCapacityUnits());
        ProvisionedThroughputDescription oldThroughput = this.getProvisionedThroughputDescription();
        if (oldThroughput != null) {
            if (throughput.getReadCapacityUnits() > oldThroughput.getReadCapacityUnits() || throughput.getWriteCapacityUnits() > oldThroughput.getWriteCapacityUnits()) {
                this.lastIncreaseDateTime = new Date();
            }
            if (throughput.getReadCapacityUnits() > oldThroughput.getReadCapacityUnits() || throughput.getWriteCapacityUnits() > oldThroughput.getWriteCapacityUnits()) {
                this.lastDecreaseDateTime = new Date();
            }
        }
        desc.setLastIncreaseDateTime(this.lastIncreaseDateTime);
        desc.setLastDecreaseDateTime(this.lastDecreaseDateTime);
        this.throughputDescription = desc;
    }

    public Long getItemCount() {
        long count = 0L;
        Collection<ItemRangeGroup> rangeGroups = this.itemRangeGroups.values();
        for (ItemRangeGroup rangeGroup : rangeGroups) {
            count += (long)rangeGroup.size();
        }
        return new Long(count);
    }

    public Long getSizeBytes() {
        return 100L * this.getItemCount();
    }

    public String getName() {
        return this.name;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public TableStatus getStatus() {
        return this.status;
    }

    public Date getLastDecreaseDateTime() {
        return this.lastDecreaseDateTime;
    }

    public Date getLastIncreaseDateTime() {
        return this.lastIncreaseDateTime;
    }

    public TableDescription getTableDescription() {
        TableDescription desc = new TableDescription();
        desc.setTableName(this.getName());
        desc.setTableStatus(this.getStatus());
        desc.setItemCount(this.getItemCount());
        desc.setTableSizeBytes(this.getSizeBytes());
        desc.setCreationDateTime(this.getCreationDate());
        desc.setKeySchema(this.getKeySchema());
        desc.setProvisionedThroughput(this.getProvisionedThroughputDescription());
        return desc;
    }

    protected String getHashKeyValue(Map<String, AttributeValue> item) {
        AttributeValue value = item.get(this.hashKeyName);
        if (value != null) {
            if (value.getN() != null) {
                return value.getN();
            }
            if (value.getS() != null) {
                return value.getS();
            }
        }
        return null;
    }

    protected String getRangeKeyValue(Map<String, AttributeValue> item) {
        AttributeValue value;
        if (this.rangeKeyName != null && (value = item.get(this.rangeKeyName)) != null) {
            if (value.getN() != null) {
                return value.getN();
            }
            if (value.getS() != null) {
                return value.getS();
            }
        }
        return null;
    }
}

