/*
 * Decompiled with CFR 0.152.
 */
package com.michelboudreau.alternator;

import com.michelboudreau.alternator.AlternatorDBConfig;
import java.io.File;
import java.util.EventListener;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class AlternatorDB {
    public static final String PERSISTENCE_LOCATION = "persistence-location";
    public static final String SANDBOX_STATUS = "sandbox-status";
    private final Logger logger = LoggerFactory.getLogger(AlternatorDB.class);
    private Server server;
    private ServletContextHandler context;

    public AlternatorDB() {
        this(9090, null, true);
    }

    public AlternatorDB(int port) {
        this(port, null, true);
    }

    public AlternatorDB(int port, File persistence) {
        this(port, persistence, true);
    }

    public AlternatorDB(int port, File persistence, Boolean sanboxStatus) {
        if (port == 0) {
            port = 9090;
        }
        this.server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setHost("localhost");
        connector.setPort(port);
        this.server.addConnector((Connector)connector);
        this.context = new ServletContextHandler((HandlerContainer)this.server, "/", 1);
        this.context.setContextPath("/");
        this.context.setInitParameter("contextClass", AnnotationConfigWebApplicationContext.class.getName());
        if (persistence != null) {
            this.context.setInitParameter(PERSISTENCE_LOCATION, persistence.getAbsolutePath());
        }
        this.context.setInitParameter(SANDBOX_STATUS, sanboxStatus + "");
        ContextLoaderListener listener = new ContextLoaderListener();
        this.context.addEventListener((EventListener)listener);
        DispatcherServlet servlet = new DispatcherServlet();
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        holder.setInitOrder(1);
        holder.setInitParameter("contextClass", AnnotationConfigWebApplicationContext.class.getName());
        holder.setInitParameter("contextConfigLocation", AlternatorDBConfig.class.getName());
        this.context.addServlet(holder, "/");
    }

    public AlternatorDB start() throws Exception {
        this.server.start();
        return this;
    }

    public AlternatorDB join() throws Exception {
        this.server.join();
        return this;
    }

    public AlternatorDB stop() throws Exception {
        this.server.stop();
        return this;
    }

    public AlternatorDB restart() throws Exception {
        this.stop().start();
        return this;
    }
}

