/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.springframework.util.StringUtils;

public class ScanResultMarshaller
implements Marshaller<String, ScanResult> {
    public String marshall(ScanResult scanResult) {
        if (scanResult == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            jsonWriter.key("Count").value((Object)scanResult.getCount());
            jsonWriter.key("Items").array();
            for (Map item : scanResult.getItems()) {
                jsonWriter.object();
                for (String k : item.keySet()) {
                    if (item.get(k) == null) continue;
                    jsonWriter.key(k).object();
                    if (((AttributeValue)item.get(k)).getS() != null) {
                        jsonWriter.key("S").value((Object)((AttributeValue)item.get(k)).getS());
                    } else if (((AttributeValue)item.get(k)).getN() != null) {
                        jsonWriter.key("N").value((Object)((AttributeValue)item.get(k)).getN());
                    } else if (((AttributeValue)item.get(k)).getSS() != null) {
                        jsonWriter.key("SS").value((Object)((AttributeValue)item.get(k)).getSS());
                    } else if (((AttributeValue)item.get(k)).getNS() != null) {
                        jsonWriter.key("NS").value((Object)((AttributeValue)item.get(k)).getNS());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
            if (scanResult.getLastEvaluatedKey() != null) {
                jsonWriter.key("LastEvaluatedKey").object();
                for (String keyName : scanResult.getLastEvaluatedKey().keySet()) {
                    jsonWriter.key(keyName).object();
                    AttributeValue keyAttrValue = (AttributeValue)scanResult.getLastEvaluatedKey().get(keyName);
                    if (keyAttrValue.getN() != null) {
                        jsonWriter.key("N").value((Object)keyAttrValue.getN());
                    } else if (keyAttrValue.getS() != null) {
                        jsonWriter.key("S").value((Object)keyAttrValue.getS());
                    } else if (keyAttrValue.getNS() != null) {
                        jsonWriter.key("NS").value((Object)StringUtils.collectionToCommaDelimitedString((Collection)keyAttrValue.getNS()));
                    } else if (keyAttrValue.getSS() != null) {
                        jsonWriter.key("SS").value((Object)StringUtils.collectionToCommaDelimitedString((Collection)keyAttrValue.getSS()));
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (scanResult.getConsumedCapacity() != null) {
                jsonWriter.key("ConsumedCapacity").object();
                jsonWriter.key("TableName").value((Object)scanResult.getConsumedCapacity().getTableName());
                jsonWriter.key("CapacityUnits").value((Object)scanResult.getConsumedCapacity().getCapacityUnits());
                jsonWriter.endObject();
            }
            jsonWriter.key("ScannedCount").value((Object)scanResult.getScannedCount());
            jsonWriter.endObject();
            return stringWriter.toString();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

