/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.springframework.util.StringUtils;

public class QueryResultMarshaller
implements Marshaller<String, QueryResult> {
    public String marshall(QueryResult queryResult) {
        if (queryResult == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (queryResult.getConsumedCapacity() != null) {
                jsonWriter.key("ConsumedCapacity").object();
                jsonWriter.key("TableName").value((Object)queryResult.getConsumedCapacity().getTableName());
                jsonWriter.key("CapacityUnits").value((Object)queryResult.getConsumedCapacity().getCapacityUnits());
                jsonWriter.endObject();
            }
            if (queryResult.getCount() != null) {
                jsonWriter.key("Count").value((Object)queryResult.getCount());
            }
            if (queryResult.getItems() != null) {
                jsonWriter.key("Items").array();
                for (Map value : queryResult.getItems()) {
                    jsonWriter.object();
                    for (Map.Entry item : value.entrySet()) {
                        String key = (String)item.getKey();
                        AttributeValue val = (AttributeValue)item.getValue();
                        jsonWriter.key(key).object();
                        if (val.getN() != null) {
                            jsonWriter.key("N").value((Object)val.getN());
                        } else if (val.getS() != null) {
                            jsonWriter.key("S").value((Object)val.getS());
                        } else if (val.getNS() != null) {
                            jsonWriter.key("NS").value((Object)StringUtils.collectionToCommaDelimitedString((Collection)val.getNS()));
                        } else if (val.getSS() != null) {
                            jsonWriter.key("SS").value((Object)StringUtils.collectionToCommaDelimitedString((Collection)val.getSS()));
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (queryResult.getLastEvaluatedKey() != null) {
                jsonWriter.key("LastEvaluatedKey").object();
                for (String keyName : queryResult.getLastEvaluatedKey().keySet()) {
                    jsonWriter.key(keyName).object();
                    AttributeValue keyAttrValue = (AttributeValue)queryResult.getLastEvaluatedKey().get(keyName);
                    if (keyAttrValue.getN() != null) {
                        jsonWriter.key("N").value((Object)keyAttrValue.getN());
                    } else if (keyAttrValue.getS() != null) {
                        jsonWriter.key("S").value((Object)keyAttrValue.getS());
                    } else if (keyAttrValue.getNS() != null) {
                        jsonWriter.key("NS").value((Object)StringUtils.collectionToCommaDelimitedString((Collection)keyAttrValue.getNS()));
                    } else if (keyAttrValue.getSS() != null) {
                        jsonWriter.key("SS").value((Object)StringUtils.collectionToCommaDelimitedString((Collection)keyAttrValue.getSS()));
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            return stringWriter.toString();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

