/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;

public class ListTablesResultMarshaller
implements Marshaller<String, ListTablesResult> {
    public String marshall(ListTablesResult listTablesResult) {
        if (listTablesResult == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (listTablesResult != null) {
                jsonWriter.key("TableNames").array();
                for (String tableName : listTablesResult.getTableNames()) {
                    jsonWriter.value((Object)tableName);
                }
                jsonWriter.endArray();
                if (listTablesResult.getLastEvaluatedTableName() != null) {
                    jsonWriter.key("LastEvaluatedTableName").value((Object)listTablesResult.getLastEvaluatedTableName());
                }
            }
            jsonWriter.endObject();
            return stringWriter.toString();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

