/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.GetItemResult;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;

public class GetItemResultMarshaller
implements Marshaller<String, GetItemResult> {
    public String marshall(GetItemResult getItemResult) {
        if (getItemResult == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (getItemResult.getItem() != null) {
                jsonWriter.key("Item").object();
                for (String key : getItemResult.getItem().keySet()) {
                    AttributeValue value = (AttributeValue)getItemResult.getItem().get(key);
                    if (value == null) continue;
                    jsonWriter.key(key).object();
                    if (value.getN() != null) {
                        jsonWriter.key("N").value((Object)value.getN());
                    } else if (value.getS() != null) {
                        jsonWriter.key("S").value((Object)value.getS());
                    } else if (value.getSS() != null) {
                        jsonWriter.key("SS").value((Object)value.getSS());
                    } else if (value.getNS() != null) {
                        jsonWriter.key("NS").value((Object)value.getNS());
                    } else if (value.getB() != null) {
                        jsonWriter.key("B").value((Object)StringUtils.fromByteBuffer((ByteBuffer)value.getB()));
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.key("ConsumedCapacityUnits").value(0.5);
            jsonWriter.endObject();
            return stringWriter.toString();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

