/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.BatchGetItemResult;
import com.amazonaws.services.dynamodb.model.BatchResponse;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class BatchGetItemResultMarshaller
implements Marshaller<String, BatchGetItemResult> {
    public String marshall(BatchGetItemResult batchGetItemResult) {
        if (batchGetItemResult == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            jsonWriter.key("Responses").object();
            Map responses = batchGetItemResult.getResponses();
            if (responses != null) {
                for (String tableKey : responses.keySet()) {
                    jsonWriter.key(tableKey).object();
                    List items = ((BatchResponse)responses.get(tableKey)).getItems();
                    if (items != null) {
                        jsonWriter.key("Items").array();
                        for (Map item : items) {
                            jsonWriter.object();
                            for (String itemKey : item.keySet()) {
                                jsonWriter.key(itemKey).object();
                                AttributeValue value = (AttributeValue)item.get(itemKey);
                                if (value.getN() != null) {
                                    jsonWriter.key("N").value((Object)value.getN());
                                } else if (value.getS() != null) {
                                    jsonWriter.key("S").value((Object)value.getS());
                                } else if (value.getNS() != null) {
                                    jsonWriter.key("NS").value((Object)value.getNS());
                                } else if (value.getSS() != null) {
                                    jsonWriter.key("SS").value((Object)value.getSS());
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                        jsonWriter.key("ConsumedCapacityUnits").value(1L);
                    }
                    jsonWriter.endObject();
                }
            }
            jsonWriter.endObject();
            jsonWriter.key("UnprocessedKeys").object();
            Map unprocessedKeys = batchGetItemResult.getUnprocessedKeys();
            if (unprocessedKeys != null) {
                for (String tableKey : unprocessedKeys.keySet()) {
                    jsonWriter.key(tableKey).array();
                    jsonWriter.endArray();
                }
            }
            jsonWriter.endObject();
            jsonWriter.endObject();
            return stringWriter.toString();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

