/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.*;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.search.PaginationUI;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.MaskFormatter;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class OfferListUI extends javax.swing.JSplitPane implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADVANCED_SEARCH_COLLAPSED = "advancedSearchCollapsed";
    public static final String PROPERTY_OFFER_LIST_COLUMN_FACTORY = "offerListColumnFactory";
    public static final String PROPERTY_OFFER_LIST_TABLE_MODEL = "offerListTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.OfferListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Boolean advancedSearchCollapsed;
    protected javax.swing.JTabbedPane editTabs;
    protected javax.swing.JButton exportButton;
    protected com.jurismarches.vradi.ui.offer.OfferTable listTable;
    protected OfferListUI offerList = this;
    protected com.jurismarches.vradi.ui.offer.OfferListColumnFactory offerListColumnFactory;
    protected com.jurismarches.vradi.ui.offer.models.OfferListTableModel offerListTableModel;
    protected javax.swing.JPanel paginationPanel;
    protected com.jurismarches.vradi.ui.search.PaginationUI paginationUI;
    protected javax.swing.JPanel searchPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected SearchUI searchUI;
    
    
    public OfferListHandler getHandler() {
        return getContextValue(OfferListHandler.class);
    }
    
    public SearchHandler getSearchHandler() {
        return getContextValue(SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public void setSearchUI(SearchUI searchUI) {
        this.searchUI = searchUI;
        searchPanel.add(searchUI, BorderLayout.CENTER);
    }
    
    public SearchUI getSearchUI() {
        return searchUI;
    }
    
    void $afterCompleteSetup() {
        final JTableHeader header = listTable.getTableHeader();
        header.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == MouseEvent.BUTTON1) {
                    // Get column selected
                    TableColumnModel columnModel = ((JTableHeader)e.getSource()).getColumnModel();
                    int columnIndex = columnModel.getColumnIndexAtX(e.getX());
                    TableColumn column = columnModel.getColumn(columnIndex);
    
                    final String fqName = offerListTableModel.getColumnFqName(columnIndex);
                    offerListTableModel.setAscending(!offerListTableModel.isAscending());
                    offerListTableModel.setFieldToSort(fqName);
                } 
            }
        });
    
        OfferListTableModel.OfferListTableModelBinding djb = new OfferListTableModel.OfferListTableModelBinding(this,
                "offerListTableModel", offerListTableModel) {
           @Override
            public void processDataBinding() {
                if (offerListTableModel != null) {
                    getSearchHandler().executeQuery(searchUI);
                }
            }
        };
      
        registerDataBinding(djb);
        djb.applyDataBinding();
    
        validate();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public OfferListUI() {
        $initialize();
    }

    public OfferListUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__exportButton(java.awt.event.ActionEvent event) {
        getSearchHandler().exportToCSV(offerListTableModel);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Boolean getAdvancedSearchCollapsed() {
        return advancedSearchCollapsed;
    }

    public javax.swing.JTabbedPane getEditTabs() {
        return editTabs;
    }

    public javax.swing.JButton getExportButton() {
        return exportButton;
    }

    public com.jurismarches.vradi.ui.offer.OfferTable getListTable() {
        return listTable;
    }

    public com.jurismarches.vradi.ui.offer.OfferListColumnFactory getOfferListColumnFactory() {
        return offerListColumnFactory;
    }

    public com.jurismarches.vradi.ui.offer.models.OfferListTableModel getOfferListTableModel() {
        return offerListTableModel;
    }

    public javax.swing.JPanel getPaginationPanel() {
        return paginationPanel;
    }

    public com.jurismarches.vradi.ui.search.PaginationUI getPaginationUI() {
        return paginationUI;
    }

    public javax.swing.JPanel getSearchPanel() {
        return searchPanel;
    }

    public java.lang.Boolean isAdvancedSearchCollapsed() {
        return advancedSearchCollapsed !=null && advancedSearchCollapsed;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAdvancedSearchCollapsed(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.advancedSearchCollapsed;
        this.advancedSearchCollapsed = newValue;
        firePropertyChange(PROPERTY_ADVANCED_SEARCH_COLLAPSED, oldValue, newValue);
    }

    public void setOfferListColumnFactory(com.jurismarches.vradi.ui.offer.OfferListColumnFactory newValue) {
        com.jurismarches.vradi.ui.offer.OfferListColumnFactory oldValue = this.offerListColumnFactory;
        this.offerListColumnFactory = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_COLUMN_FACTORY, oldValue, newValue);
    }

    public void setOfferListTableModel(com.jurismarches.vradi.ui.offer.models.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.offer.models.OfferListTableModel oldValue = this.offerListTableModel;
        this.offerListTableModel = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_TABLE_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToOfferList() {
        if (!allComponentsCreated) {
            return;
        }
        add($JPanel0, JSplitPane.LEFT);
        add(editTabs, JSplitPane.RIGHT);
    }

    protected void addChildrenToPaginationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        paginationPanel.add(paginationUI, BorderLayout.NORTH);
        paginationPanel.add(exportButton, BorderLayout.SOUTH);
    }

    protected void createAdvancedSearchCollapsed() {
        $objectMap.put("advancedSearchCollapsed", advancedSearchCollapsed = false);
    }

    protected void createEditTabs() {
        $objectMap.put("editTabs", editTabs = new javax.swing.JTabbedPane());
        
        editTabs.setName("editTabs");
    }

    protected void createExportButton() {
        $objectMap.put("exportButton", exportButton = new javax.swing.JButton());
        
        exportButton.setName("exportButton");
        exportButton.setText(_("vradi.export.cvs"));
        exportButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__exportButton"));
    }

    protected void createListTable() {
        $objectMap.put("listTable", listTable = new com.jurismarches.vradi.ui.offer.OfferTable());
        
        listTable.setName("listTable");
    }

    protected void createOfferListColumnFactory() {
        $objectMap.put("offerListColumnFactory", offerListColumnFactory = getContextValue(OfferListColumnFactory.class));
    }

    protected void createOfferListTableModel() {
        $objectMap.put("offerListTableModel", offerListTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createPaginationPanel() {
        $objectMap.put("paginationPanel", paginationPanel = new javax.swing.JPanel());
        
        paginationPanel.setName("paginationPanel");
        paginationPanel.setLayout(new BorderLayout());
    }

    protected void createPaginationUI() {
        $objectMap.put("paginationUI", paginationUI = new com.jurismarches.vradi.ui.search.PaginationUI(this));
        
        paginationUI.setName("paginationUI");
    }

    protected void createSearchPanel() {
        $objectMap.put("searchPanel", searchPanel = new javax.swing.JPanel());
        
        searchPanel.setName("searchPanel");
        searchPanel.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToOfferList();
        // inline complete setup of $JPanel0
        $JPanel0.add(searchPanel, BorderLayout.NORTH);
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        $JPanel0.add(paginationPanel, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(listTable);
        addChildrenToPaginationPanel();
        
        // apply 16 property setters
        setDividerLocation(Integer.MAX_VALUE);
        setDividerSize(0);
        setOrientation(JSplitPane.VERTICAL_SPLIT);
        setResizeWeight(1);
        offerListTableModel.setNbFormsPerPage(10);
        offerListTableModel.setPageToShow(1);
        listTable.setAutoResizeMode(2);
        listTable.setColumnControlVisible(true);
        listTable.setColumnFactory(offerListColumnFactory);
        listTable.setGridColor(Color.GRAY);
        listTable.setHorizontalScrollEnabled(true);
        listTable.setModel(offerListTableModel);
        listTable.setShowGrid(true);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("offerList", this);
        createOfferListColumnFactory();
        createOfferListTableModel();
        createAdvancedSearchCollapsed();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createSearchPanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createListTable();
        createPaginationPanel();
        createPaginationUI();
        createExportButton();
        createEditTabs();
        // inline creation of offerList
        setName("offerList");
        setOneTouchExpandable(true);
        setContinuousLayout(true);
        
        $completeSetup();
    }

}