/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;
import com.jurismarches.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.widget.GroupListSelectorHandler;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.renderers.EntityRenderer;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminUserUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<User> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_IN_GROUP = "inGroup";
    public static final String PROPERTY_USER_GROUPS_HANDLER = "userGroupsHandler";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CREATE_BUTTON_VISIBLE = "createButton.visible";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_USER_ADDRESS_TEXT = "userAddress.text";
    public static final String BINDING_USER_BEGIN_SEARCH_DATE_DATE = "userBeginSearchDate.date";
    public static final String BINDING_USER_EMAIL_TEXT = "userEmail.text";
    public static final String BINDING_USER_ENABLE_SELECTED = "userEnable.selected";
    public static final String BINDING_USER_GROUPS_VISIBLE = "userGroups.visible";
    public static final String BINDING_USER_NAME_TEXT = "userName.text";
    public static final String BINDING_USER_PHONE_TEXT = "userPhone.text";
    public static final String BINDING_USER_SERVICE_TEXT = "userService.text";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JLABEL7_VISIBLE = "$JLabel7.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminUserUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table adminUserForm;
    protected com.jurismarches.vradi.entities.User bean;
    protected javax.swing.JButton createButton;
    protected java.lang.Boolean inGroup;
    protected javax.swing.JLabel title;
    protected javax.swing.JTextField userAddress;
    protected org.jdesktop.swingx.JXDatePicker userBeginSearchDate;
    protected javax.swing.JTextField userEmail;
    protected javax.swing.JCheckBox userEnable;
    protected jaxx.runtime.swing.ListSelectorUI< Group > userGroups;
    protected com.jurismarches.vradi.ui.admin.widget.GroupListSelectorHandler userGroupsHandler;
    protected javax.swing.JTextField userName;
    protected javax.swing.JTextField userPhone;
    protected javax.swing.JTextField userService;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.User > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminUserUI $AdminContentUI0 = this;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JButton $JButton1;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JPanel $JPanel2;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel7;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
    
        AutoCompleteDecorator.decorate(userGroups.getCombo(), EntityRenderer.getInstance());
    
        userGroups.addPropertyChangeListener("modified", new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from groups");
                    setModified(true);
                }
            }
        });
        errorTable.registerValidator(validator);
    
        userGroupsHandler = new GroupListSelectorHandler(userGroups);
        userGroups.setHandler(userGroupsHandler);
    }
    
    @Override
    protected void postLoadBean() {
        VradiTreeNode parentNode = getHelper().getParentCategoryNode(getHelper().getSelectedNode(), AdminBeanConstant.GROUP.getCategoryName());
        setInGroup(parentNode != null);
    
        createButton.setEnabled(!isInCreation());
    
        userGroupsHandler.setBean(bean);
        if (bean == null) {
            // Clear all user
            userGroups.init(Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    
            return;
        }
    
        java.util.List<Group> toCombo = getHandler().getAllGroups();
    
        java.util.List<Group> toList = new ArrayList<Group>();
        try {
            toList = VradiService.getVradiDataService().getGroupsForUser(bean.getWikittyId());
        } catch (VradiException eee){
            log.error("Could not retrieve groups for user : " + bean.getName(),
                    eee);
        }
        
        toCombo.removeAll(toList);
    
        userGroups.init(toCombo, toList);
        userGroupsHandler.setBean(bean);
    }
    
    @Override
    public void save() {
    
        // groups to save
        Map<String, Group> groups = new HashMap<String, Group>();
    
        if (log.isDebugEnabled()){
            log.debug("Will save user " + bean.getName());
        }
    
        String wikittyId = bean.getWikittyId();
    
        // FIXME EC20100628 move this code to handler
        //Remove the groups that were remove from the list.
        for (Group g : userGroups.getComboDatas()) {
        
            if (g != null && g.getUser() != null && g.getUser().contains(wikittyId)) {
    
                if (log.isDebugEnabled()){
                    log.debug("Removing user " + bean.getName() + " from group " + g.getName());
                }
    
                // group was containing user, but no more
                g.removeUser(wikittyId);
                
                // mark it for save
                groups.put(g.getWikittyId(), g);
            }
        }
    
        //Add groups that have been added to the list
        for (Group g : userGroups.getListDatas()) {
    
            if (g != null) {
    
                if (log.isDebugEnabled()){
                    log.debug("Adding user " + bean.getName() + " to group " +g.getName());
                }
    
                g.addUser(wikittyId);
                //mark group for save
                groups.put(g.getWikittyId(), g);
            }
    
        }
    
        //Effectively save bean
        User user = getHandler().saveUser(this, getHelper(), bean, groups.values());
    
        AdminNavigationTreeHelper helper = getHelper();
        VradiTreeNode userNode = helper.findNode(helper.getRootNode(), user.getWikittyId());
        helper.refresh(userNode);
    
        //FIXME JC 25/08/2010 bean is the same (because of cache ?) so no property change fired. Set bean to null before to force fire.
        setModified(false);
        setBean(null);
        setBean(user);
    
        userGroups.setModified(false);
    }
    
    @Override
    protected void clearUI() {
        title.setText(updateTitle(""));
        userName.setText("");
        userService.setText("");
        userAddress.setText("");
        userPhone.setText("");
        userEmail.setText("");
        userBeginSearchDate.setDate(null);
        userEnable.setSelected(false);
    }
    
    protected String updateTitle(String name) {
       return _("vradi.adminUser.title", getStringValue(name));
    }
    
    protected void openAddressInBrowser() {
        UIHelper.openAddressInBrowser(getBean().getAddress());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminUserUI() {
        super();
        $initialize();
    }

    public AdminUserUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.User > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        openAddressInBrowser();
    }

    public void doActionPerformed__on__createButton(java.awt.event.ActionEvent event) {
        getHandler().createUser(this, getHelper().getClientSelected());setModified(true);
    }

    public void doActionPerformed__on__userBeginSearchDate(java.awt.event.ActionEvent event) {
        getBean().setBeginSearchDate(userBeginSearchDate.getDate());
    }

    public void doActionPerformed__on__userEnable(java.awt.event.ActionEvent event) {
        getBean().setEnable(userEnable.isSelected());
    }

    public void doKeyReleased__on__userAddress(java.awt.event.KeyEvent event) {
        getBean().setAddress(userAddress.getText());
    }

    public void doKeyReleased__on__userEmail(java.awt.event.KeyEvent event) {
        getBean().setEmail(userEmail.getText());
    }

    public void doKeyReleased__on__userName(java.awt.event.KeyEvent event) {
        getBean().setName(userName.getText());                                                title.setText(updateTitle(getBean().getName()));
    }

    public void doKeyReleased__on__userPhone(java.awt.event.KeyEvent event) {
        getBean().setPhone(userPhone.getText());
    }

    public void doKeyReleased__on__userService(java.awt.event.KeyEvent event) {
        getBean().setService(userService.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminUserForm() {
        return adminUserForm;
    }

    public com.jurismarches.vradi.entities.User getBean() {
        return bean;
    }

    public javax.swing.JButton getCreateButton() {
        return createButton;
    }

    public java.lang.Boolean getInGroup() {
        return inGroup;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    public javax.swing.JTextField getUserAddress() {
        return userAddress;
    }

    public org.jdesktop.swingx.JXDatePicker getUserBeginSearchDate() {
        return userBeginSearchDate;
    }

    public javax.swing.JTextField getUserEmail() {
        return userEmail;
    }

    public javax.swing.JCheckBox getUserEnable() {
        return userEnable;
    }

    public jaxx.runtime.swing.ListSelectorUI< Group > getUserGroups() {
        return userGroups;
    }

    public com.jurismarches.vradi.ui.admin.widget.GroupListSelectorHandler getUserGroupsHandler() {
        return userGroupsHandler;
    }

    public javax.swing.JTextField getUserName() {
        return userName;
    }

    public javax.swing.JTextField getUserPhone() {
        return userPhone;
    }

    public javax.swing.JTextField getUserService() {
        return userService;
    }

    public java.lang.Boolean isInGroup() {
        return inGroup !=null && inGroup;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.User newValue) {
        com.jurismarches.vradi.entities.User oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setInGroup(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.inGroup;
        this.inGroup = newValue;
        firePropertyChange(PROPERTY_IN_GROUP, oldValue, newValue);
    }

    public void setUserGroupsHandler(com.jurismarches.vradi.ui.admin.widget.GroupListSelectorHandler newValue) {
        com.jurismarches.vradi.ui.admin.widget.GroupListSelectorHandler oldValue = this.userGroupsHandler;
        this.userGroupsHandler = newValue;
        firePropertyChange(PROPERTY_USER_GROUPS_HANDLER, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("email", userEmail);
        validator.setFieldRepresentation("name", userName);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminUserForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminUserForm.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(SwingUtil.boxComponentWithJxLayer(userName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userService, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userAddress, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JButton1, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userPhone, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(SwingUtil.boxComponentWithJxLayer(userEmail), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel5, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userBeginSearchDate, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel6, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JPanel1, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminUserForm, BorderLayout.NORTH);
        body.add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
    }

    protected void createAdminUserForm() {
        $objectMap.put("adminUserForm", adminUserForm = new jaxx.runtime.swing.Table());
        
        adminUserForm.setName("adminUserForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCreateButton() {
        $objectMap.put("createButton", createButton = new javax.swing.JButton());
        
        createButton.setName("createButton");
        createButton.setText(_("vradi.adminUser.createUser"));
        createButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createButton"));
    }

    protected void createInGroup() {
        $objectMap.put("inGroup", inGroup = false);
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createUserAddress() {
        $objectMap.put("userAddress", userAddress = new javax.swing.JTextField());
        
        userAddress.setName("userAddress");
        userAddress.setColumns(15);
        userAddress.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userAddress"));
    }

    protected void createUserBeginSearchDate() {
        $objectMap.put("userBeginSearchDate", userBeginSearchDate = new org.jdesktop.swingx.JXDatePicker());
        
        userBeginSearchDate.setName("userBeginSearchDate");
        userBeginSearchDate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__userBeginSearchDate"));
    }

    protected void createUserEmail() {
        $objectMap.put("userEmail", userEmail = new javax.swing.JTextField());
        
        userEmail.setName("userEmail");
        userEmail.setColumns(15);
        userEmail.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userEmail"));
    }

    protected void createUserEnable() {
        $objectMap.put("userEnable", userEnable = new javax.swing.JCheckBox());
        
        userEnable.setName("userEnable");
        userEnable.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__userEnable"));
    }

    protected void createUserGroups() {
        $objectMap.put("userGroups", userGroups = new jaxx.runtime.swing.ListSelectorUI< Group >());
        
        userGroups.setName("userGroups");
        userGroups.setShowHidor(false);
        ((javax.swing.JToolBar) userGroups.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) userGroups.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createUserGroupsHandler() {
        $objectMap.put("userGroupsHandler", userGroupsHandler = null);
    }

    protected void createUserName() {
        $objectMap.put("userName", userName = new javax.swing.JTextField());
        
        userName.setName("userName");
        userName.setColumns(15);
        userName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userName"));
    }

    protected void createUserPhone() {
        $objectMap.put("userPhone", userPhone = new javax.swing.JTextField());
        
        userPhone.setName("userPhone");
        userPhone.setColumns(15);
        userPhone.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userPhone"));
    }

    protected void createUserService() {
        $objectMap.put("userService", userService = new javax.swing.JTextField());
        
        userService.setName("userService");
        userService.setColumns(15);
        userService.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userService"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.User >(com.jurismarches.vradi.entities.User.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createButton);
        $JPanel0.add($JButton0);
        addChildrenToBody();
        addChildrenToAdminUserForm();
        // inline complete setup of $JPanel1
        $JPanel1.add(userEnable, BorderLayout.WEST);
        $JPanel1.add($JPanel2, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add($JLabel7, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(userGroups, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 15 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        adminUserForm.setMinimumSize(SwingUtil.newMinDimension());
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("site"));
        userGroups.setAddToComboTip(_("vradi.adminUser.removeGroup"));
        userGroups.setAddToListTip(_("vradi.adminUser.addGroup"));
        userGroups.setHandler(userGroupsHandler);
        userGroups.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$AdminContentUI0", this);
        createBean();
        createInGroup();
        createValidator();
        createUserGroupsHandler();
        createTitle();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateButton();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminUser.deleteUser"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createAdminUserForm();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminUser.name"));
        createUserName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminUser.service"));
        createUserService();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminUser.adresse"));
        createUserAddress();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminUser.phone"));
        createUserPhone();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("vradi.adminUser.mail"));
        createUserEmail();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new javax.swing.JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("vradi.adminUser.beginSearchDate"));
        createUserBeginSearchDate();
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new javax.swing.JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("vradi.admin.userEnable"));
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createUserEnable();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new javax.swing.JPanel());
        
        $JPanel2.setName("$JPanel2");
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new javax.swing.JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("vradi.adminClient.listGroup"));
        createUserGroups();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((jaxx.runtime.swing.Table) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        // registers 15 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 15 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    title.setText(_(updateTitle(getBean().getName())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_BUTTON_VISIBLE, true ,"inGroup" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                createButton.setVisible(!isInGroup() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(userName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_SERVICE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(userService, getBean().getService());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_ADDRESS_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(userAddress, getBean().getAddress());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_PHONE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(userPhone, getBean().getPhone());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_EMAIL_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(userEmail, getBean().getEmail());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_BEGIN_SEARCH_DATE_DATE, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    userBeginSearchDate.setDate(getBean().getBeginSearchDate());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_ENABLE_SELECTED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    userEnable.setSelected(getBean().getEnable());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL7_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JLabel7.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_GROUPS_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                userGroups.setVisible(!isInGroup());
            }
        });
    }

}