/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: RootThesaurusNodeLoadors.java 1747 2010-11-09 15:22:49Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.4.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/thesaurus/loadors/RootThesaurusNodeLoadors.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.thesaurus.loadors;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import com.sun.star.uno.RuntimeException;

import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * @author letellier
 */
public class RootThesaurusNodeLoadors extends NavTreeNodeChildLoador<String, RootThesaurus, VradiTreeNode> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** Logger */
    static private final Log log =
            LogFactory.getLog(RootThesaurusNodeLoadors.class);

    public RootThesaurusNodeLoadors() {
        super(RootThesaurus.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) {

        // ne recupere pas seulement les id pour les mettre en cache
        List<RootThesaurus> rootThesaurusList = null;
        try {
            rootThesaurusList = VradiService.getVradiDataService().getRootThesaurus();
        } catch (VradiException ex) {
            throw new RuntimeException("Can't get root thesaurus list", ex);
        }

        // Return children
        return extractIds(rootThesaurusList);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {

        if (log.isDebugEnabled()) {
            log.debug("[Root loador] creating thesaurus " + id);
        }

        return new VradiTreeNode(
                    getBeanType(),
                    id,
                    null,
                    NavHelper.getChildLoador(ThesaurusNodeLoadors.class));
    }

    protected List<String> extractIds(List<RootThesaurus> entities) {
        List<String> ids = new ArrayList<String>();
        for (RootThesaurus e : entities) {
            ids.add(e.getWikittyId());
        }
        return ids;
    }
}