/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: TextEditorModel.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.4.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/offer/editors/TextEditorModel.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.editors;

import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.UnsupportedEncodingException;

/**
 * @author morin
 *         Date: 26 nov. 2009
 *         Time: 19:05:06
 */
public class TextEditorModel extends VradiEditorModel<String> {

    private static final long serialVersionUID = 1L;

    private static Log log = LogFactory.getLog(TextEditorModel.class);

    public void removeEndLine() {
        String text = getValue();
        if (text == null) {
            return;
        }
        setValue(text.replace('\n', ' '));
    }

    public void convertToIso() {
        String text = getValue();
        if (text == null) {
            return;
        }
        text = convertTo(text, "ISO-8859-1");
        setValue(text);
    }

    public void convertToUtf() {
        String text = getValue();
        if (text == null) {
            return;
        }
        try {
            text = new String(text.getBytes("ISO-8859-1"), "UTF-8");
        } catch (UnsupportedEncodingException eee) {
            log.error("Cant convert '" + text + "' to UTF8", eee);
            ErrorDialogUI.showError(eee);
        }
        setValue(text);                                              
    }

    public void removeXML() {
        String text = getValue();
        if (text == null) {
            return;
        }
        text = text.replaceAll("<[^>]+>", "");
        setValue(text);
    }

    public void unescapeXML() {
        String text = getValue();
        if (text == null) {
            return;
        }
        text = StringEscapeUtils.unescapeHtml(text);
        setValue(text);
    }

    protected String convertTo(String text, String encoding) {
        try {
            text = new String (text.getBytes(), encoding);
        } catch (UnsupportedEncodingException eee) {
            log.error("Cant convert '" + text + "' to " + encoding, eee);
            ErrorDialogUI.showError(eee);
        }
        return text;
    }
}