/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: EmailGroupUsersNodeLoadors.java 1785 2010-11-16 09:27:38Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.4.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/email/loadors/EmailGroupUsersNodeLoadors.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email.loadors;

import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.loadors.GroupUsersNodeLoadors;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.wikitty.WikittyProxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class EmailGroupUsersNodeLoadors extends AbstractEmailNodeLoador<User>{

    /** serialVersionUID. */
    private static final long serialVersionUID = 6834221183179682758L;

    protected String sessionId;
    
    public EmailGroupUsersNodeLoadors() {
        super(User.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {

        if (parentId == null) {
            return null;
        }

        WikittyProxy proxy = getProxy(dataProvider);

        // Restore parent
        Group group = proxy.restore(Group.class, parentId);

        List<User> users = null;
        Set<String> groupUserIds = group.getUser();
        if (CollectionUtils.isNotEmpty(groupUserIds)) {
            List<String> usersIds = new ArrayList<String>();

            // Get sending for session
            List<Sending> sendings = getSendingList(dataProvider, sessionId);
            for (Sending sending : sendings) {
                if (sending != null) {
                    if (groupUserIds != null) {
                        String sendingUserId = sending.getUser();

                        // If user is concerned
                        if (groupUserIds.contains(sendingUserId)) {
                            usersIds.add(sendingUserId);
                        }
                    }
                }
            }

            // Sort
            users = VradiService.getWikittyProxy().restore(User.class, usersIds);
            Collections.sort(users, VradiComparators.USER_COMPARATOR);
        }

        // Return users of group
        return extractIds(users);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {
        return createVradiNode(id);
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }
}
