/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: GroupEmailEntityModel.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://tchemit@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3/vradi-swing/src/main/java/com/jurismarches/vradi/ui/email/models/GroupEmailEntityModel.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email.models;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.ui.email.helpers.EmailDataHelper;
import com.jurismarches.vradi.ui.email.renderers.EmailFormsListCellRenderer;

import java.util.Collections;

/**
 * @author letellier
 */
public class GroupEmailEntityModel extends EmailEntityModel<Group> {

    public GroupEmailEntityModel(EmailFormsListCellRenderer renderer, Session session, Form form) {
        super(renderer, session, form);
    }

    @Override
    public void updateModel(Session session, Form form) {
        java.util.List<Group> groupSending = EmailDataHelper.getGroupsSendingConcernedBy(session, form.getWikittyId());
        updateDatas(groupSending);
    }
}
