/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.login;

import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.login.LoginUI;
import com.jurismarches.vradi.ui.login.RegisterUI;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;

public class LoginHandler {
    private static final Log log = LogFactory.getLog(LoginHandler.class);
    private static final String EMPTY_PASSWORD = "null";

    public VradiStorageService getVradiStorageService() {
        return VradiService.getVradiStorageService();
    }

    public void logUser(LoginUI ui) {
        try {
            String login = ui.getLogin().getText().trim();
            String password = String.valueOf(ui.getPassword().getPassword()).trim();
            String md5Password = password.isEmpty() ? EMPTY_PASSWORD : StringUtil.encodeMD5((String)password);
            VradiUser user = this.getVradiStorageService().loginUser(login, md5Password);
            if (user != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Login failed for user " + login));
                }
                ui.setBean(user);
            } else {
                JOptionPane.showMessageDialog(ui, I18n._("vradi.login.error.message"), I18n._("vradi.login.error"), 0);
                ui.getLogin().grabFocus();
            }
        }
        catch (VradiException eee) {
            JOptionPane.showMessageDialog(ui, I18n._("vradi.login.error.message"), I18n._("vradi.login.error"), 0);
        }
    }

    public void register(LoginUI ui) {
        RegisterUI regUI = new RegisterUI((JAXXContext)ui);
        regUI.setLocationRelativeTo(ui);
        regUI.setVisible(true);
    }

    public void register(RegisterUI ui) {
        try {
            String beanPassword = ui.getBean().getPassword();
            String repeatPassword = String.valueOf(ui.getRepeatPassword().getPassword());
            if (beanPassword != null && beanPassword.equals(repeatPassword)) {
                if (beanPassword.isEmpty()) {
                    ui.getBean().setPassword(EMPTY_PASSWORD);
                } else {
                    ui.getBean().setPassword(StringUtil.encodeMD5((String)beanPassword.trim()));
                }
                VradiUser result = ui.getBean();
                result = this.getVradiStorageService().createUser(result);
                if (result == null) {
                    JOptionPane.showMessageDialog(ui, I18n._("vradi.register.user.error.message"), I18n._("vradi.register.user.error"), 0);
                    ui.getLogin().grabFocus();
                    ui.getLogin().setBorder(BorderFactory.createLineBorder(Color.RED, 3));
                } else {
                    JOptionPane.showMessageDialog(ui, I18n._("vradi.register.ok.message"), I18n._("vradi.register.ok"), 1);
                    ui.dispose();
                }
            } else {
                JOptionPane.showMessageDialog(ui, I18n._("vradi.register.password.error.message"), I18n._("vradi.register.password.error"), 0);
                ui.getPassword().grabFocus();
                ui.getPassword().setBorder(BorderFactory.createLineBorder(Color.RED));
                ui.getRepeatPassword().setBorder(BorderFactory.createLineBorder(Color.RED));
            }
        }
        catch (VradiException eee) {
            JOptionPane.showMessageDialog(ui, I18n._("vradi.register.password.error.message"), I18n._("vradi.register.password.error"), 0);
        }
    }
}

