/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.WebHarvestStream;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.AdminContentUI;
import com.jurismarches.vradi.ui.admin.content.XmlStreamConfigUI;
import com.jurismarches.vradi.ui.admin.models.XmlStreamFieldTableModel;
import com.jurismarches.vradi.ui.admin.renderers.JListCellRenderer;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.editors.JListCellEditor;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyExtension;

public class AdminXmlStreamUI
extends AdminContentUI<XmlStream>
implements JAXXValidator {
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_FORM_TYPE_SELECTION_MODEL = "formTypeSelectionModel";
    public static final String BINDING_ADMIN_XML_STREAM_UI_ENABLED = "adminXmlStreamUI.enabled";
    public static final String BINDING_CREATE_FORMS_ENABLED = "createForms.enabled";
    public static final String BINDING_CREATE_XML_STREAM_ENABLED = "createXmlStream.enabled";
    public static final String BINDING_FORM_TYPE_COMBO_SELECTED_ITEM = "formTypeCombo.selectedItem";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_VALIDATE_URL_ENABLED = "validateUrl.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";
    public static final String BINDING_WEB_HARVEST_STREAM_URL_TEXT = "webHarvestStreamUrl.text";
    public static final String BINDING_XML_STREAM_CONFIG_BEAN = "xmlStreamConfig.bean";
    public static final String BINDING_XML_STREAM_NAME_TEXT = "xmlStreamName.text";
    public static final String BINDING_XML_STREAM_URL_TEXT = "xmlStreamUrl.text";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JLABEL0_SIZE = "$JLabel0.size";
    private static final String BINDING_$JLABEL1_SIZE = "$JLabel1.size";
    private static final String BINDING_$JLABEL2_SIZE = "$JLabel2.size";
    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(AdminXmlStreamUI.class);
    private static final long serialVersionUID = 1L;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected Table adminXmlStreamForm;
    protected AdminXmlStreamUI adminXmlStreamUI = this;
    protected XmlStream bean;
    protected JPanel cards;
    protected JButton createForms;
    protected JButton createWebHarvestStream;
    protected JButton createXmlStream;
    protected XmlStreamFieldTableModel fieldsModel;
    protected JXTable fieldsTable;
    protected JComboBox formTypeCombo;
    protected ComboBoxModel formTypeSelectionModel;
    protected JLabel lblName;
    protected JButton openWebHarvestEditor;
    protected JButton openWebHarvestScript;
    protected JLabel title;
    protected JButton validateUrl;
    protected SwingValidator<XmlStream> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected JComboBox webHarvestScript;
    protected JTextField webHarvestStreamUrl;
    protected XmlStreamConfigUI xmlStreamConfig;
    protected JTextField xmlStreamName;
    protected JLabel xmlStreamPreview;
    protected JButton xmlStreamSite;
    protected JTextField xmlStreamUrl;
    private JPanel $JPanel0;
    private JButton $JButton0;
    private HidorButton $HidorButton0;
    private Table $Table0;
    private JLabel $JLabel0;
    private Table $Table1;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JScrollPane $JScrollPane0;
    static final String XML_STREAM_PANEL = "vradi.adminXmlStream.xmlPanel";
    static final String WEB_HARVEST_PANEL = "vradi.adminXmlStream.webHarvestPanel";

    void $afterCompleteSetup() {
        SwingUtil.setI18nTableHeaderRenderer((JTable)this.fieldsTable, (String[])new String[]{I18n.n_("vradi.adminXmlStream.table.field.name"), I18n.n_("vradi.adminXmlStream.table.field.name.tip"), I18n.n_("vradi.adminXmlStream.table.field.values"), I18n.n_("vradi.adminXmlStream.table.field.values.tip"), I18n.n_("vradi.adminXmlStream.table.field.defaultValue"), I18n.n_("vradi.adminXmlStream.table.field.defaultValue.tip")});
        DefaultTableCellRenderer tbc = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String sTranslatedValue = null;
                if (column == 0 && value != null) {
                    String sValue = (String)value;
                    int dot = sValue.lastIndexOf(".");
                    String extName = sValue.substring(0, dot);
                    sTranslatedValue = "Infogene".equals(extName) || "Form".equals(extName) ? I18n._(sValue) : sValue.substring(dot + 1);
                }
                return super.getTableCellRendererComponent(table, sTranslatedValue, isSelected, hasFocus, row, column);
            }
        };
        JListCellRenderer render = new JListCellRenderer(this.fieldsTable.getDefaultRenderer(String.class));
        this.setContextValue(render);
        SwingUtil.setTableColumnRenderer((JTable)this.fieldsTable, (int)0, (TableCellRenderer)tbc);
        SwingUtil.setTableColumnRenderer((JTable)this.fieldsTable, (int)1, (TableCellRenderer)render);
        JListCellEditor editor = new JListCellEditor();
        this.setContextValue(editor);
        SwingUtil.setTableColumnEditor((JTable)this.fieldsTable, (int)1, (TableCellEditor)editor);
        Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)HighlighterFactory.NOTEPAD, (Color)HighlighterFactory.GENERIC_GRAY);
        this.fieldsTable.addHighlighter(highlighter);
        this.errorTable.registerValidator(this.validator);
    }

    @Override
    protected void postLoadBean() {
        if (this.bean == null) {
            return;
        }
        this.getHandler().openAdminXmlStreamUI(this);
        this.xmlStreamPreview.setToolTipText(this.getFirstElementPreview());
    }

    protected void updateFormType() {
        WikittyExtension extension = (WikittyExtension)this.formTypeCombo.getSelectedItem();
        if (extension != null && this.bean != null) {
            this.bean.setFormTypeName(extension.getName());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AdminXmlStreamUI.this.validateFormTypeChoice();
                }
            });
            this.setModified(true);
        }
    }

    protected void validateFormTypeChoice() {
        this.stopEditing();
        boolean modified = this.isModified();
        this.getHandler().updateXmlStreamFieldModel((JAXXContext)this);
        this.setModified(modified);
        this.validate();
    }

    @Override
    public void save() {
        this.stopEditing();
        String login = this.getContextValue(VradiUser.class).getLogin();
        ModificationTag xmlStreamTag = (ModificationTag)VradiService.getWikittyProxy().cast((BusinessEntity)this.bean, ModificationTag.class);
        xmlStreamTag.setLastModified(new Date());
        xmlStreamTag.setLastModifier(login);
        this.setModified(false);
        XmlStream bean = this.getBean();
        this.setBean(null);
        bean = this.getHandler().saveStream(this, this.getHelper(), bean, this.fieldsModel.getBindings());
    }

    @Override
    protected void clearUI() {
        this.title.setText(this.updateTitle(""));
        this.xmlStreamName.setText("");
        this.xmlStreamUrl.setText("");
        this.webHarvestStreamUrl.setText("");
    }

    protected void initScriptComboBox() {
        this.getHandler().initScriptComboBox(this.webHarvestScript, (WebHarvestStream)this.getBean());
    }

    protected void stopEditing() {
        if (this.fieldsTable.getCellEditor() != null) {
            this.fieldsTable.getCellEditor().stopCellEditing();
        }
    }

    protected void createForms() {
        this.getHandler().createForms((JAXXContext)this);
    }

    protected String updateTitle(String name) {
        return I18n._("vradi.adminXmlStream.title", SwingUtil.getStringValue((Object)name));
    }

    protected void browseURI(String url) {
        try {
            UIHelper.browseURI(url);
        }
        catch (IOException eee) {
            log.error((Object)("Cannot display XMLStream : " + url));
            JOptionPane.showMessageDialog(null, I18n._("vradi.message.cannot.display.stream"));
        }
    }

    protected String getCardToDisplay() {
        if (this.getBean() instanceof WebHarvestStream) {
            return WEB_HARVEST_PANEL;
        }
        return XML_STREAM_PANEL;
    }

    protected String getFirstElementPreview() {
        return this.getHandler().getFirstElementPreview((JAXXContext)this, this.getBean());
    }

    protected void updateUrl() {
        this.getBean().setUrl(this.xmlStreamUrl.getText().matches("\\w+://.*") ? this.xmlStreamUrl.getText() : "http://" + this.xmlStreamUrl.getText());
        this.xmlStreamPreview.setToolTipText(this.getFirstElementPreview());
    }

    protected void updateWebHarvestUrl() {
        this.getBean().setUrl(this.webHarvestStreamUrl.getText().matches("\\w+://.*") ? this.webHarvestStreamUrl.getText() : "http://" + this.webHarvestStreamUrl.getText());
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public AdminXmlStreamUI() {
        this.$initialize();
    }

    public AdminXmlStreamUI(JAXXContext parentContext) {
        super(parentContext);
        this.$initialize();
    }

    public SwingValidator<XmlStream> getValidator() {
        return this.validator;
    }

    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator)(this.validatorIds.contains(validatorId) ? this.getObjectById(validatorId) : null);
    }

    public List<String> getValidatorIds() {
        return this.validatorIds;
    }

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        this.getHandler().delete(this, this.getHelper(), this.getBean());
    }

    public void doActionPerformed__on__createForms(ActionEvent event) {
        this.createForms();
    }

    public void doActionPerformed__on__createWebHarvestStream(ActionEvent event) {
        this.getHandler().createWebHarvestStream(this);
    }

    public void doActionPerformed__on__createXmlStream(ActionEvent event) {
        this.getHandler().createXmlStream(this);
    }

    public void doActionPerformed__on__formTypeCombo(ActionEvent event) {
        this.updateFormType();
    }

    public void doActionPerformed__on__openWebHarvestEditor(ActionEvent event) {
        this.getHandler().openWebHarvestEditor((JAXXContext)this);
    }

    public void doActionPerformed__on__openWebHarvestScript(ActionEvent event) {
        this.getHandler().addWebHarvestScript((JAXXContext)this, (WebHarvestStream)this.getBean());
        this.initScriptComboBox();
    }

    public void doActionPerformed__on__validateUrl(ActionEvent event) {
        this.validateFormTypeChoice();
    }

    public void doActionPerformed__on__xmlStreamSite(ActionEvent event) {
        this.browseURI(this.getBean().getUrl());
    }

    public void doKeyReleased__on__webHarvestStreamUrl(KeyEvent event) {
        this.updateWebHarvestUrl();
    }

    public void doKeyReleased__on__xmlStreamName(KeyEvent event) {
        this.getBean().setName(this.xmlStreamName.getText());
        this.title.setText(this.updateTitle(this.getBean().getName()));
    }

    public void doKeyReleased__on__xmlStreamUrl(KeyEvent event) {
        this.updateUrl();
    }

    public void doTableChanged__on__fieldsModel(TableModelEvent event) {
        this.setModified(true);
    }

    public Table getAdminXmlStreamForm() {
        return this.adminXmlStreamForm;
    }

    @Override
    public XmlStream getBean() {
        return this.bean;
    }

    public JPanel getCards() {
        return this.cards;
    }

    public JButton getCreateForms() {
        return this.createForms;
    }

    public JButton getCreateWebHarvestStream() {
        return this.createWebHarvestStream;
    }

    public JButton getCreateXmlStream() {
        return this.createXmlStream;
    }

    public XmlStreamFieldTableModel getFieldsModel() {
        return this.fieldsModel;
    }

    public JXTable getFieldsTable() {
        return this.fieldsTable;
    }

    public JComboBox getFormTypeCombo() {
        return this.formTypeCombo;
    }

    public ComboBoxModel getFormTypeSelectionModel() {
        return this.formTypeSelectionModel;
    }

    public JLabel getLblName() {
        return this.lblName;
    }

    public JButton getOpenWebHarvestEditor() {
        return this.openWebHarvestEditor;
    }

    public JButton getOpenWebHarvestScript() {
        return this.openWebHarvestScript;
    }

    public JLabel getTitle() {
        return this.title;
    }

    public JButton getValidateUrl() {
        return this.validateUrl;
    }

    public JComboBox getWebHarvestScript() {
        return this.webHarvestScript;
    }

    public JTextField getWebHarvestStreamUrl() {
        return this.webHarvestStreamUrl;
    }

    public XmlStreamConfigUI getXmlStreamConfig() {
        return this.xmlStreamConfig;
    }

    public JTextField getXmlStreamName() {
        return this.xmlStreamName;
    }

    public JLabel getXmlStreamPreview() {
        return this.xmlStreamPreview;
    }

    public JButton getXmlStreamSite() {
        return this.xmlStreamSite;
    }

    public JTextField getXmlStreamUrl() {
        return this.xmlStreamUrl;
    }

    @Override
    public void setBean(XmlStream newValue) {
        XmlStream oldValue = this.bean;
        this.bean = newValue;
        this.firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setFormTypeSelectionModel(ComboBoxModel newValue) {
        ComboBoxModel oldValue = this.formTypeSelectionModel;
        this.formTypeSelectionModel = newValue;
        this.firePropertyChange(PROPERTY_FORM_TYPE_SELECTION_MODEL, oldValue, newValue);
    }

    public void registerValidatorFields() {
        this.validator.setFieldRepresentation("formTypeName", (JComponent)this.formTypeCombo);
        this.validator.setFieldRepresentation("name", (JComponent)this.xmlStreamName);
        this.validator.setFieldRepresentation("url", (JComponent)this.xmlStreamUrl);
    }

    protected JPanel get$JPanel0() {
        return this.$JPanel0;
    }

    protected JButton get$JButton0() {
        return this.$JButton0;
    }

    protected HidorButton get$HidorButton0() {
        return this.$HidorButton0;
    }

    protected Table get$Table0() {
        return this.$Table0;
    }

    protected JLabel get$JLabel0() {
        return this.$JLabel0;
    }

    protected Table get$Table1() {
        return this.$Table1;
    }

    protected JLabel get$JLabel1() {
        return this.$JLabel1;
    }

    protected JLabel get$JLabel2() {
        return this.$JLabel2;
    }

    protected JLabel get$JLabel3() {
        return this.$JLabel3;
    }

    protected JScrollPane get$JScrollPane0() {
        return this.$JScrollPane0;
    }

    protected void addChildrenToAdminXmlStreamForm() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.adminXmlStreamForm.add((Component)this.lblName, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.adminXmlStreamForm.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.xmlStreamName), (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.adminXmlStreamForm.add((Component)this.cards, (Object)new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.adminXmlStreamForm.add((Component)this.$JLabel3, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.adminXmlStreamForm.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.formTypeCombo), (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.adminXmlStreamForm.add((Component)this.validateUrl, (Object)new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.adminXmlStreamForm.add((Component)this.xmlStreamConfig, (Object)new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.body.add((Component)this.adminXmlStreamForm, "North");
        this.body.add((Component)this.$JScrollPane0, "Center");
    }

    protected void addChildrenToCards() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.cards.add((Component)this.$Table0, XML_STREAM_PANEL);
        this.cards.add((Component)this.$Table1, WEB_HARVEST_PANEL);
    }

    protected void addChildrenToToolbar() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.toolbar.add((Component)this.title, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.toolbar.add((Component)this.$JPanel0, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.validator.setUiClass(ImageValidationUI.class);
    }

    protected void createAdminXmlStreamForm() {
        this.adminXmlStreamForm = new Table();
        this.$objectMap.put("adminXmlStreamForm", this.adminXmlStreamForm);
        this.adminXmlStreamForm.setName("adminXmlStreamForm");
    }

    protected void createBean() {
        this.bean = null;
        this.$objectMap.put(PROPERTY_BEAN, null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        this.body.setName("body");
    }

    protected void createCards() {
        this.cards = new JPanel();
        this.$objectMap.put("cards", this.cards);
        this.cards.setName("cards");
        this.cards.setLayout(new CardLayout());
    }

    protected void createCreateForms() {
        this.createForms = new JButton();
        this.$objectMap.put("createForms", this.createForms);
        this.createForms.setName("createForms");
        this.createForms.setText(I18n._("vradi.adminXmlStream.createForms"));
        this.createForms.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__createForms"));
    }

    protected void createCreateWebHarvestStream() {
        this.createWebHarvestStream = new JButton();
        this.$objectMap.put("createWebHarvestStream", this.createWebHarvestStream);
        this.createWebHarvestStream.setName("createWebHarvestStream");
        this.createWebHarvestStream.setText(I18n._("vradi.adminXmlStream.createWebHarvestStream"));
        this.createWebHarvestStream.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__createWebHarvestStream"));
    }

    protected void createCreateXmlStream() {
        this.createXmlStream = new JButton();
        this.$objectMap.put("createXmlStream", this.createXmlStream);
        this.createXmlStream.setName("createXmlStream");
        this.createXmlStream.setText(I18n._("vradi.adminXmlStream.createXmlStream"));
        this.createXmlStream.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__createXmlStream"));
    }

    protected void createFieldsModel() {
        this.fieldsModel = new XmlStreamFieldTableModel();
        this.$objectMap.put("fieldsModel", this.fieldsModel);
        this.fieldsModel.addTableModelListener((TableModelListener)JAXXUtil.getEventListener(TableModelListener.class, (String)"tableChanged", (Object)this, (String)"doTableChanged__on__fieldsModel"));
    }

    protected void createFieldsTable() {
        this.fieldsTable = new JXTable();
        this.$objectMap.put("fieldsTable", this.fieldsTable);
        this.fieldsTable.setName("fieldsTable");
        if (this.fieldsTable.getFont() != null) {
            this.fieldsTable.setFont(this.fieldsTable.getFont().deriveFont(11.0f));
        }
        this.fieldsTable.setRowSelectionAllowed(false);
    }

    protected void createFormTypeCombo() {
        this.formTypeCombo = new JComboBox();
        this.$objectMap.put("formTypeCombo", this.formTypeCombo);
        this.formTypeCombo.setName("formTypeCombo");
        this.formTypeCombo.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__formTypeCombo"));
    }

    protected void createFormTypeSelectionModel() {
        this.formTypeSelectionModel = UIHelper.getFormTypesModel();
        this.$objectMap.put(PROPERTY_FORM_TYPE_SELECTION_MODEL, this.formTypeSelectionModel);
    }

    protected void createLblName() {
        this.lblName = new JLabel();
        this.$objectMap.put("lblName", this.lblName);
        this.lblName.setName("lblName");
        this.lblName.setText(I18n._("vradi.adminXmlStream.name"));
    }

    protected void createOpenWebHarvestEditor() {
        this.openWebHarvestEditor = new JButton();
        this.$objectMap.put("openWebHarvestEditor", this.openWebHarvestEditor);
        this.openWebHarvestEditor.setName("openWebHarvestEditor");
        this.openWebHarvestEditor.setToolTipText(I18n._("vradi.adminXmlStream.createNewWebHarvest.toolTip"));
        this.openWebHarvestEditor.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__openWebHarvestEditor"));
    }

    protected void createOpenWebHarvestScript() {
        this.openWebHarvestScript = new JButton();
        this.$objectMap.put("openWebHarvestScript", this.openWebHarvestScript);
        this.openWebHarvestScript.setName("openWebHarvestScript");
        this.openWebHarvestScript.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__openWebHarvestScript"));
    }

    protected void createTitle() {
        this.title = new JLabel();
        this.$objectMap.put("title", this.title);
        this.title.setName("title");
        if (this.title.getFont() != null) {
            this.title.setFont(this.title.getFont().deriveFont(20.0f));
        }
        if (this.title.getFont() != null) {
            this.title.setFont(this.title.getFont().deriveFont(this.title.getFont().getStyle() | 1));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        this.toolbar.setName("toolbar");
        this.toolbar.setLayout((LayoutManager)new BoxLayout((Container)this.toolbar, 0));
        this.toolbar.putClientProperty((Object)"help", (Object)"ui.main.toolbar");
    }

    protected void createValidateUrl() {
        this.validateUrl = new JButton();
        this.$objectMap.put("validateUrl", this.validateUrl);
        this.validateUrl.setName("validateUrl");
        this.validateUrl.setText(I18n._("vradi.adminXmlStream.validateUrl"));
        this.validateUrl.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__validateUrl"));
    }

    protected void createValidator() {
        this.validator = new SwingValidator(XmlStream.class, null);
        this.$objectMap.put("validator", this.validator);
    }

    protected void createWebHarvestScript() {
        this.webHarvestScript = new JComboBox();
        this.$objectMap.put("webHarvestScript", this.webHarvestScript);
        this.webHarvestScript.setName("webHarvestScript");
    }

    protected void createWebHarvestStreamUrl() {
        this.webHarvestStreamUrl = new JTextField();
        this.$objectMap.put("webHarvestStreamUrl", this.webHarvestStreamUrl);
        this.webHarvestStreamUrl.setName("webHarvestStreamUrl");
        this.webHarvestStreamUrl.setColumns(15);
        this.webHarvestStreamUrl.addKeyListener((KeyListener)JAXXUtil.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this, (String)"doKeyReleased__on__webHarvestStreamUrl"));
    }

    protected void createXmlStreamConfig() {
        this.xmlStreamConfig = new XmlStreamConfigUI();
        this.$objectMap.put("xmlStreamConfig", this.xmlStreamConfig);
        this.xmlStreamConfig.setName("xmlStreamConfig");
    }

    protected void createXmlStreamName() {
        this.xmlStreamName = new JTextField();
        this.$objectMap.put("xmlStreamName", this.xmlStreamName);
        this.xmlStreamName.setName("xmlStreamName");
        this.xmlStreamName.setColumns(15);
        this.xmlStreamName.addKeyListener((KeyListener)JAXXUtil.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this, (String)"doKeyReleased__on__xmlStreamName"));
    }

    protected void createXmlStreamPreview() {
        this.xmlStreamPreview = new JLabel();
        this.$objectMap.put("xmlStreamPreview", this.xmlStreamPreview);
        this.xmlStreamPreview.setName("xmlStreamPreview");
    }

    protected void createXmlStreamSite() {
        this.xmlStreamSite = new JButton();
        this.$objectMap.put("xmlStreamSite", this.xmlStreamSite);
        this.xmlStreamSite.setName("xmlStreamSite");
        this.xmlStreamSite.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__xmlStreamSite"));
    }

    protected void createXmlStreamUrl() {
        this.xmlStreamUrl = new JTextField();
        this.$objectMap.put("xmlStreamUrl", this.xmlStreamUrl);
        this.xmlStreamUrl.setName("xmlStreamUrl");
        this.xmlStreamUrl.setColumns(15);
        this.xmlStreamUrl.addKeyListener((KeyListener)JAXXUtil.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this, (String)"doKeyReleased__on__xmlStreamUrl"));
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        this.addChildrenToValidator();
        this.addChildrenToToolbar();
        this.$JPanel0.add(this.createXmlStream);
        this.$JPanel0.add(this.createWebHarvestStream);
        this.$JPanel0.add(this.createForms);
        this.$JPanel0.add(this.$JButton0);
        this.$JPanel0.add((Component)this.$HidorButton0);
        this.addChildrenToBody();
        this.addChildrenToAdminXmlStreamForm();
        this.addChildrenToCards();
        this.$Table0.add((Component)this.$JLabel0, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.xmlStreamUrl), (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.xmlStreamPreview, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.xmlStreamSite, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.$JLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.webHarvestStreamUrl, (Object)new GridBagConstraints(1, 0, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.$JLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.webHarvestScript, (Object)new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.openWebHarvestScript, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.openWebHarvestEditor, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$JScrollPane0.getViewport().add((Component)this.fieldsTable);
        JAXXUtil.applyDataBinding((JAXXObject)this, this.$bindings.keySet());
        this.createXmlStream.setIcon(SwingUtil.getUIManagerActionIcon((String)"feed.add"));
        this.createWebHarvestStream.setIcon(SwingUtil.getUIManagerActionIcon((String)"feed.add"));
        this.$JButton0.setIcon(SwingUtil.getUIManagerActionIcon((String)"feed.delete"));
        this.$HidorButton0.setHideTip(I18n._("vradi.adminXmlStream.hideForm"));
        this.$HidorButton0.setShowTip(I18n._("vradi.adminXmlStream.showForm"));
        this.$HidorButton0.setTarget((JComponent)this.adminXmlStreamForm);
        this.$HidorButton0.setTargetVisible(Boolean.valueOf(true));
        this.adminXmlStreamForm.setMinimumSize(SwingUtil.newMinDimension());
        this.xmlStreamPreview.setIcon(SwingUtil.getUIManagerActionIcon((String)"feed.magnify"));
        this.xmlStreamPreview.setToolTipText(I18n._(this.getFirstElementPreview()));
        this.xmlStreamSite.setIcon(SwingUtil.getUIManagerActionIcon((String)"site"));
        this.openWebHarvestScript.setIcon(SwingUtil.getUIManagerActionIcon((String)"open"));
        this.openWebHarvestEditor.setIcon(SwingUtil.getUIManagerActionIcon((String)"edit"));
        this.formTypeCombo.setModel(this.formTypeSelectionModel);
        this.formTypeCombo.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        this.fieldsTable.setModel((TableModel)this.fieldsModel);
        this.title.setHorizontalAlignment(2);
        this.title.setHorizontalTextPosition(2);
        this.registerValidatorFields();
        this.validatorIds.add("validator");
        this.getValidator("validator").installUIs();
        this.getValidator("validator").reloadBean();
        this.validatorIds = Collections.unmodifiableList(this.validatorIds);
        this.$afterCompleteSetup();
    }

    private void $initialize() {
        if (this.allComponentsCreated || !this.contextInitialized) {
            return;
        }
        this.$objectMap.put("adminXmlStreamUI", this);
        this.createBean();
        this.createFieldsModel();
        this.createFormTypeSelectionModel();
        this.createValidator();
        this.createTitle();
        this.$JPanel0 = new JPanel();
        this.$objectMap.put("$JPanel0", this.$JPanel0);
        this.$JPanel0.setName("$JPanel0");
        this.createCreateXmlStream();
        this.createCreateWebHarvestStream();
        this.createCreateForms();
        this.$JButton0 = new JButton();
        this.$objectMap.put("$JButton0", this.$JButton0);
        this.$JButton0.setName("$JButton0");
        this.$JButton0.setToolTipText(I18n._("vradi.adminXmlStream.deleteXmlStream"));
        this.$JButton0.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__$JButton0"));
        this.$HidorButton0 = new HidorButton();
        this.$objectMap.put("$HidorButton0", this.$HidorButton0);
        this.$HidorButton0.setName("$HidorButton0");
        this.createAdminXmlStreamForm();
        this.createLblName();
        this.createXmlStreamName();
        this.createCards();
        this.$Table0 = new Table();
        this.$objectMap.put("$Table0", this.$Table0);
        this.$Table0.setName("$Table0");
        this.$JLabel0 = new JLabel();
        this.$objectMap.put("$JLabel0", this.$JLabel0);
        this.$JLabel0.setName("$JLabel0");
        this.$JLabel0.setText(I18n._("vradi.adminXmlStream.url"));
        this.createXmlStreamUrl();
        this.createXmlStreamPreview();
        this.createXmlStreamSite();
        this.$Table1 = new Table();
        this.$objectMap.put("$Table1", this.$Table1);
        this.$Table1.setName("$Table1");
        this.$JLabel1 = new JLabel();
        this.$objectMap.put("$JLabel1", this.$JLabel1);
        this.$JLabel1.setName("$JLabel1");
        this.$JLabel1.setText(I18n._("vradi.adminXmlStream.startUrl"));
        this.createWebHarvestStreamUrl();
        this.$JLabel2 = new JLabel();
        this.$objectMap.put("$JLabel2", this.$JLabel2);
        this.$JLabel2.setName("$JLabel2");
        this.$JLabel2.setText(I18n._("vradi.adminXmlStream.webHarvestScript"));
        this.createWebHarvestScript();
        this.createOpenWebHarvestScript();
        this.createOpenWebHarvestEditor();
        this.$JLabel3 = new JLabel();
        this.$objectMap.put("$JLabel3", this.$JLabel3);
        this.$JLabel3.setName("$JLabel3");
        this.$JLabel3.setText(I18n._("vradi.adminXmlStream.formType"));
        this.createFormTypeCombo();
        this.createValidateUrl();
        this.createXmlStreamConfig();
        this.$JScrollPane0 = new JScrollPane();
        this.$objectMap.put("$JScrollPane0", this.$JScrollPane0);
        this.$JScrollPane0.setName("$JScrollPane0");
        this.createFieldsTable();
        this.setName("adminXmlStreamUI");
        ((Table)this.adminXmlStreamUI.getObjectById("toolbar")).setLayout((LayoutManager)new BoxLayout((Container)this.toolbar, 0));
        this.$registerDefaultBindings();
        this.$completeSetup();
    }

    private void $registerDefaultBindings() {
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_ADMIN_XML_STREAM_UI_ENABLED, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                AdminXmlStreamUI.this.setEnabled(AdminXmlStreamUI.this.getBean() != null);
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true, new String[]{"enabled"}){

            public void processDataBinding() {
                AdminXmlStreamUI.this.validator.setBean(AdminXmlStreamUI.this.isEnabled() ? AdminXmlStreamUI.this.bean : null);
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_TITLE_TEXT, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                if (AdminXmlStreamUI.this.getBean() != null) {
                    AdminXmlStreamUI.this.title.setText(I18n._(AdminXmlStreamUI.this.updateTitle(AdminXmlStreamUI.this.getBean().getName())));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_CREATE_XML_STREAM_ENABLED, true, new String[]{"inCreation"}){

            public void processDataBinding() {
                AdminXmlStreamUI.this.createXmlStream.setEnabled(!AdminXmlStreamUI.this.isInCreation());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_CREATE_FORMS_ENABLED, true, new String[]{"enabled", "valide"}){

            public void processDataBinding() {
                AdminXmlStreamUI.this.createForms.setEnabled(AdminXmlStreamUI.this.isEnabled() && AdminXmlStreamUI.this.isValide() != false);
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true, new String[]{"enabled"}){

            public void processDataBinding() {
                AdminXmlStreamUI.this.$JButton0.setEnabled(AdminXmlStreamUI.this.isEnabled());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_XML_STREAM_NAME_TEXT, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                if (AdminXmlStreamUI.this.getBean() != null) {
                    SwingUtil.setText((JTextComponent)AdminXmlStreamUI.this.xmlStreamName, (String)AdminXmlStreamUI.this.getBean().getName());
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_$JLABEL0_SIZE, true){

            public void applyDataBinding() {
                if (AdminXmlStreamUI.this.lblName != null) {
                    AdminXmlStreamUI.this.$bindingSources.put("lblName", AdminXmlStreamUI.this.lblName);
                    AdminXmlStreamUI.this.lblName.addComponentListener((ComponentListener)JAXXUtil.getEventListener(ComponentListener.class, (Object)((Object)this), (String)"$pr$u0"));
                }
            }

            public void processDataBinding() {
                if (AdminXmlStreamUI.this.lblName != null) {
                    AdminXmlStreamUI.this.$JLabel0.setSize(AdminXmlStreamUI.this.lblName.getSize());
                }
            }

            public void removeDataBinding() {
                JLabel $target;
                if (AdminXmlStreamUI.this.lblName != null && ($target = (JLabel)AdminXmlStreamUI.this.$bindingSources.remove("lblName")) != null) {
                    $target.removeComponentListener((ComponentListener)JAXXUtil.getEventListener(ComponentListener.class, (Object)((Object)this), (String)"$pr$u0"));
                }
            }

            public void $pr$u0(ComponentEvent event) {
                this.propertyChange(null);
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_XML_STREAM_URL_TEXT, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                if (AdminXmlStreamUI.this.getBean() != null) {
                    SwingUtil.setText((JTextComponent)AdminXmlStreamUI.this.xmlStreamUrl, (String)AdminXmlStreamUI.this.getBean().getUrl());
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_$JLABEL1_SIZE, true){

            public void applyDataBinding() {
                if (AdminXmlStreamUI.this.lblName != null) {
                    AdminXmlStreamUI.this.$bindingSources.put("lblName", AdminXmlStreamUI.this.lblName);
                    AdminXmlStreamUI.this.lblName.addComponentListener((ComponentListener)JAXXUtil.getEventListener(ComponentListener.class, (Object)((Object)this), (String)"$pr$u1"));
                }
            }

            public void processDataBinding() {
                if (AdminXmlStreamUI.this.lblName != null) {
                    AdminXmlStreamUI.this.$JLabel1.setSize(AdminXmlStreamUI.this.lblName.getSize());
                }
            }

            public void removeDataBinding() {
                JLabel $target;
                if (AdminXmlStreamUI.this.lblName != null && ($target = (JLabel)AdminXmlStreamUI.this.$bindingSources.remove("lblName")) != null) {
                    $target.removeComponentListener((ComponentListener)JAXXUtil.getEventListener(ComponentListener.class, (Object)((Object)this), (String)"$pr$u1"));
                }
            }

            public void $pr$u1(ComponentEvent event) {
                this.propertyChange(null);
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_WEB_HARVEST_STREAM_URL_TEXT, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                if (AdminXmlStreamUI.this.getBean() != null) {
                    SwingUtil.setText((JTextComponent)AdminXmlStreamUI.this.webHarvestStreamUrl, (String)AdminXmlStreamUI.this.getBean().getUrl());
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_$JLABEL2_SIZE, true){

            public void applyDataBinding() {
                if (AdminXmlStreamUI.this.lblName != null) {
                    AdminXmlStreamUI.this.$bindingSources.put("lblName", AdminXmlStreamUI.this.lblName);
                    AdminXmlStreamUI.this.lblName.addComponentListener((ComponentListener)JAXXUtil.getEventListener(ComponentListener.class, (Object)((Object)this), (String)"$pr$u2"));
                }
            }

            public void processDataBinding() {
                if (AdminXmlStreamUI.this.lblName != null) {
                    AdminXmlStreamUI.this.$JLabel2.setSize(AdminXmlStreamUI.this.lblName.getSize());
                }
            }

            public void removeDataBinding() {
                JLabel $target;
                if (AdminXmlStreamUI.this.lblName != null && ($target = (JLabel)AdminXmlStreamUI.this.$bindingSources.remove("lblName")) != null) {
                    $target.removeComponentListener((ComponentListener)JAXXUtil.getEventListener(ComponentListener.class, (Object)((Object)this), (String)"$pr$u2"));
                }
            }

            public void $pr$u2(ComponentEvent event) {
                this.propertyChange(null);
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_FORM_TYPE_COMBO_SELECTED_ITEM, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                if (AdminXmlStreamUI.this.getBean() != null) {
                    AdminXmlStreamUI.this.formTypeCombo.setSelectedItem(AdminXmlStreamUI.this.getHandler().getExtension(AdminXmlStreamUI.this.getBean().getFormTypeName()));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_VALIDATE_URL_ENABLED, true, new String[]{"enabled", "valide"}){

            public void processDataBinding() {
                AdminXmlStreamUI.this.validateUrl.setEnabled(AdminXmlStreamUI.this.isEnabled() && AdminXmlStreamUI.this.isValide() != false);
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_XML_STREAM_CONFIG_BEAN, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                AdminXmlStreamUI.this.xmlStreamConfig.setBean(AdminXmlStreamUI.this.getBean());
            }
        });
    }
}

